/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class KubernetesClientProvider {
    private static final Logger LOGGER = Logger.getLogger(KubernetesClientProvider.class.getName());
    private static final long CACHE_EXPIRATION = Long.getLong(KubernetesClientProvider.class.getPackage().getName() + ".clients.cacheExpiration", TimeUnit.MINUTES.toSeconds(10L));
    private static final Cache<String, Client> clients = Caffeine.newBuilder().expireAfterWrite(CACHE_EXPIRATION, TimeUnit.SECONDS).removalListener((key, value, cause) -> {
        Client client = (Client)value;
        if (client != null) {
            LOGGER.log(Level.FINE, () -> "Closing Kubernetes client " + String.valueOf(key) + " " + String.valueOf(client.client) + ": " + String.valueOf(cause));
            client.client.close();
        }
    }).build();

    private KubernetesClientProvider() {
    }

    static KubernetesClient createClient(KubernetesCloud cloud) throws KubernetesAuthException, IOException {
        String displayName = cloud.getDisplayName();
        Client c = (Client)clients.getIfPresent((Object)displayName);
        int validity = KubernetesClientProvider.getValidity(cloud);
        if (c == null || c.getValidity() != validity) {
            KubernetesClient client = new KubernetesFactoryAdapter(cloud.getServerUrl(), cloud.getNamespace(), cloud.getServerCertificate(), cloud.getCredentialsId(), cloud.isSkipTlsVerify(), cloud.getConnectTimeout(), cloud.getReadTimeout(), cloud.getMaxRequestsPerHost(), cloud.isUseJenkinsProxy()).createClient();
            clients.put((Object)displayName, (Object)new Client(validity, client));
            LOGGER.log(Level.FINE, "Created new Kubernetes client: {0} {1}", new Object[]{displayName, client});
            return client;
        }
        return c.getClient();
    }

    @Restricted(value={NoExternalUse.class})
    public static int getValidity(@NonNull KubernetesCloud cloud) {
        Object[] cloudObjects = new Object[]{cloud.getServerUrl(), cloud.getNamespace(), cloud.getServerCertificate(), cloud.getCredentialsId(), cloud.isSkipTlsVerify(), cloud.getConnectTimeout(), cloud.getReadTimeout(), cloud.getMaxRequestsPerHostStr(), cloud.isUseJenkinsProxy()};
        return Arrays.hashCode(cloudObjects);
    }

    @Restricted(value={NoExternalUse.class})
    public static void invalidate(String displayName) {
        clients.invalidate((Object)displayName);
    }

    @Restricted(value={NoExternalUse.class})
    public static void invalidateAll() {
        clients.invalidateAll();
    }

    private static class Client {
        private final KubernetesClient client;
        private final int validity;

        public Client(int validity, KubernetesClient client) {
            this.client = client;
            this.validity = validity;
        }

        public KubernetesClient getClient() {
            return this.client;
        }

        public int getValidity() {
            return this.validity;
        }
    }

    @Extension(ordinal=-1.0)
    public static class SaveableListenerImpl
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (o instanceof Jenkins) {
                Jenkins jenkins = (Jenkins)o;
                HashSet cloudDisplayNames = new HashSet(clients.asMap().keySet());
                for (KubernetesCloud cloud : jenkins.clouds.getAll(KubernetesCloud.class)) {
                    String displayName = cloud.getDisplayName();
                    Client client = (Client)clients.getIfPresent((Object)displayName);
                    if (client != null && client.getValidity() != KubernetesClientProvider.getValidity(cloud)) continue;
                    cloudDisplayNames.remove(displayName);
                }
                for (String displayName : cloudDisplayNames) {
                    LOGGER.log(Level.INFO, () -> "Invalidating Kubernetes client: " + displayName + String.valueOf(clients.getIfPresent((Object)displayName)));
                    KubernetesClientProvider.invalidate(displayName);
                }
            }
            super.onChange(o, file);
        }
    }
}

