/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Objects;
import org.csanchez.jenkins.plugins.kubernetes.volumes.DynamicPVC;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PVCVolumeUtils;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Deprecated
@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class DynamicPVCWorkspaceVolume
extends WorkspaceVolume
implements DynamicPVC {
    private String storageClassName;
    private String requestsSize;
    private String accessModes;

    @DataBoundConstructor
    public DynamicPVCWorkspaceVolume() {
    }

    @Override
    @CheckForNull
    public String getAccessModes() {
        return this.accessModes;
    }

    @DataBoundSetter
    public void setAccessModes(@CheckForNull String accessModes) {
        this.accessModes = Util.fixEmpty((String)accessModes);
    }

    @Override
    @CheckForNull
    public String getRequestsSize() {
        return this.requestsSize;
    }

    @DataBoundSetter
    public void setRequestsSize(@CheckForNull String requestsSize) {
        this.requestsSize = Util.fixEmpty((String)requestsSize);
    }

    @Override
    @CheckForNull
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @DataBoundSetter
    public void setStorageClassName(@CheckForNull String storageClassName) {
        this.storageClassName = Util.fixEmpty((String)storageClassName);
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return this.buildPVC(volumeName, podName);
    }

    @Override
    public PersistentVolumeClaim createVolume(KubernetesClient client, ObjectMeta podMetaData) {
        return this.createPVC(client, podMetaData);
    }

    @Override
    @NonNull
    public String getPvcName(String podName) {
        return "pvc-workspace-" + podName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicPVCWorkspaceVolume that = (DynamicPVCWorkspaceVolume)o;
        return Objects.equals(this.storageClassName, that.storageClassName) && Objects.equals(this.requestsSize, that.requestsSize) && Objects.equals(this.accessModes, that.accessModes);
    }

    public int hashCode() {
        return Objects.hash(this.storageClassName, this.requestsSize, this.accessModes);
    }

    @Extension(ordinal=-100.0)
    @Symbol(value={"dynamicPVC"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "Dynamic Persistent Volume Claim (deprecated)";
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public ListBoxModel doFillAccessModesItems() {
            return PVCVolumeUtils.ACCESS_MODES_BOX;
        }
    }
}

