/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.volumes.ProvisionedVolume;

public interface DynamicPVC
extends ProvisionedVolume {
    public static final Logger LOGGER = Logger.getLogger(DynamicPVC.class.getName());

    default public Volume buildPVC(String volumeName, String podName) {
        String pvcName = this.getPvcName(podName);
        return ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewPersistentVolumeClaim().withClaimName(pvcName)).withReadOnly(Boolean.valueOf(false))).endPersistentVolumeClaim()).build();
    }

    default public PersistentVolumeClaim createPVC(KubernetesClient client, ObjectMeta podMetaData) {
        String namespace = podMetaData.getNamespace();
        String podName = podMetaData.getName();
        LOGGER.log(Level.FINE, "Adding volume for pod: {0}/{1}", new Object[]{namespace, podName});
        OwnerReference ownerReference = ((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withApiVersion("v1")).withKind("Pod")).withController(Boolean.valueOf(true))).withName(podMetaData.getName())).withUid(podMetaData.getUid())).build();
        String pvcName = this.getPvcName(podMetaData.getName());
        PersistentVolumeClaim pvc = ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName(pvcName)).withLabels(podMetaData.getLabels())).withOwnerReferences(new OwnerReference[]{ownerReference})).endMetadata()).withNewSpec().withAccessModes(new String[]{this.getAccessModesOrDefault()})).withNewResources().withRequests(this.getResourceMap())).endResources()).withStorageClassName(this.getStorageClassNameOrDefault())).endSpec()).build();
        pvc = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)client.persistentVolumeClaims().inNamespace(podMetaData.getNamespace())).resource((Object)pvc)).create();
        LOGGER.log(Level.INFO, "Created PVC: {0}/{1}", new Object[]{namespace, pvcName});
        return pvc;
    }

    public String getPvcName(String var1);
}

