/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.remoting.Channel;
import hudson.util.LogTaskListener;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.DynamicContext;

public final class SecretsMasker
extends TaskListenerDecorator {
    private static final Logger LOGGER = Logger.getLogger(SecretsMasker.class.getName());
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;

    private SecretsMasker(Set<String> values) {
        assert (!values.isEmpty());
        this.pattern = SecretPatterns.getAggregateSecretPattern(values);
    }

    public OutputStream decorate(OutputStream logger) throws IOException, InterruptedException {
        return new SecretPatterns.MaskingOutputStream(logger, () -> this.pattern, "UTF-8");
    }

    @Extension
    public static final class Factory
    extends DynamicContext.Typed<TaskListenerDecorator> {
        private final Map<KubernetesComputer, Set<String>> secrets = new WeakHashMap<KubernetesComputer, Set<String>>();

        protected Class<TaskListenerDecorator> type() {
            return TaskListenerDecorator.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TaskListenerDecorator get(DynamicContext.DelegatedContext context) throws IOException, InterruptedException {
            KubernetesComputer c;
            try {
                c = (KubernetesComputer)((Object)context.get(KubernetesComputer.class));
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.FINE, "Unable to look up KubernetesComputer", x);
                return null;
            }
            if (c == null) {
                return null;
            }
            Map<KubernetesComputer, Set<String>> x = this.secrets;
            synchronized (x) {
                if (this.secrets.containsKey((Object)c)) {
                    Set<String> values = this.secrets.get((Object)c);
                    if (values != null) {
                        LOGGER.log(Level.FINE, "Using cached secrets for {0}", (Object)c);
                        return TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)context.get(TaskListenerDecorator.class)), (TaskListenerDecorator)new SecretsMasker(values));
                    }
                    LOGGER.log(Level.FINE, "Cached absence of secrets for {0}", (Object)c);
                    return null;
                }
            }
            Set<String> values = Factory.secretsOf(c);
            Map<KubernetesComputer, Set<String>> map = this.secrets;
            synchronized (map) {
                this.secrets.put(c, values);
            }
            if (values != null) {
                LOGGER.fine("masking " + values.size() + " values");
                return TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)context.get(TaskListenerDecorator.class)), (TaskListenerDecorator)new SecretsMasker(values));
            }
            LOGGER.fine("no values to mask");
            return null;
        }

        @CheckForNull
        private static Set<String> secretsOf(KubernetesComputer c) throws IOException, InterruptedException {
            Channel ch = c.getChannel();
            if (ch == null) {
                return null;
            }
            KubernetesSlave slave = (KubernetesSlave)c.getNode();
            if (slave == null) {
                return null;
            }
            PodTemplate template = slave.getTemplateOrNull();
            if (template == null) {
                return null;
            }
            Pod pod = template.build(slave);
            HashSet<String> values = new HashSet<String>();
            values.add(c.getJnlpMac());
            LOGGER.finer(() -> "inspecting " + Serialization.asYaml((Object)pod));
            for (Container container : pod.getSpec().getContainers()) {
                TreeSet<String> secretContainerKeys = new TreeSet<String>();
                List env = container.getEnv();
                if (env != null) {
                    for (EnvVar envVar : env) {
                        SecretKeySelector secretKeySelector;
                        EnvVarSource envVarSource = envVar.getValueFrom();
                        if (envVarSource == null || (secretKeySelector = envVarSource.getSecretKeyRef()) == null) continue;
                        secretContainerKeys.add(envVar.getName());
                    }
                }
                if (secretContainerKeys.isEmpty()) continue;
                String containerName = container.getName();
                LOGGER.fine(() -> "looking for " + slave.getNamespace() + "/" + slave.getPodName() + "/" + containerName + " secrets named " + String.valueOf(secretContainerKeys));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                final Semaphore semaphore = new Semaphore(0);
                Boolean unix = c.isUnix();
                if (unix == null) {
                    return null;
                }
                try (PrintStream errs = new LogTaskListener(LOGGER, Level.FINE).getLogger();){
                    String[] stringArray;
                    Execable execable = ((ContainerResource)((PodResource)((NonNamespaceOperation)slave.getKubernetesCloud().connect().pods().inNamespace(slave.getNamespace())).withName(slave.getPodName())).inContainer((Object)containerName)).writingOutput((OutputStream)baos).writingError((OutputStream)errs).writingErrorChannel((OutputStream)errs).usingListener(new ExecListener(){

                        public void onFailure(Throwable t, ExecListener.Response response) {
                            semaphore.release();
                        }

                        public void onClose(int code, String reason) {
                            semaphore.release();
                        }
                    });
                    if (unix.booleanValue()) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "env";
                    } else {
                        String[] stringArray3 = new String[3];
                        stringArray3[0] = "cmd";
                        stringArray3[1] = "/c";
                        stringArray = stringArray3;
                        stringArray3[2] = "set";
                    }
                    try (ExecWatch exec = execable.exec(stringArray);){
                        if (!semaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                            LOGGER.fine(() -> "time out trying to find environment from " + slave.getNamespace() + "/" + slave.getPodName() + "/" + containerName);
                        }
                    }
                }
                catch (RuntimeException | KubernetesAuthException x) {
                    LOGGER.log(Level.FINE, "failed to find environment from " + slave.getNamespace() + "/" + slave.getPodName() + "/" + containerName, x);
                }
                for (String line : baos.toString(StandardCharsets.UTF_8.name()).split("\r?\n")) {
                    String key;
                    int equals = line.indexOf(61);
                    if (equals == -1 || !secretContainerKeys.contains(key = line.substring(0, equals))) continue;
                    LOGGER.fine(() -> "found value for " + key);
                    String value = line.substring(equals + 1);
                    if (value.isEmpty()) continue;
                    values.add(value);
                }
            }
            return values;
        }
    }
}

