/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.model.Node;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.io.Serializable;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class KubernetesNodeContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StepContext context;
    private final String podName;
    @CheckForNull
    private final String namespace;

    public KubernetesNodeContext(@NonNull StepContext context) throws Exception {
        this.context = context;
        KubernetesSlave agent = this.getKubernetesSlave();
        this.podName = agent.getPodName();
        this.namespace = agent.getNamespace();
    }

    @NonNull
    public String getPodName() {
        return this.podName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @NonNull
    public PodResource getPodResource() throws IOException, InterruptedException, KubernetesAuthException {
        return this.getKubernetesSlave().getKubernetesCloud().getPodResource(this.namespace, this.podName);
    }

    KubernetesClient connectToCloud() throws Exception {
        return this.getKubernetesSlave().getKubernetesCloud().connect();
    }

    @NonNull
    public final KubernetesSlave getKubernetesSlave() throws IOException, InterruptedException {
        Node node = (Node)this.context.get(Node.class);
        if (!(node instanceof KubernetesSlave)) {
            throw new AbortException(String.format("Node is not a Kubernetes node: %s", node != null ? node.getNodeName() : null));
        }
        return (KubernetesSlave)node;
    }
}

