/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.LauncherDecorator;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerStep;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.Resources;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class ContainerStepExecution
extends StepExecution {
    private static final long serialVersionUID = 7634132798345235774L;
    private static final Logger LOGGER = Logger.getLogger(ContainerStepExecution.class.getName());
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient ContainerStep step;
    private ContainerExecDecorator decorator;

    ContainerStepExecution(ContainerStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        LOGGER.log(Level.FINE, "Starting container step.");
        String containerName = this.step.getName();
        String shell = this.step.getShell();
        KubernetesNodeContext nodeContext = new KubernetesNodeContext(this.getContext());
        EnvironmentExpander env = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(Collections.singletonMap("POD_CONTAINER", containerName)));
        EnvVars globalVars = null;
        Jenkins instance = Jenkins.get();
        DescribableList globalNodeProperties = instance.getGlobalNodeProperties();
        List envVarsNodePropertyList = globalNodeProperties.getAll(EnvironmentVariablesNodeProperty.class);
        if (envVarsNodePropertyList != null && envVarsNodePropertyList.size() != 0) {
            globalVars = ((EnvironmentVariablesNodeProperty)envVarsNodePropertyList.get(0)).getEnvVars();
        }
        EnvVars rcEnvVars = null;
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        if (run != null && taskListener != null) {
            rcEnvVars = run.getEnvironment(taskListener);
        }
        this.decorator = new ContainerExecDecorator();
        this.decorator.setNodeContext(nodeContext);
        this.decorator.setContainerName(containerName);
        this.decorator.setEnvironmentExpander(env);
        this.decorator.setGlobalVars(globalVars);
        this.decorator.setRunContextEnvVars(rcEnvVars);
        this.decorator.setShell(shell);
        this.getContext().newBodyInvoker().withContexts(new Object[]{BodyInvoker.mergeLauncherDecorators((LauncherDecorator)((LauncherDecorator)this.getContext().get(LauncherDecorator.class)), (LauncherDecorator)this.decorator), env}).withCallback(Resources.closeQuietlyCallback(this.decorator)).start();
        return false;
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        LOGGER.log(Level.FINE, "Stopping container step.");
        Resources.closeQuietly(this.getContext(), this.decorator);
    }

    @Deprecated
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private static class ContainerExecCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6385838254761750483L;
        private final Closeable[] closeables;

        private ContainerExecCallback(Closeable ... closeables) {
            this.closeables = closeables;
        }

        public void finished(StepContext context) {
            Resources.closeQuietly(context, this.closeables);
        }
    }
}

