/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerLogStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ContainerLogStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 5588861066775717487L;
    private final String name;
    private boolean returnLog = false;
    private int tailingLines = 0;
    private int sinceSeconds = 0;
    private int limitBytes = 0;

    @DataBoundConstructor
    public ContainerLogStep(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setReturnLog(boolean returnLog) {
        this.returnLog = returnLog;
    }

    public boolean isReturnLog() {
        return this.returnLog;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ContainerLogStepExecution(this, context);
    }

    public int getTailingLines() {
        return this.tailingLines;
    }

    @DataBoundSetter
    public void setTailingLines(int tailingLines) {
        this.tailingLines = tailingLines;
    }

    public int getSinceSeconds() {
        return this.sinceSeconds;
    }

    @DataBoundSetter
    public void setSinceSeconds(int sinceSeconds) {
        this.sinceSeconds = sinceSeconds;
    }

    public int getLimitBytes() {
        return this.limitBytes;
    }

    @DataBoundSetter
    public void setLimitBytes(int limitBytes) {
        this.limitBytes = limitBytes;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "containerLog";
        }

        public String getDisplayName() {
            return "Get container log from Kubernetes";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Node.class, FilePath.class, TaskListener.class)));
        }
    }
}

