/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodContainerSource;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;

public class ContainerExecDecorator
extends LauncherDecorator
implements Serializable,
Closeable {
    private static final long serialVersionUID = 4419929753433397655L;
    private static final String WEBSOCKET_CONNECTION_MAX_RETRY_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".websocketConnectionMaxRetries";
    private static final String WEBSOCKET_CONNECTION_MAX_RETRY_BACKOFF_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".websocketConnectionMaxRetryBackoff";
    private static final String WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".websocketConnectionTimeout";
    private static final int WEBSOCKET_CONNECTION_TIMEOUT = Integer.getInteger(WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY, 30);
    private static final int WEBSOCKET_CONNECTION_MAX_RETRY = Integer.getInteger(WEBSOCKET_CONNECTION_MAX_RETRY_SYSTEM_PROPERTY, 5);
    private static final int WEBSOCKET_CONNECTION_MAX_RETRY_BACKOFF = Integer.getInteger(WEBSOCKET_CONNECTION_MAX_RETRY_BACKOFF_SYSTEM_PROPERTY, 30);
    private static final String COOKIE_VAR = "JENKINS_SERVER_COOKIE";
    private static final Logger LOGGER = Logger.getLogger(ContainerExecDecorator.class.getName());
    private static final int STDIN_BUFFER_SIZE = Integer.getInteger(ContainerExecDecorator.class.getName() + ".stdinBufferSize", 16384);
    public static final int COMMAND_FINISHED_TIMEOUT_MS = 200;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private transient List<Closeable> closables;
    private String containerName;
    private EnvironmentExpander environmentExpander;
    private EnvVars globalVars;
    private EnvVars rcEnvVars;
    private String shell;
    private KubernetesNodeContext nodeContext;
    private String workspace;

    public ContainerExecDecorator() {
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander, FilePath ws) {
        this.containerName = containerName;
        this.environmentExpander = environmentExpander;
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander) {
        this(client, podName, containerName, namespace, environmentExpander, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String path, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public KubernetesClient getClient() {
        try {
            return this.nodeContext.connectToCloud();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setClient(KubernetesClient client) {
    }

    @Deprecated
    public String getPodName() {
        try {
            return this.getNodeContext().getPodName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setPodName(String podName) {
    }

    @Deprecated
    public String getNamespace() {
        try {
            return this.getNodeContext().getNamespace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setNamespace(String namespace) {
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public EnvironmentExpander getEnvironmentExpander() {
        return this.environmentExpander;
    }

    public void setEnvironmentExpander(EnvironmentExpander environmentExpander) {
        this.environmentExpander = environmentExpander;
    }

    public EnvVars getGlobalVars() {
        return this.globalVars;
    }

    public void setGlobalVars(EnvVars globalVars) {
        this.globalVars = globalVars;
    }

    public void setRunContextEnvVars(EnvVars rcVars) {
        this.rcEnvVars = rcVars;
    }

    public EnvVars getRunContextEnvVars() {
        return this.rcEnvVars;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public KubernetesNodeContext getNodeContext() {
        return this.nodeContext;
    }

    public void setNodeContext(KubernetesNodeContext nodeContext) {
        this.nodeContext = nodeContext;
    }

    public Launcher decorate(final Launcher launcher, final Node node) {
        if (node != null && !(node instanceof KubernetesSlave)) {
            return launcher;
        }
        return new Launcher.DecoratedLauncher(launcher){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                Computer computer;
                String containerWorkingDirFilePathStr;
                LOGGER.log(Level.FINEST, "Launch proc with environment: {0}", Arrays.toString(starter.envs()));
                KubernetesSlave slave = (KubernetesSlave)node;
                FilePath containerWorkingDirFilePath = starter.pwd();
                ContainerExecDecorator.this.workspace = containerWorkingDirFilePathStr = containerWorkingDirFilePath != null ? containerWorkingDirFilePath.getRemote() : "/home/jenkins/agent";
                String containerWorkingDirStr = "/home/jenkins/agent";
                if (slave != null && slave.getPod().isPresent() && ContainerExecDecorator.this.containerName != null) {
                    Optional<String> containerWorkingDir = PodContainerSource.lookupContainerWorkingDir(slave.getPod().get(), ContainerExecDecorator.this.containerName);
                    if (containerWorkingDir.isPresent()) {
                        containerWorkingDirStr = containerWorkingDir.get();
                    }
                    if (containerWorkingDir.isPresent() && containerWorkingDirFilePath != null && !containerWorkingDirFilePath.getRemote().startsWith(containerWorkingDirStr)) {
                        containerWorkingDirFilePathStr = containerWorkingDirFilePath.getRemote().replaceFirst("/home/jenkins/agent", containerWorkingDirStr);
                        containerWorkingDirFilePath = new FilePath(containerWorkingDirFilePath.getChannel(), containerWorkingDirFilePathStr);
                        LOGGER.log(Level.FINEST, "Modified the pwd to match {0} containers workspace directory : {1}", new String[]{ContainerExecDecorator.this.containerName, containerWorkingDirFilePathStr});
                    }
                }
                String[] envVars = starter.envs();
                if (!containerWorkingDirStr.equals("/home/jenkins/agent")) {
                    for (int i = 0; i < envVars.length; ++i) {
                        String keyValue = envVars[i];
                        String[] split = keyValue.split("=", 2);
                        if (!split[1].startsWith("/home/jenkins/agent")) continue;
                        split[1] = split[1].replaceFirst("/home/jenkins/agent", containerWorkingDirStr);
                        envVars[i] = split[0] + "=" + split[1];
                        LOGGER.log(Level.FINEST, "Updated the starter environment variable, key: {0}, Value: {1}", new String[]{split[0], split[1]});
                    }
                }
                if (node != null && (computer = node.toComputer()) != null) {
                    ArrayList<Object> resultEnvVar = new ArrayList<Object>();
                    try {
                        EnvVars environment = computer.getEnvironment();
                        if (environment != null) {
                            HashSet<String> overriddenKeys = new HashSet<String>();
                            for (String string : envVars) {
                                String[] split = string.split("=", 2);
                                if (split[1].equals(environment.get((Object)split[0]))) continue;
                                resultEnvVar.add(string);
                                overriddenKeys.add(split[0]);
                            }
                            if (!containerWorkingDirStr.equals("/home/jenkins/agent")) {
                                for (Map.Entry entry : environment.entrySet()) {
                                    if (!((String)entry.getValue()).startsWith("/home/jenkins/agent") || overriddenKeys.contains(entry.getKey())) continue;
                                    String newValue = ((String)entry.getValue()).replaceFirst("/home/jenkins/agent", containerWorkingDirStr);
                                    String string = (String)entry.getKey() + "=" + newValue;
                                    LOGGER.log(Level.FINEST, "Updated the value for envVar, key: {0}, Value: {1}", new String[]{(String)entry.getKey(), newValue});
                                    resultEnvVar.add(string);
                                }
                            }
                            envVars = resultEnvVar.toArray(new String[resultEnvVar.size()]);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Unable to retrieve environment variables", e);
                    }
                }
                return this.doLaunch(starter.quiet(), ContainerExecDecorator.fixDoubleDollar(envVars), starter.stdout(), containerWorkingDirFilePath, starter.masks(), ContainerExecDecorator.getCommands(starter, containerWorkingDirFilePathStr, launcher.isUnix()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Proc doLaunch(boolean quiet, String[] cmdEnvs, OutputStream outputForCaller, FilePath pwd, boolean[] masks, String ... commands) throws IOException {
                CountDownLatch finished;
                CharSequence[] charSequenceArray;
                PrintStream printStream;
                ToggleOutputStream stream;
                long startMethod = System.nanoTime();
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                ToggleOutputStream toggleStdout = new ToggleOutputStream(stdout);
                if (quiet) {
                    stream = toggleStdout;
                    printStream = new PrintStream((OutputStream)stream, true, StandardCharsets.UTF_8);
                } else {
                    printStream = launcher.getListener().getLogger();
                    stream = new TeeOutputStream((OutputStream)toggleStdout, (OutputStream)printStream);
                }
                ByteArrayOutputStream dryRunCaller = null;
                ToggleOutputStream toggleDryRunCaller = null;
                ToggleOutputStream toggleOutputForCaller = null;
                if (outputForCaller != null && !outputForCaller.equals(printStream)) {
                    if (launcher.isUnix()) {
                        stream = new TeeOutputStream(outputForCaller, (OutputStream)stream);
                    } else {
                        dryRunCaller = new ByteArrayOutputStream();
                        toggleDryRunCaller = new ToggleOutputStream(dryRunCaller);
                        toggleOutputForCaller = new ToggleOutputStream(outputForCaller, true);
                        stream = new TeeOutputStream((OutputStream)toggleOutputForCaller, (OutputStream)stream);
                        stream = new TeeOutputStream((OutputStream)toggleDryRunCaller, (OutputStream)stream);
                    }
                }
                if (ContainerExecDecorator.this.shell != null) {
                    CharSequence[] charSequenceArray2 = new String[1];
                    charSequenceArray = charSequenceArray2;
                    charSequenceArray2[0] = ContainerExecDecorator.this.shell;
                } else if (launcher.isUnix()) {
                    String[] stringArray = new String[1];
                    charSequenceArray = stringArray;
                    stringArray[0] = "sh";
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = "cmd";
                    charSequenceArray = stringArray;
                    stringArray[1] = "/Q";
                }
                CharSequence[] sh = charSequenceArray;
                String msg = "Executing " + String.join((CharSequence)" ", sh) + " script inside container " + ContainerExecDecorator.this.containerName + " of pod " + ContainerExecDecorator.this.getPodName();
                LOGGER.log(Level.FINEST, msg);
                printStream.println(msg);
                if (ContainerExecDecorator.this.closables == null) {
                    ContainerExecDecorator.this.closables = new ArrayList<Closeable>();
                }
                int attempts = 0;
                ExecWatchWrapper watchWrapper = null;
                while (watchWrapper == null && attempts < WEBSOCKET_CONNECTION_MAX_RETRY) {
                    if (attempts > 0) {
                        long backoffInSeconds = Math.min(Integer.toUnsignedLong((int)Math.pow(2.0, attempts)), (long)WEBSOCKET_CONNECTION_MAX_RETRY_BACKOFF);
                        launcher.getListener().getLogger().println("Retrying in " + backoffInSeconds + "s ...");
                        try {
                            Thread.sleep(backoffInSeconds * 1000L);
                        }
                        catch (InterruptedException ex) {
                            launcher.getListener().getLogger().println("Retry wait interrupted");
                        }
                        finally {
                            launcher.getListener().getLogger().println("Retrying...");
                        }
                    }
                    try {
                        final AtomicBoolean alive = new AtomicBoolean(false);
                        final CountDownLatch started = new CountDownLatch(1);
                        finished = new CountDownLatch(1);
                        final AtomicLong startAlive = new AtomicLong();
                        ExecWatch watch = ((ContainerResource)ContainerExecDecorator.this.nodeContext.getPodResource().inContainer((Object)ContainerExecDecorator.this.containerName)).redirectingInput(Integer.valueOf(STDIN_BUFFER_SIZE)).writingOutput((OutputStream)stream).writingError((OutputStream)stream).usingListener(new ExecListener(){

                            public void onOpen() {
                                alive.set(true);
                                started.countDown();
                                startAlive.set(System.nanoTime());
                                LOGGER.log(Level.FINEST, "onOpen : {0}", finished);
                            }

                            public void onFailure(Throwable t, ExecListener.Response response) {
                                alive.set(false);
                                t.printStackTrace(launcher.getListener().getLogger());
                                started.countDown();
                                LOGGER.log(Level.FINEST, "onFailure : {0}", finished);
                                if (finished.getCount() == 0L) {
                                    LOGGER.log(Level.WARNING, "onFailure called but latch already finished. This may be a bug in the kubernetes-plugin");
                                }
                                finished.countDown();
                            }

                            public void onClose(int i, String s) {
                                alive.set(false);
                                started.countDown();
                                LOGGER.log(Level.FINEST, "onClose : {0} [{1} ms]", new Object[]{finished, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startAlive.get())});
                                if (finished.getCount() == 0L) {
                                    LOGGER.log(Level.WARNING, "onClose called but latch already finished. This indicates a bug in the kubernetes-plugin");
                                }
                                finished.countDown();
                            }
                        }).exec((String[])sh);
                        try {
                            if (started.await(WEBSOCKET_CONNECTION_TIMEOUT, TimeUnit.SECONDS)) {
                                watchWrapper = new ExecWatchWrapper(watch, alive, finished);
                                continue;
                            }
                            ContainerExecDecorator.closeWatch(watch);
                            launcher.getListener().error("Timed out waiting for websocket connection. You should increase the value of system property " + WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY + " currently set at " + WEBSOCKET_CONNECTION_TIMEOUT + " seconds");
                        }
                        catch (InterruptedException e) {
                            ContainerExecDecorator.closeWatch(watch);
                            throw e;
                        }
                    }
                    catch (KubernetesAuthException e) {
                        launcher.getListener().getLogger().print("Failed to authenticate with Kubernetes cluster: ");
                        e.printStackTrace(launcher.getListener().getLogger());
                        throw new AbortException("Failed to authenticate with Kubernetes cluster");
                    }
                    catch (KubernetesClientException e) {
                        launcher.getListener().getLogger().print("Failed to start websocket connection: ");
                        String message = e.getMessage();
                        if (message != null && message.startsWith("container " + ContainerExecDecorator.this.containerName + " not found in pod")) {
                            launcher.getListener().getLogger().print(message);
                            throw e;
                        }
                        e.printStackTrace(launcher.getListener().getLogger());
                    }
                    catch (InterruptedException e) {
                        launcher.getListener().getLogger().println("Failed to start websocket connection: Interrupted while waiting for websocket connection, you should consider increasing the Max connections to Kubernetes API.");
                        e.printStackTrace(launcher.getListener().getLogger());
                    }
                    finally {
                        ++attempts;
                    }
                }
                if (watchWrapper == null || watchWrapper.getExecWatch() == null) {
                    throw new AbortException("Failed to start websocket connection after " + attempts + " attempts. Check logs above for more details.");
                }
                ExecWatch watch = watchWrapper.getExecWatch();
                AtomicBoolean alive = watchWrapper.getAlive();
                finished = watchWrapper.getFinished();
                try {
                    if (finished.await(200L, TimeUnit.MILLISECONDS)) {
                        launcher.getListener().error("Process exited immediately after creation. See output below%n%s", new Object[]{stdout.toString(StandardCharsets.UTF_8.name())});
                        throw new AbortException("Process exited immediately after creation. Check logs above for more details.");
                    }
                    toggleStdout.disable();
                    OutputStream stdin = watch.getInput();
                    PrintStream in = new PrintStream(stdin, true, StandardCharsets.UTF_8);
                    if (!launcher.isUnix()) {
                        in.print("@echo off");
                        in.print(ContainerExecDecorator.newLine(true));
                    }
                    if (pwd != null) {
                        in.printf("cd \"%s\"", pwd);
                        in.print(ContainerExecDecorator.newLine(!launcher.isUnix()));
                    }
                    EnvVars envVars = new EnvVars();
                    if (ContainerExecDecorator.this.globalVars != null) {
                        envVars.overrideAll((Map)ContainerExecDecorator.this.globalVars);
                    }
                    if (ContainerExecDecorator.this.rcEnvVars != null) {
                        envVars.overrideAll((Map)ContainerExecDecorator.this.rcEnvVars);
                    }
                    if (ContainerExecDecorator.this.environmentExpander != null) {
                        ContainerExecDecorator.this.environmentExpander.expand(envVars);
                    }
                    if (cmdEnvs != null) {
                        for (String cmdEnv : cmdEnvs) {
                            envVars.addLine(cmdEnv);
                        }
                    }
                    LOGGER.log(Level.FINEST, "Launching with env vars: {0}", envVars.toString());
                    this.setupEnvironmentVariable(envVars, in, !launcher.isUnix());
                    if (!launcher.isUnix() && toggleOutputForCaller != null) {
                        ((OutputStream)stream).flush();
                        long beginning = System.currentTimeMillis();
                        while (!dryRunCaller.toString(StandardCharsets.UTF_8.name()).contains(">")) {
                            Thread.sleep(100L);
                        }
                        LOGGER.log(Level.FINEST, "Windows prompt printed after " + (System.currentTimeMillis() - beginning) + " ms");
                    }
                    if (toggleDryRunCaller != null) {
                        toggleDryRunCaller.disable();
                    }
                    if (dryRunCaller != null) {
                        dryRunCaller.reset();
                    }
                    if (toggleOutputForCaller != null) {
                        toggleOutputForCaller.enable();
                    }
                    ContainerExecDecorator.doExec(in, !launcher.isUnix(), printStream, masks, commands);
                    LOGGER.fine(() -> "Created process inside pod: [" + ContainerExecDecorator.this.getPodName() + "], container: [" + ContainerExecDecorator.this.containerName + "][" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startMethod) + " ms]");
                    ContainerExecProc proc = new ContainerExecProc(watch, alive, finished, stdin, printStream);
                    ContainerExecDecorator.this.closables.add(proc);
                    return proc;
                }
                catch (InterruptedException ie) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw new InterruptedIOException(ie.getMessage());
                }
                catch (RuntimeException e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw e;
                }
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                int exitCode;
                block23: {
                    this.getListener().getLogger().println("Killing processes");
                    String cookie = modelEnvVars.get(ContainerExecDecorator.COOKIE_VAR);
                    if (this.isUnix()) {
                        exitCode = this.doLaunch(true, null, null, null, null, "sh", "-c", "kill \\`grep -l 'JENKINS_SERVER_COOKIE=" + cookie + "' /proc/*/environ | cut -d / -f 3 \\`").join();
                    } else {
                        VirtualChannel channel = node.getChannel();
                        if (channel != null && ContainerExecDecorator.this.workspace != null) {
                            FilePath tmpFolder = WorkspaceList.tempDir((FilePath)new FilePath(channel, ContainerExecDecorator.this.workspace));
                            if (tmpFolder != null) {
                                try (TemporaryFile mainScript = 1.withTemporaryScript(tmpFolder, "kill-processes-with-cookie.ps1");
                                     TemporaryFile killProcessScript = 1.withTemporaryScript(tmpFolder, "kill-process-by-id.ps1");
                                     TemporaryFile csCode = 1.withTemporaryScript(tmpFolder, "ProcessEnvironmentReader.cs");){
                                    exitCode = this.doLaunch(true, null, null, null, null, "powershell.exe", "-NoProfile", "-File", "\"" + mainScript.getRemote() + "\"", "-cookie", cookie, "-csFile", "\"" + csCode.getRemote() + "\"", "-killScript", "\"" + killProcessScript.getRemote() + "\"").join();
                                    break block23;
                                }
                            }
                            exitCode = 9099;
                        } else {
                            exitCode = 9009;
                        }
                    }
                }
                this.getListener().getLogger().println("Attempt to gracefully kill processes finished with exit code " + exitCode);
            }

            private void setupEnvironmentVariable(EnvVars vars, PrintStream out, boolean windows) throws IOException {
                for (Map.Entry entry : vars.entrySet()) {
                    if (!((String)entry.getKey()).matches("[a-zA-Z_][a-zA-Z0-9_]*")) continue;
                    out.print(String.format(windows ? "set %s=%s" : "export %s='%s'", entry.getKey(), windows ? entry.getValue() : ((String)entry.getValue()).replace("'", "'\\''")));
                    out.print(ContainerExecDecorator.newLine(windows));
                }
            }

            private static TemporaryFile withTemporaryScript(FilePath workspace, String name) throws IOException, InterruptedException {
                return new TemporaryFile(workspace, name);
            }
        };
    }

    private static String newLine(boolean windows) {
        return windows ? "\r\n" : "\n";
    }

    @Override
    public void close() throws IOException {
        if (this.closables == null) {
            return;
        }
        for (Closeable closable : this.closables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "failed to close", e);
            }
        }
    }

    private static void doExec(PrintStream in, boolean windows, PrintStream out, boolean[] masks, String ... statements) {
        long start = System.nanoTime();
        ByteArrayOutputStream loggingOutput = new ByteArrayOutputStream();
        TeeOutputStream teeOutput = new TeeOutputStream((OutputStream)out, (OutputStream)loggingOutput);
        MaskOutputStream maskedOutput = new MaskOutputStream((OutputStream)teeOutput, masks);
        try {
            String encoding = StandardCharsets.UTF_8.name();
            PrintStream tee = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)in, (OutputStream)maskedOutput), false, encoding);
            PrintStream unmasked = new PrintStream((OutputStream)teeOutput, false, encoding);
            unmasked.print("Executing command: ");
            for (String statement : statements) {
                if (windows) {
                    tee.append(statement).append(" ");
                    continue;
                }
                tee.append("\"").append(statement).append("\" ");
            }
            tee.print(ContainerExecDecorator.newLine(windows));
            LOGGER.log(Level.FINEST, loggingOutput.toString(encoding) + "[" + TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start) + " \u03bcs.]");
            tee.print("exit");
            tee.print(ContainerExecDecorator.newLine(windows));
            tee.flush();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.SEVERE, "Failed to execute command because of unsupported encoding", e);
        }
    }

    static String[] getCommands(Launcher.ProcStarter starter, String containerWorkingDirStr, boolean unix) {
        ArrayList<String> allCommands = new ArrayList<String>();
        for (String cmd : starter.cmds()) {
            String fixedCommand = cmd.replaceAll("\\$\\$", Matcher.quoteReplacement("\\$"));
            if (unix) {
                fixedCommand = fixedCommand.replaceAll("\\\"", Matcher.quoteReplacement("\\\""));
            }
            String oldRemoteDir = null;
            FilePath oldRemoteDirFilepath = starter.pwd();
            if (oldRemoteDirFilepath != null) {
                oldRemoteDir = oldRemoteDirFilepath.getRemote();
            }
            if (oldRemoteDir != null && !oldRemoteDir.isEmpty() && !oldRemoteDir.equals(containerWorkingDirStr) && fixedCommand.contains(oldRemoteDir)) {
                fixedCommand = fixedCommand.replaceAll(oldRemoteDir, containerWorkingDirStr);
            }
            allCommands.add(fixedCommand);
        }
        return allCommands.toArray(new String[allCommands.size()]);
    }

    private static void closeWatch(ExecWatch watch) {
        try {
            watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }

    @Deprecated
    public void setKubernetesClient(KubernetesClient client) {
    }

    private static String[] fixDoubleDollar(String[] envVars) {
        return (String[])Arrays.stream(envVars).map(ev -> ev.replaceAll("\\$\\$", Matcher.quoteReplacement("$"))).toArray(String[]::new);
    }

    private static class MaskOutputStream
    extends FilterOutputStream {
        private static final String MASK_STRING = "********";
        private final boolean[] masks;
        private static final char SEPARATOR = ' ';
        private int index;
        private boolean wrote;

        public MaskOutputStream(OutputStream out, boolean[] masks) {
            super(out);
            this.masks = masks;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.masks == null || this.index >= this.masks.length) {
                this.out.write(b);
            } else if (this.isSeparator(b)) {
                this.out.write(b);
                ++this.index;
                this.wrote = false;
            } else if (this.masks[this.index]) {
                if (!this.wrote) {
                    this.wrote = true;
                    for (char c : MASK_STRING.toCharArray()) {
                        this.out.write(c);
                    }
                }
            } else {
                this.out.write(b);
            }
        }

        private boolean isSeparator(int b) {
            return b == 32;
        }
    }

    private static final class TemporaryFile
    implements AutoCloseable {
        @NonNull
        final FilePath filePath;

        TemporaryFile(@NonNull FilePath workspace, @NonNull String name) throws IOException, InterruptedException {
            URL resource = ContainerExecDecorator.class.getResource("scripts/" + name);
            if (resource == null) {
                throw new FileNotFoundException("Script " + name + " not found in resources!");
            }
            FilePath tempFile = workspace.createTempFile(FilenameUtils.getBaseName((String)name), "." + FilenameUtils.getExtension((String)name));
            tempFile.copyFrom(resource);
            this.filePath = tempFile;
        }

        public String getRemote() {
            return this.filePath.getRemote();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TemporaryFile)) {
                return false;
            }
            TemporaryFile that = (TemporaryFile)o;
            return Objects.equals(this.filePath, that.filePath);
        }

        public int hashCode() {
            return Objects.hashCode(this.filePath);
        }

        @Override
        public void close() throws IOException, InterruptedException {
            this.filePath.delete();
        }
    }

    private static class ToggleOutputStream
    extends FilterOutputStream {
        private boolean disabled;

        public ToggleOutputStream(OutputStream out) {
            this(out, false);
        }

        public ToggleOutputStream(OutputStream out, boolean disabled) {
            super(out);
            this.disabled = disabled;
        }

        public void disable() {
            this.disabled = true;
        }

        public void enable() {
            this.disabled = false;
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.disabled) {
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!this.disabled) {
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.disabled) {
                this.out.write(b, off, len);
            }
        }
    }

    private static class ExecWatchWrapper {
        private final ExecWatch execWatch;
        private final AtomicBoolean alive;
        private final CountDownLatch finished;

        public ExecWatchWrapper(ExecWatch execWatch, AtomicBoolean alive, CountDownLatch finished) {
            this.execWatch = execWatch;
            this.alive = alive;
            this.finished = finished;
        }

        public ExecWatch getExecWatch() {
            return this.execWatch;
        }

        public AtomicBoolean getAlive() {
            return this.alive;
        }

        public CountDownLatch getFinished() {
            return this.finished;
        }
    }
}

