/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.slaves.NodeProvisioner;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PlannedNodeBuilder;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

public class StandardPlannedNodeBuilder
extends PlannedNodeBuilder {
    @Override
    public NodeProvisioner.PlannedNode build() {
        CompletableFuture<Object> f;
        String displayName;
        KubernetesCloud cloud = this.getCloud();
        PodTemplate t = this.getTemplate();
        try {
            KubernetesSlave agent = KubernetesSlave.builder().podTemplate(t.isUnwrapped() ? t : cloud.getUnwrappedTemplate(t)).cloud(cloud).build();
            displayName = agent.getDisplayName();
            f = CompletableFuture.completedFuture(agent);
        }
        catch (Descriptor.FormException | IOException e) {
            displayName = null;
            f = new CompletableFuture();
            f.completeExceptionally(e);
        }
        return new NodeProvisioner.PlannedNode(Util.fixNull((String)displayName), f, this.getNumExecutors());
    }
}

