/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Label;
import hudson.model.Node;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.Commandline;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PortMapping;
import org.csanchez.jenkins.plugins.kubernetes.Serialization2;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;

public class PodTemplateUtils {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateUtils.class.getName());
    private static final Pattern LABEL_VALIDATION = Pattern.compile("[a-zA-Z0-9]([_\\.\\-a-zA-Z0-9]*[a-zA-Z0-9])?");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="tests & emergency admin")
    public static boolean SUBSTITUTE_ENV = Boolean.getBoolean(PodTemplateUtils.class.getName() + ".SUBSTITUTE_ENV");

    public static ContainerTemplate combine(@CheckForNull ContainerTemplate parent, @NonNull ContainerTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("Container template should not be null");
        }
        if (parent == null) {
            return template;
        }
        Map ports = parent.getPorts().stream().collect(Collectors.toMap(PortMapping::getName, Function.identity()));
        template.getPorts().forEach(p -> ports.put(p.getName(), p));
        HierarchyResolver<ContainerTemplate> h = new HierarchyResolver<ContainerTemplate>(parent, template);
        ContainerTemplate combined = new ContainerTemplate(template.getName(), h.resolve(ContainerTemplate::getImage, PodTemplateUtils::isNullOrEmpty));
        combined.setAlwaysPullImage(h.resolve(ContainerTemplate::isAlwaysPullImage, v -> v == false));
        combined.setCommand(h.resolve(ContainerTemplate::getCommand, PodTemplateUtils::isNullOrEmpty));
        combined.setArgs(h.resolve(ContainerTemplate::getArgs, PodTemplateUtils::isNullOrEmpty));
        combined.setTtyEnabled(h.resolve(ContainerTemplate::isTtyEnabled, v -> v == false));
        combined.setResourceLimitCpu(h.resolve(ContainerTemplate::getResourceLimitCpu, PodTemplateUtils::isNullOrEmpty));
        combined.setResourceLimitMemory(h.resolve(ContainerTemplate::getResourceLimitMemory, PodTemplateUtils::isNullOrEmpty));
        combined.setResourceLimitEphemeralStorage(h.resolve(ContainerTemplate::getResourceLimitEphemeralStorage, PodTemplateUtils::isNullOrEmpty));
        combined.setResourceRequestCpu(h.resolve(ContainerTemplate::getResourceRequestCpu, PodTemplateUtils::isNullOrEmpty));
        combined.setResourceRequestMemory(h.resolve(ContainerTemplate::getResourceRequestMemory, PodTemplateUtils::isNullOrEmpty));
        combined.setResourceRequestEphemeralStorage(h.resolve(ContainerTemplate::getResourceRequestEphemeralStorage, PodTemplateUtils::isNullOrEmpty));
        combined.setShell(h.resolve(ContainerTemplate::getShell, PodTemplateUtils::isNullOrEmpty));
        combined.setWorkingDir(h.resolve(ContainerTemplate::getWorkingDir, PodTemplateUtils::isNullOrEmpty));
        combined.setPrivileged(h.resolve(ContainerTemplate::isPrivileged, v -> v == false));
        combined.setRunAsUser(h.resolve(ContainerTemplate::getRunAsUser, Objects::isNull));
        combined.setRunAsGroup(h.resolve(ContainerTemplate::getRunAsGroup, Objects::isNull));
        combined.setEnvVars(PodTemplateUtils.combineEnvVars(parent, template));
        combined.setPorts(new ArrayList<PortMapping>(ports.values()));
        combined.setLivenessProbe(h.resolve(ContainerTemplate::getLivenessProbe, Objects::isNull));
        return combined;
    }

    public static Container combine(@CheckForNull Container parent, @NonNull Container template) {
        Long runAsGroup;
        Long runAsUser;
        Boolean privileged;
        if (template == null) {
            throw new IllegalArgumentException("Container template should not be null");
        }
        if (parent == null) {
            return template;
        }
        HierarchyResolver<Container> h = new HierarchyResolver<Container>(parent, template);
        if (template.getSecurityContext() != null) {
            if (parent.getSecurityContext() != null) {
                privileged = h.resolve(c -> c.getSecurityContext().getPrivileged(), Objects::isNull);
                runAsUser = h.resolve(c -> c.getSecurityContext().getRunAsUser(), Objects::isNull);
                runAsGroup = h.resolve(c -> c.getSecurityContext().getRunAsGroup(), Objects::isNull);
            } else {
                privileged = template.getSecurityContext().getPrivileged();
                runAsUser = template.getSecurityContext().getRunAsUser();
                runAsGroup = template.getSecurityContext().getRunAsGroup();
            }
        } else if (parent.getSecurityContext() != null) {
            privileged = parent.getSecurityContext().getPrivileged();
            runAsUser = parent.getSecurityContext().getRunAsUser();
            runAsGroup = parent.getSecurityContext().getRunAsGroup();
        } else {
            privileged = Boolean.FALSE;
            runAsUser = null;
            runAsGroup = null;
        }
        Map volumeMounts = parent.getVolumeMounts().stream().collect(Collectors.toMap(VolumeMount::getMountPath, Function.identity()));
        template.getVolumeMounts().forEach(vm -> volumeMounts.put(vm.getMountPath(), vm));
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(parent).withImage(h.resolve(Container::getImage, PodTemplateUtils::isNullOrEmpty))).withName(template.getName())).withImagePullPolicy(h.resolve(Container::getImagePullPolicy, PodTemplateUtils::isNullOrEmpty))).withCommand(h.resolve(Container::getCommand, PodTemplateUtils::isNullOrEmpty))).withWorkingDir(h.resolve(Container::getWorkingDir, PodTemplateUtils::isNullOrEmpty))).withArgs(h.resolve(Container::getArgs, PodTemplateUtils::isNullOrEmpty))).withTty(h.resolve(Container::getTty, Objects::isNull))).withNewResources().withRequests(Map.copyOf(PodTemplateUtils.combineResources(parent, template, ResourceRequirements::getRequests)))).withLimits(Map.copyOf(PodTemplateUtils.combineResources(parent, template, ResourceRequirements::getLimits)))).endResources()).withEnv(PodTemplateUtils.combineEnvVars(parent, template))).withEnvFrom(PodTemplateUtils.combinedEnvFromSources(parent, template))).withVolumeMounts(List.copyOf(volumeMounts.values()));
        if (privileged != null && privileged.booleanValue() || runAsUser != null || runAsGroup != null || PodTemplateUtils.combineCapabilities(parent, template) != null) {
            containerBuilder = (ContainerBuilder)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)containerBuilder.withNewSecurityContextLike(parent.getSecurityContext()).withPrivileged(privileged)).withRunAsUser(runAsUser)).withRunAsGroup(runAsGroup)).withCapabilities(PodTemplateUtils.combineCapabilities(parent, template))).endSecurityContext();
        }
        return containerBuilder.build();
    }

    private static Map<String, Quantity> combineResources(Container parent, Container template, Function<ResourceRequirements, Map<String, Quantity>> resourceTypeMapper) {
        return Stream.of(template.getResources(), parent.getResources()).filter(Objects::nonNull).map(resourceTypeMapper).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
    }

    private static Capabilities combineCapabilities(Container parent, Container template) {
        Capabilities templateCapabilities;
        Capabilities parentCapabilities = parent.getSecurityContext() != null ? parent.getSecurityContext().getCapabilities() : null;
        Capabilities capabilities = templateCapabilities = template.getSecurityContext() != null ? template.getSecurityContext().getCapabilities() : null;
        if (parentCapabilities == null && templateCapabilities == null) {
            return null;
        }
        if (parentCapabilities == null) {
            return templateCapabilities;
        }
        if (templateCapabilities == null) {
            return parentCapabilities;
        }
        Capabilities combined = new Capabilities();
        combined.setAdd(PodTemplateUtils.combineCapabilities(parentCapabilities, templateCapabilities, Capabilities::getAdd));
        combined.setDrop(PodTemplateUtils.combineCapabilities(parentCapabilities, templateCapabilities, Capabilities::getDrop));
        return combined;
    }

    private static List<String> combineCapabilities(Capabilities parentCapabilities, Capabilities templateCapabilities, Function<Capabilities, List<String>> capabilitiesListFunction) {
        List<String> parentCapabilitiesList = capabilitiesListFunction.apply(parentCapabilities);
        List<String> templateCapabilitiesList = capabilitiesListFunction.apply(templateCapabilities);
        if (templateCapabilitiesList != null) {
            return templateCapabilitiesList;
        }
        return parentCapabilitiesList;
    }

    public static Pod combine(List<Pod> pods) {
        Pod result = null;
        for (Pod p : pods) {
            if (result != null) {
                result = PodTemplateUtils.combine(result, p);
                continue;
            }
            result = p;
        }
        return result;
    }

    public static Pod combine(Pod parent, Pod template) {
        if (template == null) {
            throw new IllegalArgumentException("Pod template should not be null");
        }
        if (parent == null) {
            return template;
        }
        LOGGER.finest(() -> "Combining pods, parent: " + Serialization2.asYaml(parent) + " template: " + Serialization2.asYaml(template));
        Map nodeSelector = PodTemplateUtils.mergeMaps(parent.getSpec().getNodeSelector(), template.getSpec().getNodeSelector());
        HierarchyResolver<PodSpec> h = new HierarchyResolver<PodSpec>(parent.getSpec(), template.getSpec());
        Map podAnnotations = PodTemplateUtils.mergeMaps(parent.getMetadata().getAnnotations(), template.getMetadata().getAnnotations());
        Map podLabels = PodTemplateUtils.mergeMaps(parent.getMetadata().getLabels(), template.getMetadata().getLabels());
        LinkedHashSet imagePullSecrets = new LinkedHashSet();
        imagePullSecrets.addAll(parent.getSpec().getImagePullSecrets());
        imagePullSecrets.addAll(template.getSpec().getImagePullSecrets());
        List<Container> combinedContainers = PodTemplateUtils.combineContainers(parent.getSpec().getContainers(), template.getSpec().getContainers());
        List<Container> combinedInitContainers = PodTemplateUtils.combineContainers(parent.getSpec().getInitContainers(), template.getSpec().getInitContainers());
        List<Volume> combinedVolumes = PodTemplateUtils.combineVolumes(parent.getSpec().getVolumes(), template.getSpec().getVolumes());
        LinkedList combinedTolerations = new LinkedList();
        Optional.ofNullable(parent.getSpec().getTolerations()).ifPresent(combinedTolerations::addAll);
        Optional.ofNullable(template.getSpec().getTolerations()).ifPresent(combinedTolerations::addAll);
        PodFluent.MetadataNested metadataBuilder = (PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder(parent).withNewMetadataLike(parent.getMetadata()).withAnnotations(podAnnotations)).withLabels(podLabels);
        if (!PodTemplateUtils.isNullOrEmpty(template.getMetadata().getName())) {
            metadataBuilder.withName(template.getMetadata().getName());
        }
        if (!PodTemplateUtils.isNullOrEmpty(template.getMetadata().getNamespace())) {
            metadataBuilder.withNamespace(template.getMetadata().getNamespace());
        }
        PodFluent.SpecNested specBuilder = (PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)metadataBuilder.endMetadata()).withNewSpecLike(parent.getSpec()).withNodeSelector(nodeSelector)).withServiceAccount(h.resolve(PodSpec::getServiceAccount, PodTemplateUtils::isNullOrEmpty))).withServiceAccountName(h.resolve(PodSpec::getServiceAccountName, PodTemplateUtils::isNullOrEmpty))).withSchedulerName(h.resolve(PodSpec::getSchedulerName, PodTemplateUtils::isNullOrEmpty))).withActiveDeadlineSeconds(h.resolve(PodSpec::getActiveDeadlineSeconds, Objects::isNull))).withHostNetwork(h.resolve(PodSpec::getHostNetwork, Objects::isNull))).withShareProcessNamespace(h.resolve(PodSpec::getShareProcessNamespace, Objects::isNull))).withContainers(combinedContainers)).withInitContainers(combinedInitContainers)).withVolumes(combinedVolumes)).withTolerations(combinedTolerations)).withImagePullSecrets(new ArrayList(imagePullSecrets));
        if (template.getSpec().getSecurityContext() != null || parent.getSpec().getSecurityContext() != null) {
            ((PodSpecFluent.SecurityContextNested)((PodSpecFluent.SecurityContextNested)specBuilder.editOrNewSecurityContext().withRunAsUser(template.getSpec().getSecurityContext() != null && template.getSpec().getSecurityContext().getRunAsUser() != null ? template.getSpec().getSecurityContext().getRunAsUser() : (parent.getSpec().getSecurityContext() != null && parent.getSpec().getSecurityContext().getRunAsUser() != null ? parent.getSpec().getSecurityContext().getRunAsUser() : null))).withRunAsGroup(template.getSpec().getSecurityContext() != null && template.getSpec().getSecurityContext().getRunAsGroup() != null ? template.getSpec().getSecurityContext().getRunAsGroup() : (parent.getSpec().getSecurityContext() != null && parent.getSpec().getSecurityContext().getRunAsGroup() != null ? parent.getSpec().getSecurityContext().getRunAsGroup() : null))).endSecurityContext();
        }
        Pod pod = ((PodBuilder)specBuilder.endSpec()).build();
        LOGGER.finest(() -> "Pods combined: " + Serialization2.asYaml(pod));
        return pod;
    }

    @NonNull
    private static List<Container> combineContainers(List<Container> parent, List<Container> child) {
        LinkedHashMap combinedContainers = new LinkedHashMap();
        Map parentContainers = parent.stream().collect(Collectors.toMap(Container::getName, c -> c, PodTemplateUtils.throwingMerger(), LinkedHashMap::new));
        Map childContainers = child.stream().collect(Collectors.toMap(Container::getName, c -> PodTemplateUtils.combine((Container)parentContainers.get(c.getName()), c), PodTemplateUtils.throwingMerger(), LinkedHashMap::new));
        combinedContainers.putAll(parentContainers);
        combinedContainers.putAll(childContainers);
        return new ArrayList<Container>(combinedContainers.values());
    }

    private static List<Volume> combineVolumes(@NonNull List<Volume> volumes1, @NonNull List<Volume> volumes2) {
        Map volumesByName = volumes1.stream().collect(Collectors.toMap(Volume::getName, Function.identity()));
        volumes2.forEach(v -> volumesByName.put(v.getName(), v));
        return new ArrayList<Volume>(volumesByName.values());
    }

    public static PodTemplate combine(PodTemplate parent, PodTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("Pod template should not be null");
        }
        if (parent == null) {
            return template;
        }
        LOGGER.log(Level.FINEST, () -> "Combining pod templates, parent: " + String.valueOf(parent) + ", template: " + String.valueOf(template));
        String name = template.getName();
        String label = template.getLabel();
        LinkedHashSet<PodAnnotation> podAnnotations = new LinkedHashSet<PodAnnotation>();
        podAnnotations.addAll(template.getAnnotations());
        podAnnotations.addAll(parent.getAnnotations());
        LinkedHashSet<PodImagePullSecret> imagePullSecrets = new LinkedHashSet<PodImagePullSecret>();
        imagePullSecrets.addAll(parent.getImagePullSecrets());
        imagePullSecrets.addAll(template.getImagePullSecrets());
        HashMap<String, ContainerTemplate> combinedContainers = new HashMap<String, ContainerTemplate>();
        HashMap<String, PodVolume> combinedVolumes = new HashMap<String, PodVolume>();
        Map<String, ContainerTemplate> parentContainers = parent.getContainers().stream().collect(Collectors.toMap(ContainerTemplate::getName, c -> c));
        combinedContainers.putAll(parentContainers);
        combinedContainers.putAll(template.getContainers().stream().collect(Collectors.toMap(ContainerTemplate::getName, c -> PodTemplateUtils.combine((ContainerTemplate)parentContainers.get(c.getName()), c))));
        Map<String, PodVolume> parentVolumes = parent.getVolumes().stream().collect(Collectors.toMap(PodVolume::getMountPath, v -> v));
        combinedVolumes.putAll(parentVolumes);
        combinedVolumes.putAll(template.getVolumes().stream().collect(Collectors.toMap(PodVolume::getMountPath, v -> v)));
        WorkspaceVolume workspaceVolume = WorkspaceVolume.merge(parent.getWorkspaceVolume(), template.getWorkspaceVolume());
        ArrayList nodeProperties = new ArrayList(parent.getNodeProperties());
        nodeProperties.addAll(template.getNodeProperties());
        PodTemplate podTemplate = new PodTemplate(template.getId());
        HierarchyResolver<PodTemplate> h = new HierarchyResolver<PodTemplate>(parent, template);
        podTemplate.setName(name);
        podTemplate.setNamespace(h.resolve(PodTemplate::getNamespace, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setLabel(label);
        podTemplate.setNodeSelector(h.resolve(PodTemplate::getNodeSelector, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setServiceAccount(h.resolve(PodTemplate::getServiceAccount, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setSchedulerName(h.resolve(PodTemplate::getSchedulerName, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setEnvVars(PodTemplateUtils.combineEnvVars(parent, template));
        podTemplate.setContainers(new ArrayList<ContainerTemplate>(combinedContainers.values()));
        podTemplate.setWorkspaceVolume(workspaceVolume);
        podTemplate.setVolumes(new ArrayList<PodVolume>(combinedVolumes.values()));
        podTemplate.setImagePullSecrets(new ArrayList<PodImagePullSecret>(imagePullSecrets));
        podTemplate.setAnnotations(new ArrayList<PodAnnotation>(podAnnotations));
        podTemplate.setNodeProperties(nodeProperties);
        podTemplate.setNodeUsageMode(template.getNodeUsageMode() == null ? parent.getNodeUsageMode() : template.getNodeUsageMode());
        podTemplate.setYamlMergeStrategy(h.resolve(PodTemplate::getYamlMergeStrategy, childValue -> childValue == null && parent.isInheritYamlMergeStrategy()));
        podTemplate.setInheritYamlMergeStrategy(parent.isInheritYamlMergeStrategy());
        podTemplate.setInheritFrom(h.resolve(PodTemplate::getInheritFrom, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setInstanceCap(h.resolve(PodTemplate::getInstanceCap, i -> Objects.equals(i, Integer.MAX_VALUE)));
        podTemplate.setSlaveConnectTimeout(h.resolve(PodTemplate::getSlaveConnectTimeout, i -> Objects.equals(i, PodTemplate.DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT)));
        podTemplate.setIdleMinutes(h.resolve(PodTemplate::getIdleMinutes, i -> Objects.equals(i, 0)));
        podTemplate.setActiveDeadlineSeconds(h.resolve(PodTemplate::getActiveDeadlineSeconds, i -> Objects.equals(i, 0)));
        podTemplate.setServiceAccount(h.resolve(PodTemplate::getServiceAccount, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setSchedulerName(h.resolve(PodTemplate::getSchedulerName, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setPodRetention(template.getPodRetention());
        podTemplate.setShowRawYaml(h.resolve(PodTemplate::isShowRawYaml, v -> v));
        podTemplate.setRunAsUser(h.resolve(PodTemplate::getRunAsUser, Objects::isNull));
        podTemplate.setRunAsGroup(h.resolve(PodTemplate::getRunAsGroup, Objects::isNull));
        podTemplate.setSupplementalGroups(h.resolve(PodTemplate::getSupplementalGroups, Objects::isNull));
        podTemplate.setAgentContainer(h.resolve(PodTemplate::getAgentContainer, PodTemplateUtils::isNullOrEmpty));
        podTemplate.setAgentInjection(h.resolve(PodTemplate::isAgentInjection, v -> v == false));
        if (template.isHostNetworkSet()) {
            podTemplate.setHostNetwork(template.isHostNetwork());
        } else if (parent.isHostNetworkSet()) {
            podTemplate.setHostNetwork(parent.isHostNetwork());
        }
        ArrayList<String> yamls = new ArrayList<String>(parent.getYamls());
        yamls.addAll(template.getYamls());
        podTemplate.setYamls(yamls);
        podTemplate.setListener(template.getListener());
        LOGGER.log(Level.FINEST, "Pod templates combined: {0}", podTemplate);
        return podTemplate;
    }

    static PodTemplate unwrap(PodTemplate template, String defaultProviderTemplate, Collection<PodTemplate> allTemplates) {
        if (template == null) {
            return null;
        }
        List<String> inheritFrom = PodTemplateUtils.computedInheritFrom(template, defaultProviderTemplate);
        if (inheritFrom.isEmpty()) {
            return template;
        }
        PodTemplate parent = null;
        for (String name : inheritFrom) {
            PodTemplate next = PodTemplateUtils.getTemplateByName(name, allTemplates);
            if (next == null) continue;
            parent = PodTemplateUtils.combine(parent, PodTemplateUtils.unwrap(next, allTemplates));
        }
        PodTemplate combined = PodTemplateUtils.combine(parent, template);
        combined.setUnwrapped(true);
        LOGGER.log(Level.FINEST, "Combined parent + template is {0}", combined);
        return combined;
    }

    private static List<String> computedInheritFrom(PodTemplate template, String defaultProviderTemplate) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        if (!PodTemplateUtils.isNullOrEmpty(defaultProviderTemplate)) {
            hierarchy.add(defaultProviderTemplate);
        }
        if (!PodTemplateUtils.isNullOrEmpty(template.getInheritFrom())) {
            String[] split;
            for (String name : split = template.getInheritFrom().split(" +")) {
                hierarchy.add(name);
            }
        }
        return Collections.unmodifiableList(hierarchy);
    }

    static PodTemplate unwrap(PodTemplate template, Collection<PodTemplate> allTemplates) {
        return PodTemplateUtils.unwrap(template, null, allTemplates);
    }

    @CheckForNull
    public static PodTemplate getTemplateByLabel(@CheckForNull Label label, Collection<PodTemplate> templates) {
        for (PodTemplate t : templates) {
            if ((label != null || t.getNodeUsageMode() != Node.Mode.NORMAL) && (label == null || !label.matches(t.getLabelSet()))) continue;
            return t;
        }
        return null;
    }

    public static PodTemplate getTemplateByName(@CheckForNull String name, Collection<PodTemplate> templates) {
        for (PodTemplate t : templates) {
            if (name == null || !name.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    @Deprecated
    public static String substituteEnv(String s) {
        return SUBSTITUTE_ENV ? Util.replaceMacro((String)s, System.getenv()) : s;
    }

    @Deprecated
    public static String substitute(String s, Map<String, String> properties) {
        return Util.replaceMacro((String)s, properties);
    }

    @Deprecated
    public static String substitute(String s, Map<String, String> properties, String defaultValue) {
        return PodTemplateUtils.isNullOrEmpty(s) ? defaultValue : Util.replaceMacro((String)s, properties);
    }

    public static Pod parseFromYaml(String yaml) {
        Pod podFromYaml;
        String s = yaml;
        if (StringUtils.isBlank((String)s)) {
            LOGGER.log(Level.WARNING, "[JENKINS-57116] Trying to parse invalid yaml: \"{0}\"", yaml);
            s = "{}";
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));){
            podFromYaml = Serialization2.unmarshal(is, Pod.class);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to parse yaml: \"%s\"", yaml), e);
        }
        LOGGER.finest(() -> "Parsed pod template from yaml: " + Serialization2.asYaml(podFromYaml));
        if (podFromYaml.getMetadata() == null) {
            podFromYaml.setMetadata(new ObjectMeta());
        }
        if (podFromYaml.getSpec() == null) {
            podFromYaml.setSpec(new PodSpec());
        }
        return podFromYaml;
    }

    public static Collection<String> validateYamlContainerNames(List<String> yamls) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String yaml : yamls) {
            errors.addAll(PodTemplateUtils.validateYamlContainerNames(yaml));
        }
        return errors;
    }

    public static Collection<String> validateYamlContainerNames(String yaml) {
        if (StringUtils.isBlank((String)yaml)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        Pod pod = PodTemplateUtils.parseFromYaml(yaml);
        List containers = pod.getSpec().getContainers();
        if (containers != null) {
            for (Container container : containers) {
                if (PodTemplateUtils.validateContainerName(container.getName())) continue;
                errors.add(container.getName());
            }
        }
        return errors;
    }

    public static boolean validateContainerName(String name) {
        if (name != null && !name.isEmpty()) {
            Pattern p = Pattern.compile("[a-z0-9]([-a-z0-9]*[a-z0-9])?");
            Matcher m = p.matcher(name);
            return m.matches();
        }
        return true;
    }

    public static boolean validateLabel(String label) {
        return StringUtils.isBlank((String)label) ? true : label.length() <= 63 && LABEL_VALIDATION.matcher(label).matches();
    }

    public static boolean validateImage(String image) {
        return image != null && image.matches("\\S+");
    }

    @Nullable
    public static List<String> splitCommandLine(@Nullable String commandLine) {
        if (commandLine == null || commandLine.isEmpty()) {
            return null;
        }
        String[] args = Commandline.translateCommandline((String)commandLine);
        if (SUBSTITUTE_ENV) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = PodTemplateUtils.substituteEnv(args[i]);
            }
        }
        return Arrays.asList(args);
    }

    public static String sanitizeLabel(@CheckForNull String input) {
        if (input == null) {
            return null;
        }
        int max = 57;
        String label = input.length() > max ? input.substring(input.length() - max) : input;
        label = label.replaceAll("[^_a-zA-Z0-9-]", "_").replaceFirst("^[^a-zA-Z0-9]", "x").replaceFirst("[^a-zA-Z0-9]$", "x");
        assert (PodTemplateUtils.validateLabel(label)) : label;
        return label;
    }

    private static List<EnvVar> combineEnvVars(Container parent, Container template) {
        HashMap combinedEnvVars = new HashMap();
        Stream.of(parent.getEnv(), template.getEnv()).filter(Objects::nonNull).flatMap(Collection::stream).filter(var -> !PodTemplateUtils.isNullOrEmpty(var.getName())).forEachOrdered(var -> combinedEnvVars.put(var.getName(), var));
        return new ArrayList<EnvVar>(combinedEnvVars.values());
    }

    private static List<TemplateEnvVar> combineEnvVars(ContainerTemplate parent, ContainerTemplate template) {
        return PodTemplateUtils.combineEnvVars(parent.getEnvVars(), template.getEnvVars());
    }

    private static List<TemplateEnvVar> combineEnvVars(PodTemplate parent, PodTemplate template) {
        return PodTemplateUtils.combineEnvVars(parent.getEnvVars(), template.getEnvVars());
    }

    private static List<TemplateEnvVar> combineEnvVars(List<TemplateEnvVar> parent, List<TemplateEnvVar> child) {
        Map<String, TemplateEnvVar> combinedEnvVars = PodTemplateUtils.mergeMaps(PodTemplateUtils.templateEnvVarstoMap(parent), PodTemplateUtils.templateEnvVarstoMap(child));
        return combinedEnvVars.entrySet().stream().filter(entry -> !PodTemplateUtils.isNullOrEmpty((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    static Map<String, TemplateEnvVar> templateEnvVarstoMap(List<TemplateEnvVar> envVarList) {
        return envVarList.stream().collect(Collectors.toMap(TemplateEnvVar::getKey, Function.identity(), PodTemplateUtils.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static List<EnvFromSource> combinedEnvFromSources(Container parent, Container template) {
        ArrayList combinedEnvFromSources = new ArrayList();
        combinedEnvFromSources.addAll(parent.getEnvFrom());
        combinedEnvFromSources.addAll(template.getEnvFrom());
        return combinedEnvFromSources.stream().filter(envFromSource -> envFromSource.getConfigMapRef() != null && !PodTemplateUtils.isNullOrEmpty(envFromSource.getConfigMapRef().getName()) || envFromSource.getSecretRef() != null && !PodTemplateUtils.isNullOrEmpty(envFromSource.getSecretRef().getName())).collect(Collectors.toList());
    }

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> m1, Map<K, V> m2) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        if (m1 != null) {
            m.putAll(m1);
        }
        if (m2 != null) {
            m.putAll(m2);
        }
        return m;
    }

    static Long parseLong(String value) {
        String s = Util.fixEmptyAndTrim((String)value);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable List<?> list) {
        return list == null || list.isEmpty();
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return PodTemplateUtils.isNullOrEmpty(string) ? null : string;
    }

    private static class HierarchyResolver<P> {
        private final P parent;
        private final P child;

        HierarchyResolver(P parent, P child) {
            this.parent = parent;
            this.child = child;
        }

        <T> T resolve(Function<P, T> getter, Predicate<T> isDefaultValue) {
            T childValue = getter.apply(this.child);
            return !isDefaultValue.test(childValue) ? childValue : getter.apply(this.parent);
        }
    }
}

