/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public abstract class PodContainerSource
implements ExtensionPoint {
    public abstract Optional<String> getContainerWorkingDir(@NonNull Pod var1, @NonNull String var2);

    public abstract Optional<ContainerStatus> getContainerStatus(@NonNull Pod var1, @NonNull String var2);

    @NonNull
    public static List<PodContainerSource> all() {
        return ExtensionList.lookup(PodContainerSource.class);
    }

    public static Optional<String> lookupContainerWorkingDir(@NonNull Pod pod, @NonNull String containerName) {
        return PodContainerSource.all().stream().map(cs -> cs.getContainerWorkingDir(pod, containerName)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static Optional<ContainerStatus> lookupContainerStatus(Pod pod, String containerName) {
        return PodContainerSource.all().stream().map(cs -> cs.getContainerStatus(pod, containerName)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Extension
    public static final class DefaultPodContainerSource
    extends PodContainerSource {
        @Override
        public Optional<String> getContainerWorkingDir(@NonNull Pod pod, @NonNull String containerName) {
            return pod.getSpec().getContainers().stream().filter(c -> Objects.equals(c.getName(), containerName)).findAny().map(Container::getWorkingDir);
        }

        @Override
        public Optional<ContainerStatus> getContainerStatus(@NonNull Pod pod, @NonNull String containerName) {
            PodStatus podStatus = pod.getStatus();
            if (podStatus == null) {
                return Optional.empty();
            }
            return podStatus.getContainerStatuses().stream().filter(cs -> StringUtils.equals((String)cs.getName(), (String)containerName)).findFirst();
        }
    }
}

