/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFolderProperty;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.Messages;

@Extension
public class KubernetesQueueTaskDispatcher
extends QueueTaskDispatcher {
    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        Queue.Task ownerTask;
        KubernetesSlave slave;
        if (node instanceof KubernetesSlave && !KubernetesFolderProperty.isAllowed(slave = (KubernetesSlave)node, (Job)(ownerTask = item.task.getOwnerTask()))) {
            return new KubernetesCloudNotAllowed(slave.getKubernetesCloud(), (Job)ownerTask);
        }
        return null;
    }

    public static final class KubernetesCloudNotAllowed
    extends CauseOfBlockage {
        private final KubernetesCloud cloud;
        private final Job job;

        public KubernetesCloudNotAllowed(KubernetesCloud cloud, Job job) {
            this.cloud = cloud;
            this.job = job;
        }

        public String getShortDescription() {
            return Messages.KubernetesCloudNotAllowed_Description(this.cloud.name, this.job.getFullName());
        }
    }
}

