/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.Objects;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class HostPathWorkspaceVolume
extends WorkspaceVolume {
    private String hostPath;

    @DataBoundConstructor
    public HostPathWorkspaceVolume(String hostPath) {
        this.hostPath = hostPath;
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return ((VolumeBuilder)((VolumeFluent.HostPathNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewHostPath().withPath(this.getHostPath())).endHostPath()).build();
    }

    public String getHostPath() {
        return this.hostPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostPathWorkspaceVolume that = (HostPathWorkspaceVolume)o;
        return Objects.equals(this.hostPath, that.hostPath);
    }

    public int hashCode() {
        return Objects.hash(this.hostPath);
    }

    @Extension
    @Symbol(value={"hostPathWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "Host Path Workspace Volume";
        }
    }
}

