/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.Objects;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class EmptyDirWorkspaceVolume
extends WorkspaceVolume {
    private static final String DEFAULT_MEDIUM = "";
    private static final String MEMORY_MEDIUM = "Memory";
    @CheckForNull
    private Boolean memory;
    @CheckForNull
    private String sizeLimit;

    @DataBoundConstructor
    public EmptyDirWorkspaceVolume(Boolean memory) {
        this.memory = memory;
    }

    public String getMedium() {
        return this.getMemory() != false ? MEMORY_MEDIUM : DEFAULT_MEDIUM;
    }

    @NonNull
    public Boolean getMemory() {
        return this.memory != null && this.memory != false;
    }

    @CheckForNull
    public String getSizeLimit() {
        return this.sizeLimit;
    }

    @DataBoundSetter
    public void setSizeLimit(@CheckForNull String sizeLimit) {
        this.sizeLimit = Util.fixEmptyAndTrim((String)sizeLimit);
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return ((VolumeBuilder)((VolumeFluent.EmptyDirNested)((VolumeFluent.EmptyDirNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewEmptyDir().withMedium(this.getMedium())).withSizeLimit(this.getSizeLimitAsQuantity())).endEmptyDir()).build();
    }

    @CheckForNull
    private Quantity getSizeLimitAsQuantity() {
        String sizeLimit = this.getSizeLimit();
        return sizeLimit == null ? null : new Quantity(sizeLimit);
    }

    public String toString() {
        return "EmptyDirWorkspaceVolume [memory=" + this.memory + ", sizeLimit=" + this.sizeLimit + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmptyDirWorkspaceVolume that = (EmptyDirWorkspaceVolume)o;
        return Objects.equals(this.memory, that.memory) && Objects.equals(this.sizeLimit, that.sizeLimit);
    }

    public int hashCode() {
        return Objects.hash(this.memory, this.sizeLimit);
    }

    @Extension
    @Symbol(value={"emptyDirWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        @NonNull
        public String getDisplayName() {
            return "Empty Dir Workspace Volume";
        }
    }
}

