/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public interface ProvisionedVolume {
    default public String getStorageClassNameOrDefault() {
        return this.getStorageClassName();
    }

    public String getStorageClassName();

    default public Map<String, Quantity> getResourceMap() {
        return Collections.singletonMap("storage", new Quantity(this.getRequestsSizeOrDefault()));
    }

    default public String getRequestsSizeOrDefault() {
        return StringUtils.defaultString((String)this.getRequestsSize(), (String)"10Gi");
    }

    public String getRequestsSize();

    default public String getAccessModesOrDefault() {
        return StringUtils.defaultString((String)this.getAccessModes(), (String)"ReadWriteOnce");
    }

    public String getAccessModes();
}

