/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class NfsVolume
extends PodVolume {
    private String mountPath;
    private String serverAddress;
    private String serverPath;
    @CheckForNull
    private Boolean readOnly;

    @DataBoundConstructor
    public NfsVolume(String serverAddress, String serverPath, Boolean readOnly, String mountPath) {
        this.serverAddress = serverAddress;
        this.serverPath = serverPath;
        this.readOnly = readOnly;
        this.mountPath = mountPath;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewNfs(this.getServerPath(), this.getReadOnly(), this.getServerAddress())).build();
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    @NonNull
    public Boolean getReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    @Extension
    @Symbol(value={"nfsVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        @NonNull
        public String getDisplayName() {
            return "NFS Volume";
        }
    }
}

