/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerStepExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class Resources {
    private static final Logger LOGGER = Logger.getLogger(ContainerStepExecution.class.getName());

    public static void closeQuietly(@NonNull StepContext context, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                try {
                    TaskListener listener = (TaskListener)context.get(TaskListener.class);
                    if (listener == null) continue;
                    listener.error("Error while closing: [" + String.valueOf(c) + "]");
                }
                catch (IOException | InterruptedException e1) {
                    LOGGER.log(Level.WARNING, "Error writing to task listener", e);
                }
            }
        }
    }

    @NonNull
    public static BodyExecutionCallback closeQuietlyCallback(Closeable ... closeables) {
        return new CloseQuietlyBodyExecutionCallback(closeables);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private static class CloseQuietlyBodyExecutionCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6385838254761750483L;
        private final Closeable[] closeables;

        CloseQuietlyBodyExecutionCallback(Closeable ... closeables) {
            this.closeables = closeables;
        }

        public void finished(StepContext context) {
            Resources.closeQuietly(context, this.closeables);
        }
    }
}

