/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStepExecution;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.csanchez.jenkins.plugins.kubernetes.pod.yaml.YamlMergeStrategy;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PodTemplateStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 5588861066775717487L;
    @CheckForNull
    private String cloud;
    @CheckForNull
    private String inheritFrom;
    @CheckForNull
    private String label;
    @CheckForNull
    private String name;
    @CheckForNull
    private String namespace;
    private List<ContainerTemplate> containers = new ArrayList<ContainerTemplate>();
    private List<TemplateEnvVar> envVars = new ArrayList<TemplateEnvVar>();
    private List<PodVolume> volumes = new ArrayList<PodVolume>();
    @CheckForNull
    private WorkspaceVolume workspaceVolume;
    private List<PodAnnotation> annotations = new ArrayList<PodAnnotation>();
    private List<String> imagePullSecrets = new ArrayList<String>();
    private Integer instanceCap = Integer.MAX_VALUE;
    private int idleMinutes;
    private int slaveConnectTimeout = PodTemplate.DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT;
    private int activeDeadlineSeconds;
    private Boolean hostNetwork;
    @CheckForNull
    private String serviceAccount;
    @CheckForNull
    private String schedulerName;
    @CheckForNull
    private String nodeSelector;
    private Node.Mode nodeUsageMode = Node.Mode.EXCLUSIVE;
    private String workingDir = "/home/jenkins/agent";
    @CheckForNull
    private String yaml;
    private YamlMergeStrategy yamlMergeStrategy;
    @CheckForNull
    private Boolean inheritYamlMergeStrategy;
    @CheckForNull
    private PodRetention podRetention;
    private Boolean showRawYaml;
    @CheckForNull
    private String runAsUser;
    @CheckForNull
    private String runAsGroup;
    @CheckForNull
    private String supplementalGroups;
    @CheckForNull
    private String agentContainer;
    private boolean agentInjection;

    @DataBoundConstructor
    public PodTemplateStep() {
    }

    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setLabel(@CheckForNull String label) {
        this.label = Util.fixEmpty((String)label);
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(@CheckForNull String name) {
        this.name = Util.fixEmpty((String)name);
    }

    @CheckForNull
    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(@CheckForNull String namespace) {
        this.namespace = Util.fixEmpty((String)namespace);
    }

    @CheckForNull
    public String getCloud() {
        return this.cloud;
    }

    @DataBoundSetter
    public void setCloud(@CheckForNull String cloud) {
        this.cloud = Util.fixEmpty((String)cloud);
    }

    @CheckForNull
    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(@CheckForNull String inheritFrom) {
        this.inheritFrom = "<default>".equals(inheritFrom) ? null : inheritFrom;
    }

    public boolean isAgentInjection() {
        return this.agentInjection;
    }

    @DataBoundSetter
    public void setAgentInjection(boolean agentInjection) {
        this.agentInjection = agentInjection;
    }

    @CheckForNull
    public String getAgentContainer() {
        return this.agentContainer;
    }

    @DataBoundSetter
    public void setAgentContainer(@CheckForNull String agentContainer) {
        this.agentContainer = Util.fixEmpty((String)agentContainer);
    }

    public List<ContainerTemplate> getContainers() {
        return this.containers;
    }

    @DataBoundSetter
    public void setContainers(List<ContainerTemplate> containers) {
        this.containers = containers;
    }

    public List<TemplateEnvVar> getEnvVars() {
        return this.envVars == null ? Collections.emptyList() : this.envVars;
    }

    @DataBoundSetter
    public void setEnvVars(List<TemplateEnvVar> envVars) {
        if (envVars != null) {
            this.envVars.clear();
            this.envVars.addAll(envVars);
        }
    }

    @CheckForNull
    public YamlMergeStrategy getYamlMergeStrategy() {
        return this.yamlMergeStrategy;
    }

    @DataBoundSetter
    public void setYamlMergeStrategy(YamlMergeStrategy yamlMergeStrategy) {
        this.yamlMergeStrategy = yamlMergeStrategy;
    }

    public List<PodVolume> getVolumes() {
        return this.volumes;
    }

    @DataBoundSetter
    public void setVolumes(List<PodVolume> volumes) {
        this.volumes = volumes;
    }

    @CheckForNull
    public WorkspaceVolume getWorkspaceVolume() {
        return this.workspaceVolume == null ? DescriptorImpl.defaultWorkspaceVolume : this.workspaceVolume;
    }

    @DataBoundSetter
    public void setWorkspaceVolume(@CheckForNull WorkspaceVolume workspaceVolume) {
        this.workspaceVolume = workspaceVolume == null || workspaceVolume.equals(DescriptorImpl.defaultWorkspaceVolume) ? null : workspaceVolume;
    }

    public Integer getInstanceCap() {
        return this.instanceCap;
    }

    @DataBoundSetter
    public void setInstanceCap(@CheckForNull Integer instanceCap) {
        this.instanceCap = instanceCap == null || instanceCap <= 0 ? Integer.valueOf(Integer.MAX_VALUE) : instanceCap;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    @DataBoundSetter
    public void setIdleMinutes(@CheckForNull int idleMinutes) {
        this.idleMinutes = idleMinutes;
    }

    @CheckForNull
    public int getSlaveConnectTimeout() {
        return this.slaveConnectTimeout;
    }

    @DataBoundSetter
    public void setSlaveConnectTimeout(@CheckForNull int slaveConnectTimeout) {
        this.slaveConnectTimeout = slaveConnectTimeout;
    }

    @CheckForNull
    public int getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @DataBoundSetter
    public void setActiveDeadlineSeconds(@CheckForNull int activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    @DataBoundSetter
    public void setHostNetwork(boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    @CheckForNull
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @DataBoundSetter
    public void setServiceAccount(@CheckForNull String serviceAccount) {
        this.serviceAccount = Util.fixEmpty((String)serviceAccount);
    }

    @CheckForNull
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @DataBoundSetter
    public void setSchedulerName(@CheckForNull String schedulerName) {
        this.schedulerName = Util.fixEmpty((String)schedulerName);
    }

    @CheckForNull
    public String getNodeSelector() {
        return this.nodeSelector;
    }

    @DataBoundSetter
    public void setNodeSelector(@CheckForNull String nodeSelector) {
        this.nodeSelector = Util.fixEmpty((String)nodeSelector);
    }

    public Node.Mode getNodeUsageMode() {
        return this.nodeUsageMode;
    }

    public void setNodeUsageMode(Node.Mode nodeUsageMode) {
        this.nodeUsageMode = nodeUsageMode;
    }

    @DataBoundSetter
    public void setNodeUsageMode(String nodeUsageMode) {
        this.nodeUsageMode = Node.Mode.valueOf((String)nodeUsageMode);
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new PodTemplateStepExecution(this, context);
    }

    public List<PodAnnotation> getAnnotations() {
        return this.annotations;
    }

    @DataBoundSetter
    public void setAnnotations(List<PodAnnotation> annotations) {
        this.annotations = annotations;
    }

    public List<String> getImagePullSecrets() {
        return this.imagePullSecrets == null ? Collections.emptyList() : this.imagePullSecrets;
    }

    @DataBoundSetter
    public void setImagePullSecrets(List<String> imagePullSecrets) {
        if (imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this.imagePullSecrets.addAll(imagePullSecrets);
        }
    }

    @CheckForNull
    public String getYaml() {
        return this.yaml;
    }

    @DataBoundSetter
    public void setYaml(@CheckForNull String yaml) {
        this.yaml = Util.fixEmpty((String)yaml);
    }

    @CheckForNull
    public PodRetention getPodRetention() {
        return this.podRetention == null ? DescriptorImpl.defaultPodRetention : this.podRetention;
    }

    @DataBoundSetter
    public void setPodRetention(@CheckForNull PodRetention podRetention) {
        this.podRetention = podRetention == null || ((Object)((Object)podRetention)).equals((Object)DescriptorImpl.defaultPodRetention) ? null : podRetention;
    }

    public boolean isInheritYamlMergeStrategy() {
        return Optional.ofNullable(this.inheritYamlMergeStrategy).orElse(false);
    }

    @DataBoundSetter
    public void setInheritYamlMergeStrategy(boolean inheritYamlMergeStrategy) {
        this.inheritYamlMergeStrategy = inheritYamlMergeStrategy;
    }

    boolean isShowRawYamlSet() {
        return this.showRawYaml != null;
    }

    public boolean isShowRawYaml() {
        return this.isShowRawYamlSet() ? this.showRawYaml : true;
    }

    @DataBoundSetter
    public void setShowRawYaml(boolean showRawYaml) {
        this.showRawYaml = showRawYaml;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    @DataBoundSetter
    public void setRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
    }

    public String getRunAsGroup() {
        return this.runAsGroup;
    }

    @DataBoundSetter
    public void setRunAsGroup(String runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    @CheckForNull
    public String getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @DataBoundSetter
    public void setSupplementalGroups(@CheckForNull String supplementalGroups) {
        this.supplementalGroups = Util.fixEmpty((String)supplementalGroups);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        static final String[] POD_TEMPLATE_FIELDS = new String[]{"name", "namespace", "inheritFrom", "containers", "envVars", "volumes", "annotations", "yaml", "showRawYaml", "instanceCap", "podRetention", "supplementalGroups", "idleMinutes", "activeDeadlineSeconds", "serviceAccount", "nodeSelector", "workingDir", "workspaceVolume", "agentContainer", "agentInjection"};
        public static final Integer defaultInstanceCap = Integer.MAX_VALUE;
        public static final PodRetention defaultPodRetention = PodRetention.getPodTemplateDefault();
        public static final WorkspaceVolume defaultWorkspaceVolume = WorkspaceVolume.getDefault();
        public static final String defaultInheritFrom = "<default>";

        public DescriptorImpl() {
            for (String field : POD_TEMPLATE_FIELDS) {
                this.addHelpFileRedirect(field, PodTemplate.class, field);
            }
        }

        public ListBoxModel doFillCloudItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("\u2014any\u2014", "");
            if (!Jenkins.get().hasPermission(Jenkins.MANAGE)) {
                return result;
            }
            Jenkins.get().clouds.getAll(KubernetesCloud.class).forEach(cloud -> result.add(cloud.name));
            return result;
        }

        public ListBoxModel doFillInheritFromItems(@QueryParameter(value="cloud") String cloudName) {
            cloudName = Util.fixEmpty((String)cloudName);
            ListBoxModel result = new ListBoxModel();
            result.add("\u2014Default inheritance\u2014", defaultInheritFrom);
            result.add("\u2014Disable inheritance\u2014", " ");
            if (!Jenkins.get().hasPermission(Jenkins.MANAGE)) {
                return result;
            }
            Cloud cloud = cloudName == null ? (Cloud)Jenkins.get().clouds.get(KubernetesCloud.class) : Jenkins.get().getCloud(cloudName);
            if (cloud instanceof KubernetesCloud) {
                List<PodTemplate> templates = ((KubernetesCloud)cloud).getTemplates();
                result.addAll((Collection)templates.stream().filter(template -> StringUtils.isNotEmpty((String)template.getName())).map(PodTemplate::getName).map(ListBoxModel.Option::new).collect(Collectors.toList()));
            }
            return result;
        }

        public String getFunctionName() {
            return "podTemplate";
        }

        public String getDisplayName() {
            return "Define a podTemplate to use in the kubernetes plugin";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Run.class, TaskListener.class)));
        }

        public String getWorkingDir() {
            return "/home/jenkins/agent";
        }
    }
}

