/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Label;
import hudson.util.ListBoxModel;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.Messages;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStep;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.csanchez.jenkins.plugins.kubernetes.pod.yaml.YamlMergeStrategy;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.RetryableDeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.CompatibilityLoader;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Serialization happens exclusively through XStream and not Java Serialization.")
public class KubernetesDeclarativeAgent
extends RetryableDeclarativeAgent<KubernetesDeclarativeAgent> {
    private static final Logger LOGGER = Logger.getLogger(KubernetesDeclarativeAgent.class.getName());
    @CheckForNull
    private String label;
    @CheckForNull
    private String customWorkspace;
    @CheckForNull
    private String cloud;
    @CheckForNull
    private String inheritFrom;
    private int idleMinutes;
    private int instanceCap = Integer.MAX_VALUE;
    @CheckForNull
    private String serviceAccount;
    @CheckForNull
    private String schedulerName;
    @CheckForNull
    private String nodeSelector;
    @CheckForNull
    private String namespace;
    @CheckForNull
    private String workingDir;
    private int activeDeadlineSeconds;
    private int slaveConnectTimeout;
    @CheckForNull
    private PodRetention podRetention;
    private ContainerTemplate containerTemplate;
    private List<ContainerTemplate> containerTemplates;
    @CheckForNull
    private String defaultContainer;
    @CheckForNull
    private String yaml;
    @CheckForNull
    private String yamlFile;
    @CheckForNull
    private Boolean showRawYaml;
    private YamlMergeStrategy yamlMergeStrategy;
    @CheckForNull
    private Boolean inheritYamlMergeStrategy;
    @CheckForNull
    private WorkspaceVolume workspaceVolume;
    @CheckForNull
    private String supplementalGroups;
    @CheckForNull
    private String agentContainer;
    @CheckForNull
    private boolean agentInjection;

    @DataBoundConstructor
    public KubernetesDeclarativeAgent() {
    }

    @Deprecated
    public KubernetesDeclarativeAgent(String label, ContainerTemplate containerTemplate) {
        this.label = label;
        this.containerTemplate = containerTemplate;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelExpression() {
        return this.label != null ? Label.parse((String)this.label).stream().map(Objects::toString).sorted().collect(Collectors.joining(" && ")) : null;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = Util.fixEmpty((String)label);
    }

    @CheckForNull
    public String getCustomWorkspace() {
        return this.customWorkspace;
    }

    @DataBoundSetter
    public void setCustomWorkspace(String customWorkspace) {
        this.customWorkspace = customWorkspace;
    }

    public String getCloud() {
        return this.cloud;
    }

    @DataBoundSetter
    public void setCloud(String cloud) {
        this.cloud = Util.fixEmpty((String)cloud);
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    @DataBoundSetter
    public void setIdleMinutes(int idleMinutes) {
        this.idleMinutes = idleMinutes;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = "<default>".equals(inheritFrom) ? null : inheritFrom;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    @DataBoundSetter
    public void setInstanceCap(int instanceCap) {
        this.instanceCap = instanceCap <= 0 ? Integer.MAX_VALUE : instanceCap;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @DataBoundSetter
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    @DataBoundSetter
    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public String getNodeSelector() {
        return this.nodeSelector;
    }

    @DataBoundSetter
    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getYaml() {
        return this.yaml;
    }

    @DataBoundSetter
    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    @Deprecated
    public ContainerTemplate getContainerTemplate() {
        return this.containerTemplate;
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setContainerTemplate(ContainerTemplate containerTemplate) {
        this.containerTemplate = containerTemplate;
    }

    @NonNull
    public List<ContainerTemplate> getContainerTemplates() {
        return this.containerTemplates != null ? this.containerTemplates : Collections.emptyList();
    }

    @DataBoundSetter
    public void setContainerTemplates(List<ContainerTemplate> containerTemplates) {
        this.containerTemplates = containerTemplates;
    }

    public String getDefaultContainer() {
        return this.defaultContainer;
    }

    @DataBoundSetter
    public void setDefaultContainer(String defaultContainer) {
        this.defaultContainer = defaultContainer;
    }

    public int getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @DataBoundSetter
    public void setActiveDeadlineSeconds(int activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public int getSlaveConnectTimeout() {
        return this.slaveConnectTimeout;
    }

    @DataBoundSetter
    public void setSlaveConnectTimeout(int slaveConnectTimeout) {
        this.slaveConnectTimeout = slaveConnectTimeout;
    }

    public PodRetention getPodRetention() {
        return this.podRetention == null ? PodTemplateStep.DescriptorImpl.defaultPodRetention : this.podRetention;
    }

    @DataBoundSetter
    public void setPodRetention(@CheckForNull PodRetention podRetention) {
        this.podRetention = podRetention == null || ((Object)((Object)podRetention)).equals((Object)PodTemplateStep.DescriptorImpl.defaultPodRetention) ? null : podRetention;
    }

    public String getYamlFile() {
        return this.yamlFile;
    }

    @DataBoundSetter
    public void setShowRawYaml(Boolean showRawYaml) {
        this.showRawYaml = showRawYaml;
    }

    public Boolean getShowRawYaml() {
        return this.showRawYaml;
    }

    @DataBoundSetter
    public void setYamlFile(String yamlFile) {
        this.yamlFile = yamlFile;
    }

    public YamlMergeStrategy getYamlMergeStrategy() {
        return this.yamlMergeStrategy;
    }

    @DataBoundSetter
    public void setYamlMergeStrategy(YamlMergeStrategy yamlMergeStrategy) {
        this.yamlMergeStrategy = yamlMergeStrategy;
    }

    public boolean isInheritYamlMergeStrategy() {
        return Optional.ofNullable(this.inheritYamlMergeStrategy).orElse(false);
    }

    @DataBoundSetter
    public void setInheritYamlMergeStrategy(boolean inheritYamlMergeStrategy) {
        this.inheritYamlMergeStrategy = inheritYamlMergeStrategy;
    }

    public WorkspaceVolume getWorkspaceVolume() {
        return this.workspaceVolume == null ? PodTemplateStep.DescriptorImpl.defaultWorkspaceVolume : this.workspaceVolume;
    }

    @DataBoundSetter
    public void setWorkspaceVolume(WorkspaceVolume workspaceVolume) {
        this.workspaceVolume = workspaceVolume == null || workspaceVolume.equals(PodTemplateStep.DescriptorImpl.defaultWorkspaceVolume) ? null : workspaceVolume;
    }

    @DataBoundSetter
    public void setSupplementalGroups(String supplementalGroups) {
        this.supplementalGroups = Util.fixEmpty((String)supplementalGroups);
    }

    public String getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @CheckForNull
    public String getAgentContainer() {
        return this.agentContainer;
    }

    @DataBoundSetter
    public void setAgentContainer(@CheckForNull String agentContainer) {
        this.agentContainer = agentContainer;
    }

    @CheckForNull
    public boolean isAgentInjection() {
        return this.agentInjection;
    }

    @DataBoundSetter
    public void setAgentInjection(boolean agentInjection) {
        this.agentInjection = agentInjection;
    }

    public Map<String, Object> getAsArgs() {
        TreeMap<String, Object> argMap = new TreeMap<String, Object>();
        if (this.label != null) {
            argMap.put("label", this.label);
        }
        List<ContainerTemplate> containerTemplates = this.getContainerTemplates();
        if (this.containerTemplate != null) {
            LOGGER.log(Level.WARNING, "containerTemplate option in declarative pipeline is deprecated, use yaml syntax to define containers");
            if (containerTemplates.isEmpty()) {
                containerTemplates = Collections.singletonList(this.containerTemplate);
            } else {
                LOGGER.log(Level.WARNING, "Ignoring containerTemplate option as containerTemplates is also defined");
            }
        }
        if (!containerTemplates.isEmpty()) {
            argMap.put("containers", containerTemplates);
        }
        if (!StringUtils.isEmpty((String)this.yaml)) {
            argMap.put("yaml", this.yaml);
        }
        if (this.showRawYaml != null) {
            argMap.put("showRawYaml", this.showRawYaml);
        }
        if (this.yamlMergeStrategy != null) {
            argMap.put("yamlMergeStrategy", this.yamlMergeStrategy);
        }
        if (this.inheritYamlMergeStrategy != null) {
            argMap.put("inheritYamlMergeStrategy", this.inheritYamlMergeStrategy);
        }
        if (this.workspaceVolume != null) {
            argMap.put("workspaceVolume", this.workspaceVolume);
        }
        if (!StringUtils.isEmpty((String)this.cloud)) {
            argMap.put("cloud", this.cloud);
        }
        if (this.idleMinutes != 0) {
            argMap.put("idleMinutes", this.idleMinutes);
        }
        if (this.inheritFrom != null) {
            argMap.put("inheritFrom", this.inheritFrom);
        }
        if (!StringUtils.isEmpty((String)this.serviceAccount)) {
            argMap.put("serviceAccount", this.serviceAccount);
        }
        if (!StringUtils.isEmpty((String)this.nodeSelector)) {
            argMap.put("nodeSelector", this.nodeSelector);
        }
        if (!StringUtils.isEmpty((String)this.namespace)) {
            argMap.put("namespace", this.namespace);
        }
        if (!StringUtils.isEmpty((String)this.workingDir)) {
            argMap.put("workingDir", this.workingDir);
        }
        if (this.activeDeadlineSeconds != 0) {
            argMap.put("activeDeadlineSeconds", this.activeDeadlineSeconds);
        }
        if (this.slaveConnectTimeout != 0) {
            argMap.put("slaveConnectTimeout", this.slaveConnectTimeout);
        }
        if (this.podRetention != null) {
            argMap.put("podRetention", (Object)this.podRetention);
        }
        if (this.instanceCap > 0 && this.instanceCap < Integer.MAX_VALUE) {
            argMap.put("instanceCap", this.instanceCap);
        }
        if (!StringUtils.isEmpty((String)this.supplementalGroups)) {
            argMap.put("supplementalGroups", this.supplementalGroups);
        }
        if (!StringUtils.isEmpty((String)this.agentContainer)) {
            argMap.put("agentContainer", this.agentContainer);
        }
        if (this.agentInjection) {
            argMap.put("agentInjection", this.agentInjection);
        }
        return argMap;
    }

    @OptionalExtension(requirePlugins={"pipeline-model-extensions"})
    public static final class Compat
    implements CompatibilityLoader {
        public URL loadGroovySource(String clazz) {
            return "org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesDeclarativeAgentScript".equals(clazz) ? KubernetesDeclarativeAgent.class.getResource("KubernetesDeclarativeAgentScript-old.groovy") : null;
        }
    }

    @OptionalExtension(requirePlugins={"pipeline-model-extensions"})
    @Symbol(value={"kubernetes"})
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<KubernetesDeclarativeAgent> {
        static final String[] POD_TEMPLATE_FIELDS = new String[]{"namespace", "inheritFrom", "yaml", "showRawYaml", "instanceCap", "podRetention", "supplementalGroups", "idleMinutes", "activeDeadlineSeconds", "serviceAccount", "nodeSelector", "workingDir", "workspaceVolume", "agentContainer", "agentInjection"};

        public DescriptorImpl() {
            for (String field : new String[]{"cloud", "label"}) {
                this.addHelpFileRedirect(field, PodTemplateStep.class, field);
            }
            for (String field : POD_TEMPLATE_FIELDS) {
                this.addHelpFileRedirect(field, PodTemplate.class, field);
            }
        }

        @NonNull
        public String getDisplayName() {
            return Messages.KubernetesDeclarativeAgent_displayName();
        }

        public ListBoxModel doFillCloudItems() {
            return ((PodTemplateStep.DescriptorImpl)((Object)ExtensionList.lookupSingleton(PodTemplateStep.DescriptorImpl.class))).doFillCloudItems();
        }

        public ListBoxModel doFillInheritFromItems(@QueryParameter(value="cloud") String cloudName) {
            return ((PodTemplateStep.DescriptorImpl)((Object)ExtensionList.lookupSingleton(PodTemplateStep.DescriptorImpl.class))).doFillInheritFromItems(cloudName);
        }

        public PodRetention getDefaultPodRetention() {
            return PodRetention.getPodTemplateDefault();
        }

        public WorkspaceVolume getDefaultWorkspaceVolume() {
            return WorkspaceVolume.getDefault();
        }
    }
}

