/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Proc;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.Timer;
import org.apache.commons.io.output.NullPrintStream;

public class ContainerExecProc
extends Proc
implements Closeable,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(ContainerExecProc.class.getName());
    private final AtomicBoolean alive;
    private final CountDownLatch finished;
    private final ExecWatch watch;
    private final OutputStream stdin;
    private final PrintStream printStream;

    @Deprecated
    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, Callable<Integer> exitCode) {
        this(watch, alive, finished, (OutputStream)null, (PrintStream)null);
    }

    @Deprecated
    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, ByteArrayOutputStream error) {
        this(watch, alive, finished, (OutputStream)null, (PrintStream)null);
    }

    @Deprecated
    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, OutputStream stdin, ByteArrayOutputStream error) {
        this(watch, alive, finished, stdin, (PrintStream)null);
    }

    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, OutputStream stdin, PrintStream printStream) {
        this.watch = watch;
        this.stdin = stdin == null ? watch.getInput() : stdin;
        this.alive = alive;
        this.finished = finished;
        this.printStream = printStream == null ? NullPrintStream.NULL_PRINT_STREAM : printStream;
        Timer.get().schedule(this, 1L, TimeUnit.MINUTES);
    }

    public boolean isAlive() {
        return this.alive.get();
    }

    public void kill() throws IOException, InterruptedException {
        try {
            this.stdin.write(3);
            this.stdin.write("exit".getBytes(StandardCharsets.UTF_8));
            this.stdin.write("\n".getBytes(StandardCharsets.UTF_8));
            this.stdin.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Proc kill failed, ignoring", e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int join() throws IOException, InterruptedException {
        try {
            LOGGER.log(Level.FINEST, "Waiting for websocket to close on command finish ({0})", this.finished);
            this.finished.await();
            LOGGER.log(Level.FINEST, "Command is finished ({0})", this.finished);
            CompletableFuture exitCodeFuture = this.watch.exitCode();
            if (exitCodeFuture == null) {
                LOGGER.log(Level.FINEST, "exitCodeFuture is null.");
                this.printStream.print("exitCodeFuture is null.");
                int n = -1;
                return n;
            }
            Integer exitCode = (Integer)exitCodeFuture.get();
            if (exitCode == null) {
                LOGGER.log(Level.FINEST, "The container exec watch was closed before it could obtain an exit code from the process.");
                this.printStream.print("The container exec watch was closed before it could obtain an exit code from the process.");
                int n = -1;
                return n;
            }
            int n = exitCode;
            return n;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                LOGGER.log(Level.FINEST, "ExecutionException occurred while waiting for exit code", cause);
                this.printStream.printf("ExecutionException occurred while waiting for exit code: %s%n", cause);
            } else {
                LOGGER.log(Level.FINEST, "ExecutionException occurred while waiting for exit code", e);
                this.printStream.printf("ExecutionException occurred while waiting for exit code: %s%n", e);
            }
            int n = -1;
            return n;
        }
        finally {
            this.close();
        }
    }

    public InputStream getStdout() {
        return this.watch.getOutput();
    }

    public InputStream getStderr() {
        return this.watch.getError();
    }

    public OutputStream getStdin() {
        return this.stdin;
    }

    @Override
    public void close() throws IOException {
        try {
            this.watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }

    @Override
    public void run() {
        if (!this.isAlive()) {
            LOGGER.fine("process is no longer alive");
            return;
        }
        try {
            this.stdin.write("\n".getBytes(StandardCharsets.UTF_8));
            this.stdin.flush();
            LOGGER.fine("sent a newline to keep socket alive");
            Timer.get().schedule(this, 1L, TimeUnit.MINUTES);
        }
        catch (IOException x) {
            LOGGER.log(Level.FINE, "socket keepalive failed", x);
        }
    }
}

