/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.model.TaskListener;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class TaskListenerEventWatcher
implements Watcher<Event> {
    private static final Logger LOGGER = Logger.getLogger(TaskListenerEventWatcher.class.getName());
    private final String name;
    private final TaskListener listener;

    public TaskListenerEventWatcher(@NonNull String name, @NonNull TaskListener listener) {
        this.name = name;
        this.listener = listener;
    }

    public void eventReceived(Watcher.Action action, Event event) {
        if (action != Watcher.Action.BOOKMARK && event != null) {
            String[] lines;
            PrintStream logger = this.listener.getLogger();
            for (String line : lines = event.getMessage().split("\n")) {
                logger.printf("[%s][%s/%s][%s] %s%n", event.getType(), event.getInvolvedObject().getNamespace(), event.getInvolvedObject().getName(), event.getReason(), line);
            }
        }
    }

    public void onClose(WatcherException cause) {
        String msg = String.format("%s onClose: %s", this.getClass().getSimpleName(), this.name);
        if (cause != null) {
            LOGGER.log(Level.WARNING, msg, (Throwable)cause);
            Functions.printStackTrace((Throwable)cause, (PrintStream)this.listener.getLogger());
        } else {
            LOGGER.log(Level.FINE, msg);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + "]";
    }
}

