/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.CapabilitiesBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.SeccompProfile;
import io.fabric8.kubernetes.api.model.SeccompProfileBuilder;
import io.fabric8.kubernetes.api.model.SecurityContext;
import java.util.List;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.pod.decorator.PodDecorator;

@Extension
public class RestrictedPssSecurityContextInjector
implements PodDecorator {
    private static final Logger LOGGER = Logger.getLogger(RestrictedPssSecurityContextInjector.class.getName());
    private static final String SECCOMP_RUNTIME_DEFAULT = "RuntimeDefault";
    private static final String CAPABILITIES_ALL = "ALL";

    @Override
    @NonNull
    public Pod decorate(@NonNull KubernetesCloud kubernetesCloud, @NonNull Pod pod) {
        if (kubernetesCloud.isRestrictedPssSecurityContext()) {
            ObjectMeta metadata = pod.getMetadata();
            if (metadata == null) {
                LOGGER.warning("No metadata found in the pod, skipping the security context update");
                return pod;
            }
            String ns = metadata.getNamespace();
            String name = metadata.getName();
            LOGGER.fine(() -> "Updating pod + " + ns + "/" + name + "  containers security context due to the configured restricted Pod Security Admission");
            PodSpec spec = pod.getSpec();
            if (spec == null) {
                LOGGER.warning("No spec found in the pod, skipping the security context update");
                return pod;
            }
            RestrictedPssSecurityContextInjector.secure(spec.getInitContainers());
            RestrictedPssSecurityContextInjector.secure(spec.getContainers());
        }
        return pod;
    }

    private static void secure(@CheckForNull List<Container> containers) {
        if (containers != null) {
            containers.forEach(RestrictedPssSecurityContextInjector::secure);
        }
    }

    private static void secure(@NonNull Container container) {
        Capabilities capabilities;
        SeccompProfile seccompProfile;
        SecurityContext securityContext = container.getSecurityContext();
        if (securityContext == null) {
            securityContext = new SecurityContext();
            container.setSecurityContext(securityContext);
        }
        if (securityContext.getAllowPrivilegeEscalation() == null) {
            securityContext.setAllowPrivilegeEscalation(Boolean.valueOf(false));
        }
        if (securityContext.getRunAsNonRoot() == null) {
            securityContext.setRunAsNonRoot(Boolean.valueOf(true));
        }
        if ((seccompProfile = securityContext.getSeccompProfile()) == null) {
            securityContext.setSeccompProfile(((SeccompProfileBuilder)new SeccompProfileBuilder().withType(SECCOMP_RUNTIME_DEFAULT)).build());
        }
        if ((capabilities = securityContext.getCapabilities()) == null) {
            securityContext.setCapabilities(((CapabilitiesBuilder)new CapabilitiesBuilder().withDrop(List.of(CAPABILITIES_ALL))).build());
        }
    }
}

