/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.TcpSlaveAgentListener;
import hudson.Util;
import hudson.slaves.SlaveComputer;
import hudson.util.IOUtils;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerLivenessProbe;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStepExecution;
import org.csanchez.jenkins.plugins.kubernetes.pod.decorator.PodDecorator;
import org.csanchez.jenkins.plugins.kubernetes.volumes.ConfigMapVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.HostPathVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PodTemplateBuilder {
    private static final Logger LOGGER;
    private static final String WORKSPACE_VOLUME_NAME = "workspace-volume";
    public static final Pattern FROM_DIRECTIVE;
    public static final String LABEL_KUBERNETES_CONTROLLER = "kubernetes.jenkins.io/controller";
    static final String NO_RECONNECT_AFTER_TIMEOUT;
    private static final String JENKINS_AGENT_FILE_ENVVAR = "JENKINS_AGENT_FILE";
    private static final String JENKINS_AGENT = "/jenkins-agent";
    @Restricted(value={NoExternalUse.class})
    static String DEFAULT_JNLP_DOCKER_REGISTRY_PREFIX;
    private static final String defaultImageName;
    @Restricted(value={NoExternalUse.class})
    static final String DEFAULT_AGENT_IMAGE;
    static final String DEFAULT_JNLP_CONTAINER_MEMORY_REQUEST;
    static final String DEFAULT_JNLP_CONTAINER_CPU_REQUEST;
    static final String DEFAULT_JNLP_CONTAINER_MEMORY_LIMIT;
    static final String DEFAULT_JNLP_CONTAINER_CPU_LIMIT;
    private static final String JNLPMAC_REF = "\\$\\{computer.jnlpmac\\}";
    private static final String NAME_REF = "\\$\\{computer.name\\}";
    private PodTemplate template;
    @CheckForNull
    private KubernetesSlave agent;
    @CheckForNull
    private KubernetesCloud cloud;

    @Deprecated
    public PodTemplateBuilder(PodTemplate template) {
        this.template = template;
    }

    public PodTemplateBuilder(PodTemplate template, KubernetesSlave agent) {
        this.template = template;
        this.agent = agent;
        this.cloud = agent.getKubernetesCloud();
    }

    public PodTemplateBuilder withSlave(@NonNull KubernetesSlave slave) {
        this.agent = slave;
        this.cloud = slave.getKubernetesCloud();
        return this;
    }

    @Deprecated
    public Pod build(KubernetesSlave slave) {
        LOGGER.log(Level.WARNING, "This method is deprecated and does nothing");
        return this.build();
    }

    public Pod build() {
        Pod pod;
        Map<String, String> nodeSelector;
        List imagePullSecrets;
        Map<String, String> annotations;
        HashMap<Object, Volume> volumes = new HashMap<Object, Volume>();
        HashMap<String, VolumeMount> volumeMounts = new HashMap<String, VolumeMount>();
        if (this.agent == null) {
            throw new IllegalStateException("No KubernetesSlave is set");
        }
        String podName = this.agent.getPodName();
        int i = 0;
        for (PodVolume podVolume : this.template.getVolumes()) {
            ConfigMapVolume configmapVolume;
            String subPath;
            String volumeName = "volume-" + i;
            String mountPath = this.normalizePath(podVolume.getMountPath());
            if (volumeMounts.containsKey(mountPath)) continue;
            VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(mountPath)).withName(volumeName)).withReadOnly(Boolean.valueOf(false));
            if (podVolume instanceof ConfigMapVolume && (subPath = (configmapVolume = (ConfigMapVolume)podVolume).getSubPath()) != null) {
                volumeMountBuilder = (VolumeMountBuilder)volumeMountBuilder.withSubPath(this.normalizePath(subPath));
            }
            if (podVolume instanceof HostPathVolume) {
                HostPathVolume hostPathVolume = (HostPathVolume)podVolume;
                Boolean readOnly = hostPathVolume.getReadOnly();
                volumeMountBuilder = (VolumeMountBuilder)volumeMountBuilder.withReadOnly(readOnly);
            }
            volumeMounts.put(mountPath, volumeMountBuilder.build());
            volumes.put(volumeName, podVolume.buildVolume(volumeName, podName));
            ++i;
        }
        volumes.put(WORKSPACE_VOLUME_NAME, this.template.getWorkspaceVolume().buildVolume(WORKSPACE_VOLUME_NAME, podName));
        HashMap<String, Container> containers = new HashMap<String, Container>();
        for (ContainerTemplate containerTemplate : this.template.getContainers()) {
            containers.put(containerTemplate.getName(), this.createContainer(containerTemplate, this.template.getEnvVars(), volumeMounts.values()));
        }
        PodFluent.MetadataNested metadataNested = new PodBuilder().withNewMetadata();
        if (this.agent != null) {
            metadataNested.withName(this.agent.getPodName());
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        if (this.agent != null) {
            labels.putAll(this.agent.getKubernetesCloud().getPodLabelsMap());
        }
        labels.putAll(this.template.getLabelsMap());
        if (!labels.isEmpty()) {
            metadataNested.withLabels(labels);
        }
        if (this.cloud != null) {
            metadataNested.addToLabels(LABEL_KUBERNETES_CONTROLLER, PodTemplateUtils.sanitizeLabel(this.cloud.getJenkinsUrlOrNull()));
        }
        if (!(annotations = this.getAnnotationsMap(this.template.getAnnotations())).isEmpty()) {
            metadataNested.withAnnotations(annotations);
        }
        PodFluent.SpecNested builder = ((PodBuilder)metadataNested.endMetadata()).withNewSpec();
        if (this.template.getActiveDeadlineSeconds() > 0) {
            builder = (PodFluent.SpecNested)builder.withActiveDeadlineSeconds(Long.valueOf(this.template.getActiveDeadlineSeconds()));
        }
        if (!volumes.isEmpty()) {
            builder.withVolumes(volumes.values().toArray(new Volume[volumes.size()]));
        }
        if (this.template.getServiceAccount() != null) {
            builder.withServiceAccountName(PodTemplateUtils.substituteEnv(this.template.getServiceAccount()));
        }
        if (this.template.getSchedulerName() != null) {
            builder.withSchedulerName(PodTemplateUtils.substituteEnv(this.template.getSchedulerName()));
        }
        if (!(imagePullSecrets = this.template.getImagePullSecrets().stream().map(x -> x.toLocalObjectReference()).collect(Collectors.toList())).isEmpty()) {
            builder.withImagePullSecrets(imagePullSecrets);
        }
        if (!(nodeSelector = this.getNodeSelectorMap(this.template.getNodeSelector())).isEmpty()) {
            builder.withNodeSelector(nodeSelector);
        }
        if (this.template.getTerminationGracePeriodSeconds() != null) {
            builder.withTerminationGracePeriodSeconds(this.template.getTerminationGracePeriodSeconds());
        }
        builder.withContainers(containers.values().toArray(new Container[containers.size()]));
        Long runAsUser = this.template.getRunAsUserAsLong();
        Long runAsGroup = this.template.getRunAsGroupAsLong();
        String supplementalGroups = this.template.getSupplementalGroups();
        if (runAsUser != null || runAsGroup != null || supplementalGroups != null) {
            PodSpecFluent.SecurityContextNested securityContext = builder.editOrNewSecurityContext();
            if (runAsUser != null) {
                securityContext.withRunAsUser(runAsUser);
            }
            if (runAsGroup != null) {
                securityContext.withRunAsGroup(runAsGroup);
            }
            if (supplementalGroups != null) {
                securityContext.withSupplementalGroups(this.parseSupplementalGroupList(supplementalGroups));
            }
            securityContext.endSecurityContext();
        }
        if (this.template.isHostNetworkSet()) {
            builder.withHostNetwork(Boolean.valueOf(this.template.isHostNetwork()));
        }
        if ((pod = PodTemplateUtils.combine(this.template.getYamlsPod(), ((PodBuilder)builder.endSpec()).build())).getMetadata().getNamespace() == null) {
            if (this.template.getNamespace() != null) {
                pod.getMetadata().setNamespace(this.template.getNamespace());
            } else if (this.cloud != null && this.cloud.getNamespace() != null) {
                pod.getMetadata().setNamespace(this.cloud.getNamespace());
            }
        }
        String agentContainerName = StringUtils.defaultString((String)this.template.getAgentContainer(), (String)"jnlp");
        Optional<Container> agentOpt = pod.getSpec().getContainers().stream().filter(c -> agentContainerName.equals(c.getName())).findFirst();
        Container agentContainer = agentOpt.orElse(((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(agentContainerName)).withVolumeMounts((VolumeMount[])volumeMounts.values().toArray(VolumeMount[]::new))).build());
        if (agentOpt.isEmpty()) {
            pod.getSpec().getContainers().add(agentContainer);
        }
        String workingDir = agentContainer.getWorkingDir();
        pod.getSpec().getContainers().stream().filter(c -> c.getWorkingDir() == null).forEach(c -> c.setWorkingDir(workingDir));
        Object agentImage = DEFAULT_AGENT_IMAGE;
        if (this.cloud != null && StringUtils.isNotEmpty((String)this.cloud.getJnlpregistry())) {
            agentImage = Util.ensureEndsWith((String)this.cloud.getJnlpregistry(), (String)"/") + (String)agentImage;
        } else if (StringUtils.isNotEmpty((String)DEFAULT_JNLP_DOCKER_REGISTRY_PREFIX)) {
            agentImage = Util.ensureEndsWith((String)DEFAULT_JNLP_DOCKER_REGISTRY_PREFIX, (String)"/") + (String)agentImage;
        }
        if (StringUtils.isBlank((String)agentContainer.getImage())) {
            agentContainer.setImage((String)agentImage);
        }
        HashMap<String, EnvVar> envVars = new HashMap<String, EnvVar>();
        envVars.putAll(this.agentEnvVars(workingDir));
        envVars.putAll(this.defaultEnvVars(this.template.getEnvVars()));
        Optional.ofNullable(agentContainer.getEnv()).ifPresent(agentEnv -> agentEnv.forEach(var -> envVars.put(var.getName(), (EnvVar)var)));
        if (this.template.isAgentInjection()) {
            VolumeMountBuilder agentVolumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("jenkins-agent")).withMountPath(JENKINS_AGENT);
            List oldInitContainers = pod.getSpec().getInitContainers();
            Container jenkinsAgentInitContainer = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("set-up-jenkins-agent")).withImage((String)agentImage)).withCommand(new String[]{"/bin/sh", "-c", "cp $(command -v jenkins-agent) /jenkins-agent/jenkins-agent;cp -R /usr/share/jenkins/. /jenkins-agent"})).withVolumeMounts(new VolumeMount[]{agentVolumeMountBuilder.build()})).build();
            if (oldInitContainers != null) {
                ArrayList<Container> newInitContainers = new ArrayList<Container>(oldInitContainers);
                newInitContainers.add(jenkinsAgentInitContainer);
                pod.getSpec().setInitContainers(newInitContainers);
            } else {
                pod.getSpec().setInitContainers(List.of(jenkinsAgentInitContainer));
            }
            List oldVolumes = pod.getSpec().getVolumes();
            Volume jenkinsAgentSharedVolume = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("jenkins-agent")).withNewEmptyDir().and()).build();
            if (oldVolumes != null) {
                ArrayList<Volume> newVolumes = new ArrayList<Volume>(oldVolumes);
                newVolumes.add(jenkinsAgentSharedVolume);
                pod.getSpec().setVolumes(newVolumes);
            } else {
                pod.getSpec().setVolumes(List.of(jenkinsAgentSharedVolume));
            }
            List existingVolumeMounts = agentContainer.getVolumeMounts();
            if (existingVolumeMounts != null) {
                ArrayList<VolumeMount> newVolumeMounts = new ArrayList<VolumeMount>(existingVolumeMounts);
                newVolumeMounts.add(((VolumeMountBuilder)agentVolumeMountBuilder.withReadOnly()).build());
                agentContainer.setVolumeMounts(newVolumeMounts);
            } else {
                agentContainer.setVolumeMounts(List.of(((VolumeMountBuilder)agentVolumeMountBuilder.withReadOnly()).build()));
            }
            agentContainer.setWorkingDir("/home/jenkins/agent");
            agentContainer.setCommand(List.of("/jenkins-agent/jenkins-agent"));
            agentContainer.setArgs(List.of());
            envVars.put(JENKINS_AGENT_FILE_ENVVAR, ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(JENKINS_AGENT_FILE_ENVVAR)).withValue("/jenkins-agent/agent.jar")).build());
        }
        agentContainer.setEnv(new ArrayList(envVars.values()));
        if (agentContainer.getResources() == null) {
            HashMap<String, Quantity> reqMap = new HashMap<String, Quantity>();
            HashMap<String, Quantity> limMap = new HashMap<String, Quantity>();
            reqMap.put("cpu", new Quantity(DEFAULT_JNLP_CONTAINER_CPU_REQUEST));
            reqMap.put("memory", new Quantity(DEFAULT_JNLP_CONTAINER_MEMORY_REQUEST));
            if (DEFAULT_JNLP_CONTAINER_CPU_LIMIT != null) {
                limMap.put("cpu", new Quantity(DEFAULT_JNLP_CONTAINER_CPU_LIMIT));
            }
            if (DEFAULT_JNLP_CONTAINER_MEMORY_LIMIT != null) {
                limMap.put("memory", new Quantity(DEFAULT_JNLP_CONTAINER_MEMORY_LIMIT));
            }
            ResourceRequirements reqs = ((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withRequests(reqMap)).withLimits(limMap)).build();
            agentContainer.setResources(reqs);
        }
        if (this.cloud != null) {
            pod = PodDecorator.decorateAll(this.cloud, pod);
        }
        Pod finalPod = pod;
        LOGGER.finest(() -> "Pod built: " + Serialization.asYaml((Object)finalPod));
        return pod;
    }

    private String normalizePath(String np) {
        return PodTemplateUtils.substituteEnv(Paths.get(np, new String[0]).normalize().toString().replace("\\", "/"));
    }

    private Map<String, EnvVar> defaultEnvVars(Collection<TemplateEnvVar> globalEnvVars) {
        KubernetesCloud cloud;
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.agent != null && (cloud = this.agent.getKubernetesCloud()).isAddMasterProxyEnvVars()) {
            String httpProxy;
            String noProxy = System.getenv("no_proxy");
            if (!StringUtils.isBlank((String)noProxy)) {
                env.put("no_proxy", noProxy);
            }
            if (!StringUtils.isBlank((String)(httpProxy = System.getenv("http_proxy")))) {
                env.put("http_proxy", httpProxy);
            }
        }
        HashMap<String, EnvVar> envVarsMap = new HashMap<String, EnvVar>();
        env.entrySet().forEach(item -> envVarsMap.put((String)item.getKey(), new EnvVar((String)item.getKey(), (String)item.getValue(), null)));
        if (globalEnvVars != null) {
            globalEnvVars.forEach(item -> envVarsMap.put(item.getKey(), item.buildEnvVar()));
        }
        return envVarsMap;
    }

    private Map<String, EnvVar> agentEnvVars(String workingDir) {
        if (workingDir == null) {
            workingDir = "/home/jenkins/agent";
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.agent != null) {
            SlaveComputer computer = this.agent.getComputer();
            if (computer != null) {
                env.put("JENKINS_SECRET", computer.getJnlpMac());
                env.put("JENKINS_NAME", computer.getName());
                env.put("JENKINS_AGENT_NAME", computer.getName());
            } else {
                LOGGER.log(Level.INFO, "Computer is null for agent: {0}", this.agent.getNodeName());
            }
            env.put("JENKINS_AGENT_WORKDIR", workingDir);
            KubernetesCloud cloud = this.agent.getKubernetesCloud();
            if (!StringUtils.isBlank((String)cloud.getJenkinsTunnel())) {
                env.put("JENKINS_TUNNEL", cloud.getJenkinsTunnel());
            }
            if (!cloud.isDirectConnection()) {
                env.put("JENKINS_URL", cloud.getJenkinsUrlOrDie());
                if (cloud.isWebSocket()) {
                    env.put("JENKINS_WEB_SOCKET", "true");
                }
            } else {
                TcpSlaveAgentListener tcpSlaveAgentListener = Jenkins.get().getTcpSlaveAgentListener();
                String host = tcpSlaveAgentListener.getAdvertisedHost();
                int port = tcpSlaveAgentListener.getAdvertisedPort();
                env.put("JENKINS_DIRECT_CONNECTION", host + ":" + port);
                env.put("JENKINS_PROTOCOLS", "JNLP4-connect");
                env.put("JENKINS_INSTANCE_IDENTITY", tcpSlaveAgentListener.getIdentityPublicKey());
            }
            env.put("REMOTING_OPTS", "-noReconnectAfter " + NO_RECONNECT_AFTER_TIMEOUT);
        }
        HashMap<String, EnvVar> envVarsMap = new HashMap<String, EnvVar>();
        env.entrySet().forEach(item -> envVarsMap.put((String)item.getKey(), new EnvVar((String)item.getKey(), (String)item.getValue(), null)));
        return envVarsMap;
    }

    private Container createContainer(ContainerTemplate containerTemplate, Collection<TemplateEnvVar> globalEnvVars, Collection<VolumeMount> volumeMounts) {
        SlaveComputer computer;
        HashMap<String, EnvVar> envVarsMap = new HashMap<String, EnvVar>();
        String workingDir = PodTemplateUtils.substituteEnv(containerTemplate.getWorkingDir());
        if ("jnlp".equals(containerTemplate.getName())) {
            envVarsMap.putAll(this.agentEnvVars(workingDir));
        }
        envVarsMap.putAll(this.defaultEnvVars(globalEnvVars));
        if (containerTemplate.getEnvVars() != null) {
            containerTemplate.getEnvVars().forEach(item -> envVarsMap.put(item.getKey(), item.buildEnvVar()));
        }
        EnvVar[] envVars = (EnvVar[])envVarsMap.values().stream().toArray(EnvVar[]::new);
        String cmd = containerTemplate.getArgs();
        if (this.agent != null && cmd != null && (computer = this.agent.getComputer()) != null) {
            cmd = cmd.replaceAll(JNLPMAC_REF, computer.getJnlpMac()).replaceAll(NAME_REF, computer.getName());
        }
        List<Object> arguments = PodTemplateUtils.isNullOrEmpty(containerTemplate.getArgs()) ? Collections.emptyList() : PodTemplateUtils.splitCommandLine(cmd);
        ContainerPort[] ports = (ContainerPort[])containerTemplate.getPorts().stream().map(entry -> entry.toPort()).toArray(ContainerPort[]::new);
        List<VolumeMount> containerMounts = this.getContainerVolumeMounts(volumeMounts, workingDir);
        ContainerLivenessProbe clp = containerTemplate.getLivenessProbe();
        Probe livenessProbe = null;
        if (clp != null && PodTemplateUtils.splitCommandLine(clp.getExecArgs()) != null) {
            livenessProbe = ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(new ExecAction(PodTemplateUtils.splitCommandLine(clp.getExecArgs())))).withInitialDelaySeconds(Integer.valueOf(clp.getInitialDelaySeconds()))).withTimeoutSeconds(Integer.valueOf(clp.getTimeoutSeconds()))).withFailureThreshold(Integer.valueOf(clp.getFailureThreshold()))).withPeriodSeconds(Integer.valueOf(clp.getPeriodSeconds()))).withSuccessThreshold(Integer.valueOf(clp.getSuccessThreshold()))).build();
        }
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(PodTemplateUtils.substituteEnv(containerTemplate.getName()))).withImage(PodTemplateUtils.substituteEnv(containerTemplate.getImage()))).withImagePullPolicy(containerTemplate.isAlwaysPullImage() ? "Always" : "IfNotPresent");
        if (containerTemplate.isPrivileged() || containerTemplate.getRunAsUserAsLong() != null || containerTemplate.getRunAsGroupAsLong() != null) {
            containerBuilder = (ContainerBuilder)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)containerBuilder.withNewSecurityContext().withPrivileged(Boolean.valueOf(containerTemplate.isPrivileged()))).withRunAsUser(containerTemplate.getRunAsUserAsLong())).withRunAsGroup(containerTemplate.getRunAsGroupAsLong())).endSecurityContext();
        }
        return ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)containerBuilder.withWorkingDir(workingDir)).withVolumeMounts(containerMounts.toArray(new VolumeMount[containerMounts.size()]))).addToEnv(envVars)).addToPorts(ports)).withCommand(PodTemplateUtils.splitCommandLine(containerTemplate.getCommand()))).withArgs(arguments)).withLivenessProbe(livenessProbe)).withTty(Boolean.valueOf(containerTemplate.isTtyEnabled()))).withNewResources().withRequests(this.getResourcesMap(containerTemplate.getResourceRequestMemory(), containerTemplate.getResourceRequestCpu(), containerTemplate.getResourceRequestEphemeralStorage()))).withLimits(this.getResourcesMap(containerTemplate.getResourceLimitMemory(), containerTemplate.getResourceLimitCpu(), containerTemplate.getResourceLimitEphemeralStorage()))).endResources()).build();
    }

    private VolumeMount getDefaultVolumeMount(@CheckForNull String workingDir) {
        String wd = workingDir;
        if (wd == null) {
            wd = "/home/jenkins/agent";
            LOGGER.log(Level.FINE, "Container workingDir is null, defaulting to {0}", wd);
        }
        return ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(wd)).withName(WORKSPACE_VOLUME_NAME)).withReadOnly(Boolean.valueOf(false))).build();
    }

    private List<VolumeMount> getContainerVolumeMounts(Collection<VolumeMount> volumeMounts, String workingDir) {
        ArrayList<VolumeMount> containerMounts = new ArrayList<VolumeMount>(volumeMounts);
        if (!PodTemplateUtils.isNullOrEmpty(workingDir) && !PodVolume.volumeMountExists(workingDir, volumeMounts)) {
            containerMounts.add(this.getDefaultVolumeMount(workingDir));
        }
        return containerMounts;
    }

    private Map<String, Quantity> getResourcesMap(String memory, String cpu, String ephemeralStorage) {
        HashMap<String, Quantity> builder = new HashMap<String, Quantity>();
        String actualMemory = PodTemplateUtils.substituteEnv(memory);
        String actualCpu = PodTemplateUtils.substituteEnv(cpu);
        String actualEphemeralStorage = PodTemplateUtils.substituteEnv(ephemeralStorage);
        if (StringUtils.isNotBlank((String)actualMemory)) {
            Quantity memoryQuantity = new Quantity(actualMemory);
            builder.put("memory", memoryQuantity);
        }
        if (StringUtils.isNotBlank((String)actualCpu)) {
            Quantity cpuQuantity = new Quantity(actualCpu);
            builder.put("cpu", cpuQuantity);
        }
        if (StringUtils.isNotBlank((String)actualEphemeralStorage)) {
            Quantity ephemeralStorageQuantity = new Quantity(actualEphemeralStorage);
            builder.put("ephemeral-storage", ephemeralStorageQuantity);
        }
        return Collections.unmodifiableMap(builder);
    }

    private Map<String, String> getAnnotationsMap(List<PodAnnotation> annotations) {
        HashMap<String, String> builder = new HashMap<String, String>();
        if (annotations != null) {
            for (PodAnnotation podAnnotation : annotations) {
                builder.put(podAnnotation.getKey(), PodTemplateUtils.substituteEnv(podAnnotation.getValue()));
            }
        }
        builder.put("kubernetes.jenkins.io/last-refresh", String.valueOf(System.currentTimeMillis()));
        return Collections.unmodifiableMap(builder);
    }

    private Map<String, String> getNodeSelectorMap(String selectors) {
        if (PodTemplateUtils.isNullOrEmpty(selectors)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> builder = new HashMap<String, String>();
        for (String selector : selectors.split(",")) {
            String[] parts = selector.split("=");
            if (parts.length == 2 && !parts[0].isEmpty() && !parts[1].isEmpty()) {
                builder.put(parts[0], PodTemplateUtils.substituteEnv(parts[1]));
                continue;
            }
            LOGGER.log(Level.WARNING, "Ignoring selector '" + selector + "'. Selectors must be in the format 'label1=value1,label2=value2'.");
        }
        return Collections.unmodifiableMap(builder);
    }

    private List<Long> parseSupplementalGroupList(String gids) {
        if (PodTemplateUtils.isNullOrEmpty(gids)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> builder = new ArrayList<Long>();
        for (String gid : gids.split(",")) {
            try {
                if (!PodTemplateUtils.isNullOrEmpty(gid)) {
                    builder.add(Long.parseLong(gid));
                    continue;
                }
                LOGGER.log(Level.WARNING, "Ignoring GID '{0}'. Group ID's cannot be empty or null.", gid);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.WARNING, "Ignoring GID '{0}'. Group ID's must be valid longs.", gid);
            }
        }
        return Collections.unmodifiableList(builder);
    }

    static {
        block9: {
            LOGGER = Logger.getLogger(PodTemplateBuilder.class.getName());
            FROM_DIRECTIVE = Pattern.compile("^FROM (.*)$");
            NO_RECONNECT_AFTER_TIMEOUT = SystemProperties.getString((String)(PodTemplateBuilder.class.getName() + ".noReconnectAfter"), (String)"1d");
            DEFAULT_JNLP_DOCKER_REGISTRY_PREFIX = System.getProperty(PodTemplateStepExecution.class.getName() + ".dockerRegistryPrefix");
            try (InputStream dockerfileStream = PodTemplateBuilder.class.getResourceAsStream("Dockerfile");){
                String s = IOUtils.readFirstLine((InputStream)dockerfileStream, (String)StandardCharsets.UTF_8.toString());
                Matcher matcher = FROM_DIRECTIVE.matcher(s);
                if (matcher.matches()) {
                    defaultImageName = matcher.group(1);
                    break block9;
                }
                throw new IllegalStateException("Dockerfile in plugin resources doesn't have the expected content");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        DEFAULT_AGENT_IMAGE = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultImage", defaultImageName);
        DEFAULT_JNLP_CONTAINER_MEMORY_REQUEST = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultContainer.defaultMemoryRequest", "256Mi");
        DEFAULT_JNLP_CONTAINER_CPU_REQUEST = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultContainer.defaultCpuRequest", "100m");
        DEFAULT_JNLP_CONTAINER_MEMORY_LIMIT = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultContainer.defaultMemoryLimit");
        DEFAULT_JNLP_CONTAINER_CPU_LIMIT = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultContainer.defaultCpuLimit");
    }
}

