/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesProvisioningLimits;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

class LimitRegistrationResults {
    private static final Logger LOGGER = Logger.getLogger(LimitRegistrationResults.class.getName());
    private final KubernetesCloud cloud;
    private final List<Result> results = new ArrayList<Result>();

    public LimitRegistrationResults(@NonNull KubernetesCloud cloud) {
        this.cloud = cloud;
    }

    public boolean register(@NonNull PodTemplate podTemplate, int numExecutors) {
        Result result = new Result(KubernetesProvisioningLimits.get().register(this.cloud, podTemplate, numExecutors), podTemplate, numExecutors);
        this.results.add(result);
        return result.success;
    }

    public void unregister() {
        this.results.forEach(result -> result.unregister(this.cloud));
    }

    private static class Result {
        final boolean success;
        final int numExecutors;
        @NonNull
        PodTemplate podTemplate;

        Result(boolean success, @NonNull PodTemplate podTemplate, int numExecutors) {
            this.success = success;
            this.podTemplate = podTemplate;
            this.numExecutors = numExecutors;
        }

        void unregister(KubernetesCloud cloud) {
            if (this.success) {
                LOGGER.log(Level.FINEST, () -> "Registration was successful, unregistering slot for podTemplate " + this.podTemplate.getName() + " from cloud " + cloud.name + " with " + this.numExecutors + " executors");
                KubernetesProvisioningLimits.get().unregister(cloud, this.podTemplate, this.numExecutors);
            } else {
                LOGGER.log(Level.FINEST, () -> "Registration previously failed, no need to unregister slot for podTemplate " + this.podTemplate.getName() + " from cloud " + cloud.name + " with " + this.numExecutors + " executors");
            }
        }
    }
}

