/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;

@Restricted(value={NoExternalUse.class})
@Deprecated
public class KubernetesFactoryAdapter {
    private static final Logger LOGGER = Logger.getLogger(KubernetesFactoryAdapter.class.getName());
    private static final int DEFAULT_CONNECT_TIMEOUT = 5;
    private static final int DEFAULT_READ_TIMEOUT = 15;
    private final String serviceAddress;
    private final String namespace;
    @CheckForNull
    private final String caCertData;
    @CheckForNull
    private final KubernetesAuth auth;
    private final boolean skipTlsVerify;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxRequestsPerHost;
    private final boolean useJenkinsProxy;

    public KubernetesFactoryAdapter(String serviceAddress, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify) throws KubernetesAuthException {
        this(serviceAddress, null, caCertData, credentials, skipTlsVerify);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify) throws KubernetesAuthException {
        this(serviceAddress, namespace, caCertData, credentials, skipTlsVerify, 5, 15);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify, int connectTimeout, int readTimeout) throws KubernetesAuthException {
        this(serviceAddress, namespace, caCertData, credentials, skipTlsVerify, connectTimeout, readTimeout, 32, false);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentialsId, boolean skipTlsVerify, int connectTimeout, int readTimeout, int maxRequestsPerHost, boolean useJenkinsProxy) throws KubernetesAuthException {
        this(serviceAddress, namespace, caCertData, credentialsId, (ItemGroup)Jenkins.get(), skipTlsVerify, connectTimeout, readTimeout, maxRequestsPerHost, useJenkinsProxy);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentialsId, @NonNull ItemGroup context, boolean skipTlsVerify, int connectTimeout, int readTimeout, int maxRequestsPerHost, boolean useJenkinsProxy) throws KubernetesAuthException {
        this.serviceAddress = serviceAddress;
        this.namespace = namespace;
        this.caCertData = KubernetesFactoryAdapter.decodeBase64IfNeeded(caCertData);
        this.auth = (KubernetesAuth)AuthenticationTokens.convert(KubernetesAuth.class, (Credentials)KubernetesFactoryAdapter.resolveCredentials(credentialsId, context));
        this.skipTlsVerify = skipTlsVerify;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxRequestsPerHost = maxRequestsPerHost;
        this.useJenkinsProxy = useJenkinsProxy;
    }

    private static String decodeBase64IfNeeded(String caCertData) {
        if (Util.fixEmpty((String)caCertData) != null) {
            try {
                byte[] decode = Base64.getDecoder().decode(caCertData.getBytes(StandardCharsets.UTF_8));
                return new String(decode, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                return caCertData;
            }
        }
        return caCertData;
    }

    public KubernetesClient createClient() throws KubernetesAuthException {
        ConfigBuilder builder;
        if (StringUtils.isBlank((String)this.serviceAddress)) {
            LOGGER.log(Level.FINE, "Autoconfiguring Kubernetes client");
            builder = new ConfigBuilder(Config.autoConfigure(null));
        } else {
            builder = this.auth == null ? new ConfigBuilder(Config.autoConfigure(null)) : new ConfigBuilder(Config.empty());
            builder = (ConfigBuilder)builder.withMasterUrl(this.serviceAddress);
        }
        if (this.auth != null) {
            builder = this.auth.decorate(builder, new KubernetesAuthConfig(builder.getMasterUrl(), this.caCertData, this.skipTlsVerify));
            builder = (ConfigBuilder)builder.withAutoConfigure(false);
        }
        if (this.skipTlsVerify) {
            builder.withTrustCerts(true);
        }
        if (this.caCertData != null) {
            builder.withCaCertData(Base64.getEncoder().encodeToString(this.caCertData.getBytes(StandardCharsets.UTF_8)));
        }
        builder = (ConfigBuilder)((ConfigBuilder)builder.withRequestTimeout(this.readTimeout * 1000)).withConnectionTimeout(this.connectTimeout * 1000);
        builder.withMaxConcurrentRequestsPerHost(Integer.valueOf(this.maxRequestsPerHost));
        builder.withMaxConcurrentRequests(this.maxRequestsPerHost);
        if (!StringUtils.isBlank((String)this.namespace)) {
            builder.withNamespace(this.namespace);
        } else if (StringUtils.isBlank((String)builder.getNamespace())) {
            builder.withNamespace("default");
        }
        LOGGER.log(Level.FINE, "Creating Kubernetes client: {0}", this.toString());
        LOGGER.log(Level.FINE, "Proxy Settings for Cloud: " + this.useJenkinsProxy);
        if (this.useJenkinsProxy) {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            LOGGER.log(Level.FINE, "Jenkins Instance: " + String.valueOf(jenkins));
            if (jenkins != null) {
                ProxyConfiguration p = jenkins.proxy;
                LOGGER.log(Level.FINE, "Proxy Instance: " + String.valueOf(p));
                if (p != null) {
                    builder.withHttpsProxy("http://" + p.name + ":" + p.port);
                    builder.withHttpProxy("http://" + p.name + ":" + p.port);
                    String proxyUserName = p.getUserName();
                    if (proxyUserName != null) {
                        String password = this.getProxyPasswordDecrypted(p);
                        builder.withProxyUsername(proxyUserName);
                        builder.withProxyPassword(password);
                    }
                    builder.withNoProxy(this.getNoProxyHosts(p));
                }
            }
        }
        return new KubernetesClientBuilder().withConfig(builder.build()).build();
    }

    private String[] getNoProxyHosts(@NonNull ProxyConfiguration proxy) {
        HashSet<String> noProxyHosts = new HashSet<String>();
        for (String noProxyHost : proxy.getNoProxyHost().split("\n")) {
            noProxyHosts.add(noProxyHost.replace("*", ""));
        }
        return noProxyHosts.toArray(new String[0]);
    }

    private String getProxyPasswordDecrypted(ProxyConfiguration p) {
        String passwordEncrypted = p.getPassword();
        String password = null;
        if (passwordEncrypted != null) {
            Secret secret = Secret.fromString((String)passwordEncrypted);
            password = Secret.toString((Secret)secret);
        }
        return password;
    }

    public String toString() {
        return "KubernetesFactoryAdapter [serviceAddress=" + this.serviceAddress + ", namespace=" + this.namespace + ", caCertData=" + this.caCertData + ", credentials=" + String.valueOf(this.auth) + ", skipTlsVerify=" + this.skipTlsVerify + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + "]";
    }

    @CheckForNull
    private static StandardCredentials resolveCredentials(@CheckForNull String credentialsId, @NonNull ItemGroup owner) throws KubernetesAuthException {
        if (credentialsId == null) {
            return null;
        }
        StandardCredentials c = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardCredentials.class, (ItemGroup)owner, (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(KubernetesAuth.class), CredentialsMatchers.withId((String)credentialsId)}));
        if (c == null) {
            throw new KubernetesAuthException("No credentials found with id " + credentialsId);
        }
        return c;
    }
}

