/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Main;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GarbageCollection
extends AbstractDescribableImpl<GarbageCollection> {
    public static final String ANNOTATION_LAST_REFRESH = "kubernetes.jenkins.io/last-refresh";
    private static final Logger LOGGER = Logger.getLogger(GarbageCollection.class.getName());
    public static final int MINIMUM_GC_TIMEOUT = 120;
    private String namespaces;
    private transient Set<String> namespaceSet;
    private int timeout;
    private static Long RECURRENCE_PERIOD = SystemProperties.getLong((String)(GarbageCollection.class.getName() + ".recurrencePeriod"), (Long)(Main.isUnitTest ? 5L : TimeUnit.MINUTES.toSeconds(1L)));

    @DataBoundConstructor
    public GarbageCollection() {
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    @DataBoundSetter
    public void setNamespaces(String namespaces) {
        this.namespaces = Util.fixEmptyAndTrim((String)namespaces);
        this.namespaceSet = this.namespaces == null ? Set.of() : Set.of(this.namespaces.split("\n"));
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected Object readResolve() {
        if (this.namespaces != null) {
            this.setNamespaces(this.namespaces);
        }
        return this;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = Main.isUnitTest ? timeout : Math.max(timeout, 120);
    }

    public Duration getDurationTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    @NonNull
    public Set<String> getNamespaceSet() {
        return this.namespaceSet == null ? Set.of() : this.namespaceSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GarbageCollection that = (GarbageCollection)((Object)o);
        return this.timeout == that.timeout && Objects.equals(this.namespaces, that.namespaces);
    }

    public int hashCode() {
        return Objects.hash(this.namespaces, this.timeout);
    }

    public String toString() {
        return "GarbageCollection{namespaces='" + this.namespaces + "', timeout=" + this.timeout + "}";
    }

    @Extension
    public static final class PeriodicGarbageCollection
    extends AsyncPeriodicWork {
        public PeriodicGarbageCollection() {
            super("Garbage collection of orphaned Kubernetes pods");
        }

        protected void execute(TaskListener listener) throws IOException, InterruptedException {
            PeriodicGarbageCollection.annotateLiveAgents(listener);
            PeriodicGarbageCollection.garbageCollect();
        }

        private static void annotateLiveAgents(TaskListener listener) {
            Arrays.stream(Jenkins.get().getComputers()).filter(KubernetesComputer.class::isInstance).map(KubernetesComputer.class::cast).forEach(kc -> kc.annotateTtl(listener));
        }

        private static void garbageCollect() {
            for (KubernetesCloud cloud : Jenkins.get().clouds.getAll(KubernetesCloud.class)) {
                Optional.ofNullable(cloud.getGarbageCollection()).ifPresent(gc -> {
                    try {
                        KubernetesClient client = cloud.connect();
                        HashSet<String> namespaces = new HashSet<String>();
                        namespaces.add(client.getNamespace());
                        namespaces.addAll(gc.getNamespaceSet());
                        for (String ns : namespaces) {
                            ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(ns)).withLabel("kubernetes.jenkins.io/controller", PodTemplateUtils.sanitizeLabel(cloud.getJenkinsUrlOrNull()))).list()).getItems().stream().filter(pod -> {
                                String lastRefresh = (String)pod.getMetadata().getAnnotations().get(GarbageCollection.ANNOTATION_LAST_REFRESH);
                                if (lastRefresh != null) {
                                    try {
                                        long refreshTime = Long.parseLong(lastRefresh);
                                        Instant now = Instant.now();
                                        LOGGER.log(Level.FINE, () -> PeriodicGarbageCollection.getQualifiedName(pod) + " refresh diff = " + (now.toEpochMilli() - refreshTime) + ", timeout is " + gc.getDurationTimeout().toMillis());
                                        return Duration.between(Instant.ofEpochMilli(refreshTime), now).compareTo(gc.getDurationTimeout()) > 0;
                                    }
                                    catch (NumberFormatException e) {
                                        LOGGER.log(Level.WARNING, e, () -> "Unable to parse last refresh for pod " + PeriodicGarbageCollection.getQualifiedName(pod) + ", ignoring");
                                        return false;
                                    }
                                }
                                LOGGER.log(Level.FINE, () -> "Ignoring legacy pod " + PeriodicGarbageCollection.getQualifiedName(pod));
                                return false;
                            }).forEach(pod -> {
                                LOGGER.log(Level.INFO, () -> "Deleting orphan pod " + PeriodicGarbageCollection.getQualifiedName(pod));
                                client.resource((HasMetadata)pod).delete();
                            });
                        }
                    }
                    catch (KubernetesClientException e) {
                        LOGGER.log(Level.WARNING, "Unexpected error while calling Kubernetes API", e);
                    }
                    catch (KubernetesAuthException e) {
                        LOGGER.log(Level.WARNING, "Error authenticating to Kubernetes", e);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Error while getting Kubernetes client", e);
                    }
                });
            }
        }

        private static String getQualifiedName(@NonNull Pod pod) {
            ObjectMeta metadata = pod.getMetadata();
            return metadata.getNamespace() + "/" + metadata.getName();
        }

        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(RECURRENCE_PERIOD);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GarbageCollection> {
        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)120, (int)Integer.MAX_VALUE);
        }
    }
}

