/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.PodContainerSource;

@Extension
public class EphemeralPodContainerSource
extends PodContainerSource {
    public Optional<String> getContainerWorkingDir(@NonNull Pod pod, @NonNull String containerName) {
        return EphemeralPodContainerSource.getEphemeralContainerWorkingDir(pod, containerName);
    }

    public Optional<ContainerStatus> getContainerStatus(@NonNull Pod pod, @NonNull String containerName) {
        return EphemeralPodContainerSource.getEphemeralContainerStatus(pod, containerName);
    }

    public static Optional<String> getEphemeralContainerWorkingDir(@NonNull Pod pod, @NonNull String containerName) {
        List ephemeralContainers = pod.getSpec().getEphemeralContainers();
        if (ephemeralContainers == null) {
            return Optional.empty();
        }
        return ephemeralContainers.stream().filter(c -> StringUtils.equals((CharSequence)c.getName(), (CharSequence)containerName)).findAny().map(EphemeralContainer::getWorkingDir);
    }

    public static Optional<ContainerStatus> getEphemeralContainerStatus(@NonNull Pod pod, @NonNull String containerName) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return Optional.empty();
        }
        return podStatus.getEphemeralContainerStatuses().stream().filter(cs -> StringUtils.equals((CharSequence)cs.getName(), (CharSequence)containerName)).findFirst();
    }
}

