/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.datapipe.jenkins.vault.credentials.VaultTokenCredential;
import hudson.util.Secret;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"hashicorp-vault-plugin"})
public class VaultTokenCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "vaultToken".equals(type);
    }

    public VaultTokenCredential convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "vaultToken definition contains no data");
        String tokenBase64 = SecretUtils.getNonNullSecretData(secret, "token", "vaultToken credential is missing the token");
        String token = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(tokenBase64), "vaultToken credential has an invalid token (must be base64 encoded UTF-8)");
        return new VaultTokenCredential(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), Secret.fromString((String)token));
    }
}

