/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import hudson.util.Secret;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"plain-credentials"})
public class StringCredentialConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "secretText".equals(type);
    }

    public StringCredentialsImpl convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "secretText kubernetes definition contains no data");
        String textBase64 = SecretUtils.getNonNullSecretData(secret, "text", "secretText credential is missing the text");
        String secretText = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(textBase64), "secretText credential has an invalid text (must be base64 encoded UTF-8)");
        return new StringCredentialsImpl(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), Secret.fromString((String)secretText));
    }
}

