/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.applet.Applet;
import java.lang.reflect.Method;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeJavaObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlObject;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.ActiveXObjectImpl;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.ValidityState;

@JsxClass(domClass=HtmlObject.class)
public class HTMLObjectElement
extends HTMLElement
implements Wrapper {
    private Scriptable wrappedActiveX_;

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (domNode.getPage().getWebClient().getOptions().isAppletEnabled()) {
            try {
                this.createAppletMethodAndProperties();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAppletMethodAndProperties() throws Exception {
        HtmlObject appletNode = (HtmlObject)this.getDomNodeOrDie();
        final Applet applet = appletNode.getApplet();
        if (applet == null) {
            return;
        }
        for (final Method method : applet.getClass().getMethods()) {
            BaseFunction f = new BaseFunction(){

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    Object[] realArgs = new Object[method.getParameterTypes().length];
                    for (int i = 0; i < realArgs.length; ++i) {
                        Object arg = i > args.length ? null : Context.jsToJava((Object)args[i], method.getParameterTypes()[i]);
                        realArgs[i] = arg;
                    }
                    try {
                        return method.invoke((Object)applet, realArgs);
                    }
                    catch (Exception e) {
                        throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
                    }
                }
            };
            ScriptableObject.defineProperty((Scriptable)this, (String)method.getName(), (Object)f, (int)1);
        }
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter
    public String getBorder() {
        return this.getDomNodeOrDie().getAttributeDirect("border");
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getClassid() {
        return this.getDomNodeOrDie().getAttributeDirect("classid");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClassid(String classid) {
        this.getDomNodeOrDie().setAttribute("classid", classid);
        if (classid.indexOf(58) != -1 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_OBJECT_CLASSID)) {
            String xClassString;
            WebClient webClient = this.getWindow().getWebWindow().getWebClient();
            Map<String, String> map = webClient.getActiveXObjectMap();
            if (map != null && (xClassString = map.get(classid)) != null) {
                try {
                    Class<?> xClass = Class.forName(xClassString);
                    Object object = xClass.newInstance();
                    boolean contextCreated = false;
                    if (Context.getCurrentContext() == null) {
                        new HtmlUnitContextFactory(webClient).enterContext();
                        contextCreated = true;
                    }
                    this.wrappedActiveX_ = Context.toObject(object, (Scriptable)this.getParentScope());
                    if (contextCreated) {
                        Context.exit();
                    }
                }
                catch (Exception e) {
                    throw JavaScriptEngine.reportRuntimeError("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + ".");
                }
                return;
            }
            if (webClient.getOptions().isActiveXNative() && System.getProperty("os.name").contains("Windows")) {
                try {
                    this.wrappedActiveX_ = new ActiveXObjectImpl(classid);
                    this.wrappedActiveX_.setParentScope(this.getParentScope());
                }
                catch (Exception e) {
                    throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
                }
            }
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.wrappedActiveX_ instanceof NativeJavaObject) {
            NativeJavaObject obj = (NativeJavaObject)this.wrappedActiveX_;
            Object result = obj.get(name, start);
            if (Scriptable.NOT_FOUND != result) {
                return result;
            }
            return super.get(name, start);
        }
        if (this.wrappedActiveX_ != null) {
            return this.wrappedActiveX_.get(name, start);
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.wrappedActiveX_ instanceof NativeJavaObject) {
            if (this.wrappedActiveX_.has(name, start)) {
                this.wrappedActiveX_.put(name, start, value);
            } else {
                super.put(name, start, value);
            }
            return;
        }
        if (this.wrappedActiveX_ != null) {
            this.wrappedActiveX_.put(name, start, value);
            return;
        }
        super.put(name, start, value);
    }

    public Object unwrap() {
        if (this.wrappedActiveX_ instanceof Wrapper) {
            return ((Wrapper)this.wrappedActiveX_).unwrap();
        }
        return this.wrappedActiveX_;
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", Boolean.TRUE);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.setWidthOrHeight("width", width, true);
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        return this.getWidthOrHeight("height", Boolean.TRUE);
    }

    @JsxSetter(propertyName="height")
    public void setHeight_js(String height) {
        this.setWidthOrHeight("height", height, true);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxGetter
    public boolean getWillValidate() {
        return ((HtmlObject)this.getDomNodeOrDie()).willValidate();
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        ((HtmlObject)this.getDomNodeOrDie()).setCustomValidity(message);
    }
}

