/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxConstructorAlias;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxStaticFunction;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.URLSearchParams;
import org.htmlunit.javascript.host.file.File;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.UrlUtils;

@JsxClass
public class URL
extends HtmlUnitScriptable {
    private java.net.URL url_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    @JsxConstructorAlias(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}, alias="webkitURL")
    public void jsConstructor(String url, Object base) {
        String baseStr = null;
        if (!JavaScriptEngine.isUndefined(base)) {
            baseStr = JavaScriptEngine.toString(base);
        }
        try {
            if (StringUtils.isBlank((CharSequence)baseStr)) {
                this.url_ = UrlUtils.toUrlUnsafe(url);
            } else {
                java.net.URL baseUrl = UrlUtils.toUrlUnsafe(baseStr);
                this.url_ = new java.net.URL(baseUrl, url);
            }
            this.url_ = UrlUtils.removeRedundantPort(this.url_);
        }
        catch (MalformedURLException e) {
            throw JavaScriptEngine.typeError(e.toString());
        }
    }

    @JsxStaticFunction
    public static String createObjectURL(Object fileOrBlob) {
        if (fileOrBlob instanceof File) {
            File file = (File)fileOrBlob;
            return file.getFile().toURI().normalize().toString();
        }
        return null;
    }

    @JsxStaticFunction
    public static void revokeObjectURL(Object objectURL) {
    }

    @JsxGetter
    public String getHash() {
        if (this.url_ == null) {
            return null;
        }
        String ref = this.url_.getRef();
        return ref == null ? "" : "#" + ref;
    }

    @JsxSetter
    public void setHash(String fragment) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewRef(this.url_, StringUtils.isEmpty((CharSequence)fragment) ? null : fragment);
    }

    @JsxGetter
    public String getHost() {
        if (this.url_ == null) {
            return null;
        }
        int port = this.url_.getPort();
        return this.url_.getHost() + (port > 0 ? ":" + port : "");
    }

    @JsxSetter
    public void setHost(String host) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        String newHost = StringUtils.substringBefore((String)host, (int)58);
        if (StringUtils.isEmpty((CharSequence)newHost)) {
            return;
        }
        try {
            int ip = Integer.parseInt(newHost);
            StringBuilder ipString = new StringBuilder();
            ipString.insert(0, ip % 256);
            ipString.insert(0, '.');
            ipString.insert(0, (ip /= 256) % 256);
            ipString.insert(0, '.');
            ipString.insert(0, (ip /= 256) % 256);
            ipString.insert(0, '.');
            ipString.insert(0, (ip /= 256) % 256);
            newHost = ipString.toString();
        }
        catch (Exception ip) {
            // empty catch block
        }
        this.url_ = UrlUtils.getUrlWithNewHost(this.url_, newHost);
        String newPort = StringUtils.substringAfter((String)host, (int)58);
        if (StringUtils.isNotBlank((CharSequence)newHost)) {
            try {
                this.url_ = UrlUtils.getUrlWithNewHostAndPort(this.url_, newHost, Integer.parseInt(newPort));
            }
            catch (Exception exception) {}
        } else {
            this.url_ = UrlUtils.getUrlWithNewHost(this.url_, newHost);
        }
        this.url_ = UrlUtils.removeRedundantPort(this.url_);
    }

    @JsxGetter
    public String getHostname() {
        if (this.url_ == null) {
            return null;
        }
        return UrlUtils.encodeAnchor(this.url_.getHost());
    }

    @JsxSetter
    public void setHostname(String hostname) throws MalformedURLException {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_HOSTNAME_IGNORE_BLANK)) {
            if (!StringUtils.isBlank((CharSequence)hostname)) {
                this.url_ = UrlUtils.getUrlWithNewHost(this.url_, hostname);
            }
        } else if (!StringUtils.isEmpty((CharSequence)hostname)) {
            this.url_ = UrlUtils.getUrlWithNewHost(this.url_, hostname);
        }
    }

    @JsxGetter
    public String getHref() {
        if (this.url_ == null) {
            return null;
        }
        return this.jsToString();
    }

    @JsxSetter
    public void setHref(String href) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.toUrlUnsafe(href);
        this.url_ = UrlUtils.removeRedundantPort(this.url_);
    }

    @JsxGetter
    public Object getOrigin() {
        if (this.url_ == null) {
            return null;
        }
        return this.url_.getProtocol() + "://" + this.url_.getHost();
    }

    @JsxGetter
    public URLSearchParams getSearchParams() {
        if (this.url_ == null) {
            return null;
        }
        URLSearchParams searchParams = new URLSearchParams(this);
        searchParams.setParentScope(this.getParentScope());
        searchParams.setPrototype(this.getPrototype(searchParams.getClass()));
        return searchParams;
    }

    @JsxGetter
    public String getPassword() {
        if (this.url_ == null) {
            return null;
        }
        String userInfo = this.url_.getUserInfo();
        int idx = userInfo == null ? -1 : userInfo.indexOf(58);
        return idx == -1 ? "" : userInfo.substring(idx + 1);
    }

    @JsxSetter
    public void setPassword(String password) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewUserPassword(this.url_, password.isEmpty() ? null : password);
    }

    @JsxGetter
    public String getPathname() {
        if (this.url_ == null) {
            return null;
        }
        String path = this.url_.getPath();
        return path.isEmpty() ? "/" : path;
    }

    @JsxSetter
    public void setPathname(String path) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewPath(this.url_, path.startsWith("/") ? path : "/" + path);
    }

    @JsxGetter
    public String getPort() {
        if (this.url_ == null) {
            return null;
        }
        int port = this.url_.getPort();
        return port == -1 ? "" : Integer.toString(port);
    }

    @JsxSetter
    public void setPort(String port) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        int portInt = port.isEmpty() ? -1 : Integer.parseInt(port);
        this.url_ = UrlUtils.getUrlWithNewPort(this.url_, portInt);
        this.url_ = UrlUtils.removeRedundantPort(this.url_);
    }

    @JsxGetter
    public String getProtocol() {
        if (this.url_ == null) {
            return null;
        }
        String protocol = this.url_.getProtocol();
        return protocol.isEmpty() ? "" : protocol + ":";
    }

    @JsxSetter
    public void setProtocol(String protocol) throws MalformedURLException {
        if (this.url_ == null || protocol.isEmpty()) {
            return;
        }
        String bareProtocol = StringUtils.substringBefore((String)protocol, (String)":");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_IGNORE_SPECIAL)) {
            if (!UrlUtils.isValidScheme(bareProtocol)) {
                return;
            }
            try {
                this.url_ = UrlUtils.getUrlWithNewProtocol(this.url_, bareProtocol);
                this.url_ = UrlUtils.removeRedundantPort(this.url_);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return;
        }
        if (!UrlUtils.isValidScheme(bareProtocol = bareProtocol.trim())) {
            return;
        }
        if (!UrlUtils.isSpecialScheme(bareProtocol)) {
            return;
        }
        try {
            this.url_ = UrlUtils.getUrlWithNewProtocol(this.url_, bareProtocol);
            this.url_ = UrlUtils.removeRedundantPort(this.url_);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter
    public String getSearch() {
        if (this.url_ == null) {
            return null;
        }
        String search = this.url_.getQuery();
        return search == null ? "" : "?" + search;
    }

    @JsxSetter
    public void setSearch(String search) throws MalformedURLException {
        String query;
        if (this.url_ == null) {
            return;
        }
        if (search == null || "?".equals(search) || "".equals(search)) {
            query = null;
        } else {
            query = search.charAt(0) == '?' ? search.substring(1) : search;
            query = UrlUtils.encodeQuery(query);
        }
        this.url_ = UrlUtils.getUrlWithNewQuery(this.url_, query);
    }

    public void setSearch(List<NameValuePair> nameValuePairs) throws MalformedURLException {
        StringBuilder newSearch = new StringBuilder();
        for (NameValuePair nameValuePair : nameValuePairs) {
            if (newSearch.length() > 0) {
                newSearch.append('&');
            }
            newSearch.append(UrlUtils.encodeQueryPart(nameValuePair.getName())).append('=').append(UrlUtils.encodeQueryPart(nameValuePair.getValue()));
        }
        this.url_ = UrlUtils.getUrlWithNewQuery(this.url_, newSearch.toString());
    }

    @JsxGetter
    public String getUsername() {
        if (this.url_ == null) {
            return null;
        }
        String userInfo = this.url_.getUserInfo();
        if (userInfo == null) {
            return "";
        }
        return StringUtils.substringBefore((String)userInfo, (int)58);
    }

    @JsxSetter
    public void setUsername(String username) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewUserName(this.url_, username.isEmpty() ? null : username);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.url_ == null) {
            return super.getDefaultValue(hint);
        }
        if (StringUtils.isEmpty((CharSequence)this.url_.getPath())) {
            return this.url_.toExternalForm() + "/";
        }
        return this.url_.toExternalForm();
    }

    @JsxFunction
    public String toJSON() {
        return this.jsToString();
    }

    @JsxFunction(functionName="toString")
    public String jsToString() {
        if (StringUtils.isEmpty((CharSequence)this.url_.getPath())) {
            try {
                return UrlUtils.getUrlWithNewPath(this.url_, "/").toExternalForm();
            }
            catch (MalformedURLException e) {
                return this.url_.toExternalForm();
            }
        }
        return this.url_.toExternalForm();
    }
}

