/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.activex.javascript.msxml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.activex.javascript.msxml.MSXMLJavaScriptEnvironment;
import org.htmlunit.activex.javascript.msxml.XMLDOMElement;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;

public class MSXMLScriptable
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(MSXMLScriptable.class);
    private MSXMLJavaScriptEnvironment environment_;

    @Override
    public void setParentScope(Scriptable m) {
        super.setParentScope(m);
        if (m instanceof MSXMLScriptable) {
            this.setEnvironment(((MSXMLScriptable)m).getEnvironment());
        }
    }

    @Override
    public HtmlUnitScriptable makeScriptableFor(DomNode domNode) {
        MSXMLScriptable scriptable;
        Class<? extends MSXMLScriptable> javaScriptClass = null;
        for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
            javaScriptClass = this.getEnvironment().getJavaScriptClass(c);
        }
        if (javaScriptClass == null) {
            scriptable = new XMLDOMElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No MSXML JavaScript class found for element <" + domNode.getNodeName() + ">. Using XMLDOMElement"));
            }
        } else {
            try {
                scriptable = (MSXMLScriptable)javaScriptClass.newInstance();
            }
            catch (Exception e) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        scriptable.setEnvironment(this.getEnvironment());
        return scriptable;
    }

    @Override
    public Scriptable getPrototype(Class<? extends HtmlUnitScriptable> javaScriptClass) {
        Scriptable prototype = this.getEnvironment().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != HtmlUnitScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    public MSXMLJavaScriptEnvironment getEnvironment() {
        return this.environment_;
    }

    public void setEnvironment(MSXMLJavaScriptEnvironment environment) {
        this.environment_ = environment;
    }
}

