/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.engine;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.engine.BindingsObject;
import org.htmlunit.corejs.javascript.engine.Builtins;
import org.htmlunit.corejs.javascript.engine.RhinoCompiledScript;
import org.htmlunit.corejs.javascript.engine.RhinoInvocationHandler;
import org.htmlunit.corejs.javascript.engine.RhinoScriptEngineFactory;

public class RhinoScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    public static final String OPTIMIZATION_LEVEL = "org.htmlunit.corejs.javascript.optimization_level";
    static final int DEFAULT_LANGUAGE_VERSION = 200;
    private static final int DEFAULT_OPT = 9;
    private static final boolean DEFAULT_DEBUG = true;
    private static final String DEFAULT_FILENAME = "eval";
    private static final CtxFactory ctxFactory = new CtxFactory();
    private final RhinoScriptEngineFactory factory;
    private final Builtins builtins;
    private ScriptableObject topLevelScope = null;

    RhinoScriptEngine(RhinoScriptEngineFactory factory) {
        this.factory = factory;
        this.builtins = new Builtins();
    }

    private Scriptable initScope(Context cx, ScriptContext sc) throws ScriptException {
        this.configureContext(cx);
        if (this.topLevelScope == null) {
            this.topLevelScope = cx.initStandardObjects();
            this.topLevelScope.associateValue(Builtins.BUILTIN_KEY, this.builtins);
            this.builtins.register(cx, this.topLevelScope, sc);
        }
        BindingsObject engineScope = new BindingsObject(sc.getBindings(100));
        engineScope.setParentScope(null);
        engineScope.setPrototype(this.topLevelScope);
        if (sc.getBindings(200) != null) {
            BindingsObject globalScope = new BindingsObject(sc.getBindings(200));
            globalScope.setParentScope(null);
            globalScope.setPrototype(this.topLevelScope);
            engineScope.setPrototype(globalScope);
        }
        return engineScope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, context);
            Object ret = cx.evaluateString(scope, script, this.getFilename(), 0, null);
            Object object = Context.jsToJava(ret, Object.class);
            return object;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, context);
            Object ret = cx.evaluateReader(scope, reader, this.getFilename(), 0, null);
            Object object = Context.jsToJava(ret, Object.class);
            return object;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompiledScript compile(String script) throws ScriptException {
        try (Context cx = ctxFactory.enterContext();){
            this.configureContext(cx);
            Script s = cx.compileString(script, this.getFilename(), 1, null);
            RhinoCompiledScript rhinoCompiledScript = new RhinoCompiledScript(this, s);
            return rhinoCompiledScript;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try (Context cx = ctxFactory.enterContext();){
            this.configureContext(cx);
            Script s = cx.compileReader(script, this.getFilename(), 1, null);
            RhinoCompiledScript rhinoCompiledScript = new RhinoCompiledScript(this, s);
            return rhinoCompiledScript;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object eval(Script script, ScriptContext sc) throws ScriptException {
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, sc);
            Object ret = script.exec(cx, scope);
            Object object = Context.jsToJava(ret, Object.class);
            return object;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(null, name, args);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethodRaw(thiz, name, Object.class, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object invokeMethodRaw(Object thiz, String name, Class<?> returnType, Object ... args) throws ScriptException, NoSuchMethodException {
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, this.context);
            Scriptable localThis = thiz == null ? scope : Context.toObject(thiz, scope);
            Object f = ScriptableObject.getProperty(localThis, name);
            if (f == Scriptable.NOT_FOUND) {
                throw new NoSuchMethodException(name);
            }
            if (!(f instanceof Callable)) {
                throw new ScriptException("\"" + name + "\" is not a function");
            }
            Callable func = (Callable)f;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.javaToJS(args[i], scope);
                }
            }
            Object ret = func.call(cx, scope, localThis, args);
            if (returnType == Void.TYPE) {
                Object var12_15 = null;
                return var12_15;
            }
            Object object = Context.jsToJava(ret, returnType);
            return object;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInterface(Class<T> clasz) {
        if (clasz == null) throw new IllegalArgumentException("Not an interface");
        if (!clasz.isInterface()) {
            throw new IllegalArgumentException("Not an interface");
        }
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, this.context);
            if (!RhinoScriptEngine.methodsMissing(scope, clasz)) return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clasz}, (InvocationHandler)new RhinoInvocationHandler(this, null));
            T t = null;
            return t;
        }
        catch (ScriptException se) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (clasz == null) throw new IllegalArgumentException("Not an interface");
        if (!clasz.isInterface()) {
            throw new IllegalArgumentException("Not an interface");
        }
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, this.context);
            Scriptable thisObj = Context.toObject(thiz, scope);
            if (!RhinoScriptEngine.methodsMissing(thisObj, clasz)) return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clasz}, (InvocationHandler)new RhinoInvocationHandler(this, thiz));
            T t = null;
            return t;
        }
        catch (ScriptException se) {
            return null;
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    private void configureContext(Context cx) throws ScriptException {
        Object ol;
        Object lv = this.get("javax.script.language_version");
        if (lv != null) {
            cx.setLanguageVersion(RhinoScriptEngine.parseInteger(lv));
        }
        if ((ol = this.get(OPTIMIZATION_LEVEL)) != null) {
            cx.setOptimizationLevel(RhinoScriptEngine.parseInteger(ol));
        }
    }

    private static int parseInteger(Object v) throws ScriptException {
        if (v instanceof String) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (NumberFormatException nfe) {
                throw new ScriptException("Invalid number " + v);
            }
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        throw new ScriptException("Value must be a string or number");
    }

    private String getFilename() {
        Object fn = this.get("javax.script.filename");
        if (fn instanceof String) {
            return (String)fn;
        }
        return DEFAULT_FILENAME;
    }

    private static boolean methodsMissing(Scriptable scope, Class<?> clasz) {
        for (Method m : clasz.getMethods()) {
            Object methodObj;
            if (m.getDeclaringClass() == Object.class || (methodObj = ScriptableObject.getProperty(scope, m.getName())) instanceof Callable) continue;
            return true;
        }
        return false;
    }

    private static final class CtxFactory
    extends ContextFactory {
        private CtxFactory() {
        }

        @Override
        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 18) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }

        @Override
        protected void onContextCreated(Context cx) {
            cx.setLanguageVersion(200);
            cx.setOptimizationLevel(9);
            cx.setGeneratingDebug(true);
        }
    }
}

