/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.junit.storage;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.HistoryTestResultSummary;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestDurationResultSummary;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TrendTestResultSummary;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface TestResultImpl {
    public int getFailCount();

    public int getSkipCount();

    public int getPassCount();

    public int getTotalCount();

    public List<CaseResult> getFailedTests();

    public List<CaseResult> getFailedTestsByPackage(String var1);

    public List<CaseResult> getSkippedTests();

    public List<CaseResult> getSkippedTestsByPackage(String var1);

    public List<CaseResult> getPassedTests();

    public List<CaseResult> getPassedTestsByPackage(String var1);

    public PackageResult getPackageResult(String var1);

    public List<PackageResult> getAllPackageResults();

    public List<TrendTestResultSummary> getTrendTestResultSummary();

    public List<TestDurationResultSummary> getTestDurationResultSummary();

    public List<HistoryTestResultSummary> getHistorySummary(int var1);

    public int getCountOfBuildsWithTestResults();

    public Run<?, ?> getFailedSinceRun(CaseResult var1);

    @CheckForNull
    default public Run<?, ?> getRun() {
        Job theJob = (Job)Jenkins.get().getItemByFullName(this.getJobName(), Job.class);
        if (theJob == null) {
            return null;
        }
        return theJob.getBuildByNumber(this.getBuild());
    }

    @NonNull
    public String getJobName();

    @NonNull
    public int getBuild();

    @NonNull
    public TestResult getResultByNodes(@NonNull List<String> var1);

    @CheckForNull
    public TestResult getPreviousResult();

    public SuiteResult getSuite(String var1);

    default public Collection<SuiteResult> getSuites() {
        return Collections.emptyList();
    }

    public float getTotalTestDuration();
}

