/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.Failure;
import hudson.tasks.junit.TestAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TestResult
extends TestObject {
    private static final Logger LOGGER = Logger.getLogger(TestResult.class.getName());

    public void setParentAction(AbstractTestResultAction action) {
    }

    public AbstractTestResultAction getParentAction() {
        return (AbstractTestResultAction)this.getRun().getAction(AbstractTestResultAction.class);
    }

    public void tally() {
    }

    public void setParent(TestObject parent) {
    }

    public String getTitle() {
        return "";
    }

    public Result getBuildResult() {
        if (this.getFailCount() > 0) {
            return Result.UNSTABLE;
        }
        return null;
    }

    @Override
    public float getDuration() {
        return 0.0f;
    }

    @Override
    public int getPassCount() {
        return 0;
    }

    @Override
    public int getFailCount() {
        return 0;
    }

    @Override
    public int getSkipCount() {
        return 0;
    }

    @Override
    public TestResult getPreviousResult() {
        Run b = this.getRun();
        if (b == null) {
            return null;
        }
        Job job = b.getParent();
        while ((b = b.getPreviousBuild()) != null) {
            try {
                TestResult result;
                AbstractTestResultAction r = (AbstractTestResultAction)b.getAction(((Object)((Object)this.getParentAction())).getClass());
                if (r == null || (result = r.findCorrespondingResult(this.getId())) == null) continue;
                return result;
            }
            catch (RuntimeException e) {
                Run loggedBuild = b;
                LOGGER.log(Level.WARNING, e, () -> "Failed to load (corrupt?) build " + job.getFullName() + " #" + loggedBuild.getNumber() + ", skipping");
                continue;
            }
            break;
        }
        return null;
    }

    @Override
    public TestResult getResultInRun(Run<?, ?> build) {
        AbstractTestResultAction tra = (AbstractTestResultAction)build.getAction(((Object)((Object)this.getParentAction())).getClass());
        if (tra == null) {
            tra = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        }
        return tra == null ? null : tra.findCorrespondingResult(this.getId());
    }

    public Collection<? extends TestResult> getFailedTests() {
        return Collections.emptyList();
    }

    public Collection<? extends TestResult> getPassedTests() {
        return Collections.emptyList();
    }

    public Collection<? extends TestResult> getSkippedTests() {
        return Collections.emptyList();
    }

    public int getFailedSince() {
        return 0;
    }

    public Run<?, ?> getFailedSinceRun() {
        return null;
    }

    public String getStdout() {
        return "";
    }

    public String getStderr() {
        return "";
    }

    public String getErrorStackTrace() {
        return "";
    }

    public String getErrorDetails() {
        return "";
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public List<Failure> getFlakyFailures() {
        return Collections.emptyList();
    }

    public List<Failure> getRerunFailures() {
        return Collections.emptyList();
    }

    public boolean isPassed() {
        return this.getSkipCount() == 0 && this.getFailCount() == 0;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Name: ").append(this.getName()).append(", ");
        sb.append("Result: ").append(this.getBuildResult()).append(",\n");
        sb.append("Total Count: ").append(this.getTotalCount()).append(", ");
        sb.append("Fail: ").append(this.getFailCount()).append(", ");
        sb.append("Skipt: ").append(this.getSkipCount()).append(", ");
        sb.append("Pass: ").append(this.getPassCount()).append(",\n");
        sb.append("Test Result Class: ").append(this.getClass().getName()).append(" }\n");
        return sb.toString();
    }

    public String annotate(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace("&", "&amp;").replace("<", "&lt;");
        for (TestAction action : this.getTestActions()) {
            text = action.annotate(text);
        }
        return text;
    }
}

