/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestResult;
import java.util.ArrayList;
import java.util.List;

public class Widget {
    private final String symbol;
    private final List<String> lines = new ArrayList<String>();

    public Widget(TestResult result) {
        int failCount = result.getFailCount();
        boolean isFailed = failCount > 0;
        int totalCount = result.getTotalCount();
        this.symbol = isFailed ? "symbol-status-red" : "symbol-status-blue";
        ArrayList<String> counts = new ArrayList<String>();
        if (isFailed) {
            this.lines.add(Messages.Widget_Failed(failCount));
            counts.add(Messages.Widget_Passed(result.getPassCount()));
            long regressions = result.getSuites().stream().flatMap(e -> e.getCases().stream()).filter(e -> {
                CaseResult previousResult = e.getPreviousResult();
                if (previousResult == null) {
                    return false;
                }
                return e.isPassed();
            }).count();
            if (regressions > 0L) {
                this.lines.add(Messages.Widget_Regression(regressions));
            }
        } else {
            this.lines.add(Messages.Widget_AllTestsPassing());
        }
        if (result.getSkipCount() > 0) {
            counts.add(Messages.Widget_Skipped(result.getSkipCount()));
        }
        counts.add(Messages.Widget_Total(totalCount));
        this.lines.add(String.join((CharSequence)", ", counts));
        this.lines.add(Messages.Widget_Took(result.getDurationString()));
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<String> getLines() {
        return this.lines;
    }
}

