/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.Failure;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.Widget;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.HeapSpaceStringConverter;
import hudson.util.XStream2;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.SystemProperties;
import org.kohsuke.stapler.StaplerProxy;

@SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="False positive")
public class TestResultAction
extends AbstractTestResultAction<TestResultAction>
implements StaplerProxy,
SimpleBuildStep.LastBuildAction {
    private transient WeakReference<TestResult> result;
    @Nullable
    private Integer failCount;
    @Nullable
    private Integer skipCount;
    @Nullable
    private Integer totalCount;
    private Double healthScaleFactor;
    private List<Data> testData = new ArrayList<Data>();
    static ConcurrentHashMap<String, SoftReference<TestResult>> resultCache = new ConcurrentHashMap();
    static Object syncObj = new Object();
    static long lastCleanupNs = 0L;
    static long LARGE_RESULT_CACHE_CLEANUP_INTERVAL_NS = SystemProperties.getLong((String)(TestResultAction.class.getName() + ".LARGE_RESULT_CACHE_CLEANUP_INTERVAL_MS"), (Long)500L) * 1000000L;
    static int LARGE_RESULT_CACHE_THRESHOLD = SystemProperties.getInteger((String)(TestResultAction.class.getName() + ".LARGE_RESULT_CACHE_THRESHOLD"), (Integer)1000);
    static boolean RESULT_CACHE_ENABLED = SystemProperties.getBoolean((String)(TestResultAction.class.getName() + ".RESULT_CACHE_ENABLED"), (boolean)true);
    private static final Logger logger = Logger.getLogger(TestResultAction.class.getName());
    static final XStream XSTREAM = new XStream2();

    @Deprecated
    public TestResultAction(AbstractBuild owner, TestResult result, BuildListener listener) {
        this((Run)owner, result, (TaskListener)listener);
    }

    public TestResultAction(Run owner, TestResult result, TaskListener listener) {
        super(owner);
        if (JunitTestResultStorage.find() instanceof FileJunitTestResultStorage) {
            this.setResult(result, listener);
        }
    }

    @Deprecated
    public TestResultAction(TestResult result, BuildListener listener) {
        this((Run)null, result, (TaskListener)listener);
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.run.getParent();
        if (!Util.filter((List)job.getActions(), TestResultProjectAction.class).isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(new TestResultProjectAction(job));
    }

    public synchronized void setResult(TestResult result, TaskListener listener) {
        assert (JunitTestResultStorage.find() instanceof FileJunitTestResultStorage);
        result.freeze(this);
        this.totalCount = result.getTotalCount();
        this.failCount = result.getFailCount();
        this.skipCount = result.getSkipCount();
        if (this.run != null) {
            try {
                resultCache.put(this.getDataFilePath(), new SoftReference<TestResult>(result));
                this.getDataFile().write((Object)result);
            }
            catch (IOException e) {
                e.printStackTrace(listener.fatalError("Failed to save the JUnit test result"));
            }
        }
        this.result = new WeakReference<TestResult>(result);
    }

    @Deprecated
    public void setResult(TestResult result, BuildListener listener) {
        this.setResult(result, (TaskListener)listener);
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.run.getRootDir(), "junitResult.xml"));
    }

    private String getDataFilePath() {
        return Paths.get(this.run.getRootDir().getAbsolutePath(), "junitResult.xml").toString();
    }

    @Override
    public synchronized TestResult getResult() {
        long d;
        TestResult r;
        long started = System.nanoTime();
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            return new TestResult(storage.load(this.run.getParent().getFullName(), this.run.getNumber()));
        }
        if (this.result == null) {
            r = this.load();
            this.result = new WeakReference<TestResult>(r);
        } else {
            r = (TestResult)this.result.get();
        }
        if (r == null) {
            r = this.load();
            this.result = new WeakReference<TestResult>(r);
        }
        if (this.totalCount == null) {
            this.totalCount = r.getTotalCount();
            this.failCount = r.getFailCount();
            this.skipCount = r.getSkipCount();
        }
        if ((d = System.nanoTime() - started) > TimeUnit.MILLISECONDS.toNanos(500L)) {
            logger.warning(() -> "Took " + TimeUnit.NANOSECONDS.toMillis(d) + " ms to load test results for " + String.valueOf(this.run));
        }
        return r;
    }

    @Override
    public synchronized int getFailCount() {
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            return new TestResult(storage.load(this.run.getParent().getFullName(), this.run.getNumber())).getFailCount();
        }
        if (this.totalCount == null) {
            this.getResult();
        }
        return this.failCount;
    }

    @Override
    public synchronized int getSkipCount() {
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            return new TestResult(storage.load(this.run.getParent().getFullName(), this.run.getNumber())).getSkipCount();
        }
        if (this.totalCount == null) {
            this.getResult();
        }
        return this.skipCount;
    }

    @Override
    public synchronized int getTotalCount() {
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            return new TestResult(storage.load(this.run.getParent().getFullName(), this.run.getNumber())).getTotalCount();
        }
        if (this.totalCount == null) {
            this.getResult();
        }
        return this.totalCount;
    }

    @Override
    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    public void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    @Override
    public List<CaseResult> getFailedTests() {
        TestResult result = this.getResult();
        return result.getFailedTests();
    }

    @Override
    public List<CaseResult> getPassedTests() {
        return this.getResult().getPassedTests();
    }

    @Override
    public List<CaseResult> getSkippedTests() {
        return this.getResult().getSkippedTests();
    }

    private TestResult parseOnly() {
        TestResult r;
        XmlFile df = this.getDataFile();
        try {
            r = new TestResult();
            r.parse(df);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load " + String.valueOf(df), e);
            r = new TestResult();
        }
        return r;
    }

    private TestResult load() {
        if (RESULT_CACHE_ENABLED) {
            return this.loadCached();
        }
        return this.loadFallback();
    }

    private TestResult loadFallback() {
        TestResult r;
        try {
            r = (TestResult)this.getDataFile().read();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load " + String.valueOf(this.getDataFile()), e);
            r = new TestResult();
        }
        r.freeze(this);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult loadCached() {
        String k2;
        TestResult r;
        if (resultCache.size() > LARGE_RESULT_CACHE_THRESHOLD) {
            Object object = syncObj;
            synchronized (object) {
                if (resultCache.size() > LARGE_RESULT_CACHE_THRESHOLD && System.nanoTime() - lastCleanupNs > LARGE_RESULT_CACHE_CLEANUP_INTERVAL_NS) {
                    lastCleanupNs = System.nanoTime();
                    resultCache.forEach((k, v) -> {
                        if (v.get() == null) {
                            resultCache.remove(k);
                        }
                    });
                }
            }
        }
        if ((r = (TestResult)resultCache.computeIfAbsent(k2 = this.getDataFilePath(), path -> new SoftReference<TestResult>(this.parseOnly())).get()) == null) {
            r = this.parseOnly();
            resultCache.replace(k2, new SoftReference<TestResult>(r));
        }
        r = new TestResult(r);
        r.freeze(this);
        return r;
    }

    public Object getTarget() {
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestAction> getActions(hudson.tasks.test.TestObject object) {
        ArrayList<TestAction> result = new ArrayList<TestAction>();
        if (this.testData != null) {
            List<Data> list = this.testData;
            synchronized (list) {
                for (Data data : this.testData) {
                    for (TestAction testAction : data.getTestAction(object)) {
                        if (testAction == null) continue;
                        result.add(testAction);
                    }
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    List<Data> getData() {
        return this.testData;
    }

    public void setData(List<Data> testData) {
        this.testData = testData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(Data data) {
        List<Data> list = this.testData;
        synchronized (list) {
            this.testData.add(data);
        }
    }

    public void mergeResult(TestResult additionalResult, TaskListener listener) {
        TestResult original = this.getResult();
        original.merge(additionalResult);
        this.setResult(original, listener);
    }

    @Override
    public Object readResolve() {
        super.readResolve();
        if (this.testData == null) {
            this.testData = new ArrayList<Data>(0);
        }
        return this;
    }

    public Widget getWidget() {
        return new Widget(this.getResult());
    }

    static {
        XSTREAM.alias("result", TestResult.class);
        XSTREAM.alias("suite", SuiteResult.class);
        XSTREAM.alias("case", CaseResult.class);
        XSTREAM.alias("failure", Failure.class);
        XSTREAM.registerConverter((SingleValueConverter)new HeapSpaceStringConverter(), 100);
    }

    public static abstract class Data {
        public abstract List<? extends TestAction> getTestAction(TestObject var1);
    }
}

