/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.junit.TrendTestResultSummary;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResultActionIterable;
import hudson.tasks.test.TestResultTrendChart;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendChart;
import io.jenkins.plugins.echarts.AsyncTrendChart;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class TestResultProjectAction
implements Action,
AsyncTrendChart,
AsyncConfigurableTrendChart {
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    public final Job<?, ?> job;
    @Deprecated
    public final AbstractProject<?, ?> project;
    private static final String FAILURE_ONLY_COOKIE = "TestResultAction_failureOnly";

    public TestResultProjectAction(Job<?, ?> job) {
        this.job = job;
        this.project = job instanceof AbstractProject ? (AbstractProject)job : null;
    }

    @Deprecated
    public TestResultProjectAction(AbstractProject<?, ?> project) {
        this((Job<?, ?>)project);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Test Report";
    }

    public String getUrlName() {
        return "test";
    }

    public AbstractTestResultAction getLastTestResultAction() {
        for (Run b = this.job.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            AbstractTestResultAction a = (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class);
            if (a == null || b.isBuilding()) continue;
            return a;
        }
        return null;
    }

    @Deprecated
    protected LinesChartModel createChartModel() {
        return this.createChartModel(new ChartModelConfiguration(), TestResultTrendChart.PassedColor.BLUE);
    }

    private LinesChartModel createChartModel(ChartModelConfiguration configuration, TestResultTrendChart.PassedColor passedColor) {
        Run lastCompletedBuild = this.job.getLastCompletedBuild();
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            TestResultImpl pluggableStorage = storage.load(lastCompletedBuild.getParent().getFullName(), lastCompletedBuild.getNumber());
            List<TrendTestResultSummary> summary = pluggableStorage.getTrendTestResultSummary();
            if (summary.isEmpty()) {
                return new LinesChartModel();
            }
            return new TestResultTrendChart().create(summary, passedColor);
        }
        TestResultActionIterable buildHistory = this.createBuildHistory(lastCompletedBuild);
        if (buildHistory == null) {
            return new LinesChartModel();
        }
        return new TestResultTrendChart().create(buildHistory, configuration, passedColor);
    }

    @CheckForNull
    private TestResultActionIterable createBuildHistory(Run<?, ?> lastCompletedBuild) {
        if (lastCompletedBuild == null) {
            return null;
        }
        AbstractTestResultAction action = (AbstractTestResultAction)lastCompletedBuild.getAction(AbstractTestResultAction.class);
        if (action == null) {
            Run currentBuild = lastCompletedBuild;
            while (action == null) {
                if ((currentBuild = currentBuild.getPreviousBuild()) == null) {
                    return null;
                }
                action = (AbstractTestResultAction)currentBuild.getAction(AbstractTestResultAction.class);
            }
        }
        return new TestResultActionIterable(action);
    }

    @Deprecated
    public void doTrend(StaplerRequest req, StaplerResponse rsp) throws IOException {
        AbstractTestResultAction a = this.getLastTestResultAction();
        if (a != null) {
            a.doGraph(req, rsp);
        } else {
            rsp.setStatus(404);
        }
    }

    @Deprecated
    public void doTrendMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        AbstractTestResultAction a = this.getLastTestResultAction();
        if (a != null) {
            a.doGraphMap(req, rsp);
        } else {
            rsp.setStatus(404);
        }
    }

    public void doFlipTrend(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        boolean failureOnly = false;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(FAILURE_ONLY_COOKIE)) continue;
                failureOnly = Boolean.parseBoolean(cookie.getValue());
            }
        }
        failureOnly = !failureOnly;
        Cookie cookie = new Cookie(FAILURE_ONLY_COOKIE, String.valueOf(failureOnly));
        List anc = req.getAncestors();
        Ancestor a = (Ancestor)anc.get(anc.size() - 2);
        cookie.setPath(a.getUrl());
        cookie.setMaxAge(31536000);
        rsp.addCookie(cookie);
        rsp.sendRedirect("..");
    }

    @Deprecated
    public String getBuildTrendModel() {
        return new JacksonFacade().toJson((Object)this.createChartModel());
    }

    @JavaScriptMethod
    public String getConfigurableBuildTrendModel(String configuration) {
        TestResultTrendChart.PassedColor useBlue = JACKSON_FACADE.getBoolean(configuration, "useBlue", false) ? TestResultTrendChart.PassedColor.BLUE : TestResultTrendChart.PassedColor.GREEN;
        return new JacksonFacade().toJson((Object)this.createChartModel(ChartModelConfiguration.fromJson((String)configuration), useBlue));
    }

    public boolean isTrendVisible() {
        return true;
    }
}

