/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.Failure;
import hudson.tasks.junit.History;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.junit.TimeToFloat;
import hudson.util.TextFile;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.dom4j.Element;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.Exported;

public class CaseResult
extends hudson.tasks.test.TestResult
implements Comparable<CaseResult> {
    private static final Logger LOGGER = Logger.getLogger(CaseResult.class.getName());
    private float duration;
    private long startTime;
    private String className;
    private String testName;
    private transient String safeName;
    private boolean skipped;
    private boolean keepTestNames;
    private String skippedMessage;
    private String errorStackTrace;
    private String errorDetails;
    private Map<String, String> properties;
    private List<Failure> flakyFailures;
    private List<Failure> rerunFailures;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Specific method to restore it")
    private transient SuiteResult parent;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Not guarded, though read in synchronized blocks")
    private transient ClassResult classResult;
    private String stdout;
    private String stderr;
    private int failedSince;
    private static final int HALF_MAX_SIZE = 500;
    private static final int HALF_MAX_FAILING_SIZE = 50000;
    static int PREVIOUS_TEST_RESULT_BACKTRACK_BUILDS_MAX = Integer.parseInt(System.getProperty(History.HistoryTableResult.class.getName() + ".PREVIOUS_TEST_RESULT_BACKTRACK_BUILDS_MAX", "25"));
    static final Comparator<CaseResult> BY_AGE = Comparator.comparingInt(CaseResult::getAge);
    private static final long serialVersionUID = 1L;

    private static float parseTime(Element testCase) {
        String time = testCase.attributeValue("time");
        return new TimeToFloat(time).parse();
    }

    public CaseResult(SuiteResult parent, String testName, String errorStackTrace) {
        this(parent, testName, errorStackTrace, "");
    }

    public CaseResult(SuiteResult parent, String testName, String errorStackTrace, String errorDetails) {
        this.className = parent == null ? "unnamed" : parent.getName();
        this.testName = testName;
        this.errorStackTrace = errorStackTrace;
        this.errorDetails = errorDetails;
        this.parent = parent;
        this.stdout = null;
        this.stderr = null;
        this.duration = 0.0f;
        this.startTime = -1L;
        this.skipped = false;
        this.skippedMessage = null;
        this.properties = Collections.emptyMap();
        this.keepTestNames = false;
    }

    @Restricted(value={Beta.class})
    public CaseResult(SuiteResult parent, String className, String testName, String errorDetails, String skippedMessage, float duration, String stdout, String stderr, String stacktrace) {
        this.className = className;
        this.testName = testName;
        this.errorStackTrace = stacktrace;
        this.errorDetails = errorDetails;
        this.parent = parent;
        this.stdout = CaseResult.fixNULs(stdout);
        this.stderr = CaseResult.fixNULs(stderr);
        this.duration = duration;
        this.startTime = -1L;
        this.skipped = skippedMessage != null;
        this.skippedMessage = skippedMessage;
        this.properties = Collections.emptyMap();
        this.keepTestNames = false;
    }

    @Deprecated
    CaseResult(SuiteResult parent, Element testCase, String testClassName, boolean keepLongStdio, boolean keepProperties, boolean keepTestNames) {
        this(parent, testCase, testClassName, StdioRetention.fromKeepLongStdio(keepLongStdio), keepProperties, keepTestNames);
    }

    CaseResult(SuiteResult parent, Element testCase, String testClassName, StdioRetention stdioRetention, boolean keepProperties, boolean keepTestNames) {
        Element properties_element;
        String nameAttr = testCase.attributeValue("name");
        if (testClassName == null && nameAttr.contains(".")) {
            testClassName = nameAttr.substring(0, nameAttr.lastIndexOf(46));
            nameAttr = nameAttr.substring(nameAttr.lastIndexOf(46) + 1);
        }
        this.className = testClassName;
        this.testName = nameAttr;
        this.errorStackTrace = CaseResult.getError(testCase);
        this.errorDetails = CaseResult.getErrorMessage(testCase);
        this.parent = parent;
        this.duration = CaseResult.clampDuration(CaseResult.parseTime(testCase));
        this.startTime = -1L;
        this.skipped = CaseResult.isMarkedAsSkipped(testCase);
        this.skippedMessage = CaseResult.getSkippedMessage(testCase);
        Set<CaseResult> _this = Collections.singleton(this);
        this.stdout = CaseResult.fixNULs(CaseResult.possiblyTrimStdio(_this, stdioRetention, testCase.elementText("system-out")));
        this.stderr = CaseResult.fixNULs(CaseResult.possiblyTrimStdio(_this, stdioRetention, testCase.elementText("system-err")));
        HashMap<String, String> properties = new HashMap<String, String>();
        if (keepProperties && (properties_element = testCase.element("properties")) != null) {
            List property_elements = properties_element.elements("property");
            for (Element prop : property_elements) {
                if (prop.attributeValue("name") == null) continue;
                if (prop.attributeValue("value") != null) {
                    properties.put(prop.attributeValue("name"), prop.attributeValue("value"));
                    continue;
                }
                properties.put(prop.attributeValue("name"), prop.getText());
            }
        }
        this.properties = properties;
        this.keepTestNames = keepTestNames;
        this.flakyFailures = CaseResult.parseFlakyFailures(testCase);
        this.rerunFailures = CaseResult.parseRerunFailures(testCase);
    }

    public CaseResult(CaseResult src) {
        this.duration = src.duration;
        this.className = src.className;
        this.testName = src.testName;
        this.skippedMessage = src.skippedMessage;
        this.skipped = src.skipped;
        this.keepTestNames = src.keepTestNames;
        this.errorStackTrace = src.errorStackTrace;
        this.errorDetails = src.errorDetails;
        this.failedSince = src.failedSince;
        this.stdout = src.stdout;
        this.stderr = src.stderr;
        this.properties = new HashMap<String, String>();
        this.properties.putAll(src.properties);
        this.flakyFailures = src.flakyFailures;
        this.rerunFailures = src.rerunFailures;
    }

    public static float clampDuration(float d) {
        return Math.min(3.1536E7f, Math.max(0.0f, d));
    }

    private static List<Failure> parseFlakyFailures(Element testCase) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        List flakyFailuresElements = testCase.elements("flakyFailure");
        if (flakyFailuresElements != null) {
            for (Element flakyFailuresElement : flakyFailuresElements) {
                String message = flakyFailuresElement.attributeValue("message");
                String type = flakyFailuresElement.attributeValue("type");
                String stackTrace = flakyFailuresElement.elementText("stackTrace");
                String stdout = flakyFailuresElement.elementText("system-out");
                String stderr = flakyFailuresElement.elementText("system-err");
                failures.add(new Failure(message, type, stackTrace, stdout, stderr));
            }
        }
        return failures;
    }

    private static List<Failure> parseRerunFailures(Element testCase) {
        ArrayList<Failure> rerunFailures = new ArrayList<Failure>();
        List rerunFailureElements = testCase.elements("rerunFailure");
        if (rerunFailureElements != null) {
            for (Element rerunFailureElement : rerunFailureElements) {
                String message = rerunFailureElement.attributeValue("message");
                String type = rerunFailureElement.attributeValue("type");
                String stackTrace = rerunFailureElement.elementText("stackTrace");
                String stdout = rerunFailureElement.elementText("system-out");
                String stderr = rerunFailureElement.elementText("system-err");
                rerunFailures.add(new Failure(message, type, stackTrace, stdout, stderr));
            }
        }
        return rerunFailures;
    }

    static CaseResult parse(SuiteResult parent, XMLStreamReader reader, String context, String ver) throws XMLStreamException {
        CaseResult r = new CaseResult(parent, null, null, null);
        block34: while (reader.hasNext()) {
            String elementName;
            int event = reader.next();
            if (event == 2 && reader.getLocalName().equals("case")) {
                return r;
            }
            if (event != 1) continue;
            switch (elementName = reader.getLocalName()) {
                case "duration": {
                    r.duration = CaseResult.clampDuration(new TimeToFloat(reader.getElementText()).parse());
                    continue block34;
                }
                case "startTime": {
                    r.startTime = Long.parseLong(reader.getElementText());
                    continue block34;
                }
                case "className": {
                    r.className = reader.getElementText();
                    continue block34;
                }
                case "testName": {
                    r.testName = reader.getElementText();
                    continue block34;
                }
                case "skippedMessage": {
                    r.skippedMessage = reader.getElementText();
                    continue block34;
                }
                case "skipped": {
                    r.skipped = Boolean.parseBoolean(reader.getElementText());
                    continue block34;
                }
                case "keepTestNames": {
                    r.keepTestNames = Boolean.parseBoolean(reader.getElementText());
                    continue block34;
                }
                case "errorStackTrace": {
                    r.errorStackTrace = reader.getElementText();
                    continue block34;
                }
                case "errorDetails": {
                    r.errorDetails = reader.getElementText();
                    continue block34;
                }
                case "failedSince": {
                    r.failedSince = Integer.parseInt(reader.getElementText());
                    continue block34;
                }
                case "stdout": {
                    r.stdout = reader.getElementText();
                    continue block34;
                }
                case "stderr": {
                    r.stderr = reader.getElementText();
                    continue block34;
                }
                case "properties": {
                    r.properties = new HashMap<String, String>();
                    CaseResult.parseProperties(r.properties, reader, context, ver);
                    continue block34;
                }
                case "flakyFailures": {
                    r.flakyFailures = CaseResult.parseFailures(reader, context, "flakyFailures");
                    continue block34;
                }
                case "rerunFailures": {
                    r.rerunFailures = CaseResult.parseFailures(reader, context, "rerunFailures");
                    continue block34;
                }
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
        return r;
    }

    static List<Failure> parseFailures(XMLStreamReader reader, String context, String endElement) throws XMLStreamException {
        int event;
        ArrayList<Failure> failures = new ArrayList<Failure>();
        while (reader.hasNext() && ((event = reader.next()) != 2 || !reader.getLocalName().equals(endElement))) {
            if (event != 1) continue;
            String elementName = reader.getLocalName();
            if (elementName.equals("failure")) {
                failures.add(CaseResult.parseFailure(reader, context));
                continue;
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
        return failures;
    }

    public static Failure parseFailure(XMLStreamReader reader, String context) throws XMLStreamException {
        int event;
        String message = null;
        String type = null;
        String stackTrace = null;
        String stdout = null;
        String stderr = null;
        block14: while (reader.hasNext() && ((event = reader.next()) != 2 || !"failure".equals(reader.getLocalName()))) {
            String elementName;
            if (event != 1) continue;
            switch (elementName = reader.getLocalName()) {
                case "message": {
                    message = reader.getElementText();
                    continue block14;
                }
                case "type": {
                    type = reader.getElementText();
                    continue block14;
                }
                case "stackTrace": {
                    stackTrace = reader.getElementText();
                    continue block14;
                }
                case "stdout": {
                    stdout = reader.getElementText();
                    continue block14;
                }
                case "stderr": {
                    stderr = reader.getElementText();
                    continue block14;
                }
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
        return new Failure(message, type, stackTrace, stdout, stderr);
    }

    static void parseProperties(Map<String, String> r, XMLStreamReader reader, String context, String ver) throws XMLStreamException {
        block6: while (reader.hasNext()) {
            String elementName;
            int event = reader.next();
            if (event == 2 && reader.getLocalName().equals("properties")) {
                return;
            }
            if (event != 1) continue;
            switch (elementName = reader.getLocalName()) {
                case "entry": {
                    CaseResult.parseProperty(r, reader, context, ver);
                    continue block6;
                }
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
    }

    static void parseProperty(Map<String, String> r, XMLStreamReader reader, String context, String ver) throws XMLStreamException {
        String name = null;
        String value = null;
        block6: while (reader.hasNext()) {
            String elementName;
            int event = reader.next();
            if (event == 2 && reader.getLocalName().equals("entry")) {
                if (name != null && value != null) {
                    r.put(name, value);
                }
                return;
            }
            if (event != 1) continue;
            switch (elementName = reader.getLocalName()) {
                case "string": {
                    if (name == null) {
                        name = reader.getElementText();
                        continue block6;
                    }
                    value = reader.getElementText();
                    continue block6;
                }
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
    }

    static CharSequence cleanupTruncated(CharSequence str) {
        if (str.length() > 0 && Character.isLowSurrogate(str.charAt(0))) {
            str = str.subSequence(1, str.length());
        }
        if (str.length() > 0 && Character.isHighSurrogate(str.charAt(str.length() - 1))) {
            str = str.subSequence(0, str.length() - 1);
        }
        return str;
    }

    static String possiblyTrimStdio(Collection<CaseResult> results, StdioRetention stdioRetention, String stdio) {
        int halfMaxSize;
        boolean keepAll;
        if (stdio == null) {
            return null;
        }
        boolean bl = keepAll = stdioRetention == StdioRetention.ALL || stdioRetention == StdioRetention.FAILED && CaseResult.hasFailures(results);
        if (keepAll) {
            return stdio;
        }
        int len = stdio.length();
        int middle = len - (halfMaxSize = CaseResult.halfMaxSize(results)) * 2;
        if (middle <= 0) {
            return stdio;
        }
        return String.valueOf(CaseResult.cleanupTruncated(stdio.subSequence(0, halfMaxSize))) + "\n...[truncated " + middle + " chars]...\n" + String.valueOf(CaseResult.cleanupTruncated(stdio.subSequence(len - halfMaxSize, len)));
    }

    static String fixNULs(String stdio) {
        return stdio == null ? null : stdio.replace("\u0000", "^@");
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Expected behavior")
    static String possiblyTrimStdio(Collection<CaseResult> results, StdioRetention stdioRetention, File stdio) throws IOException {
        int tailBytes;
        boolean keepAll;
        long len = stdio.length();
        boolean bl = keepAll = stdioRetention == StdioRetention.ALL || stdioRetention == StdioRetention.FAILED && CaseResult.hasFailures(results);
        if (keepAll && len < 0x100000L) {
            return FileUtils.readFileToString((File)stdio);
        }
        int halfMaxSize = CaseResult.halfMaxSize(results);
        long middle = len - (long)(halfMaxSize * 2);
        if (middle <= 0L) {
            return FileUtils.readFileToString((File)stdio);
        }
        TextFile tx = new TextFile(stdio);
        String head = tx.head(halfMaxSize);
        String tail = tx.fastTail(halfMaxSize);
        int headBytes = head.getBytes().length;
        middle = len - (long)(headBytes + (tailBytes = tail.getBytes().length));
        if (middle <= 0L) {
            return FileUtils.readFileToString((File)stdio);
        }
        return String.valueOf(CaseResult.cleanupTruncated(head)) + "\n...[truncated " + middle + " bytes]...\n" + String.valueOf(CaseResult.cleanupTruncated(tail));
    }

    private static int halfMaxSize(Collection<CaseResult> results) {
        return CaseResult.hasFailures(results) ? 50000 : 500;
    }

    private static boolean hasFailures(Collection<CaseResult> results) {
        return results.stream().anyMatch(r -> r.errorStackTrace != null);
    }

    @Override
    public ClassResult getParent() {
        return this.classResult;
    }

    private static String getError(Element testCase) {
        String msg = testCase.elementText("error");
        if (msg != null) {
            return msg;
        }
        return testCase.elementText("failure");
    }

    private static String getErrorMessage(Element testCase) {
        Element msg = testCase.element("error");
        if (msg == null) {
            msg = testCase.element("failure");
        }
        if (msg == null) {
            return null;
        }
        return msg.attributeValue("message");
    }

    private static boolean isMarkedAsSkipped(Element testCase) {
        return testCase.element("skipped") != null;
    }

    private static String getSkippedMessage(Element testCase) {
        String message = null;
        Element skippedElement = testCase.element("skipped");
        if (skippedElement != null && (message = skippedElement.attributeValue("message")) == null) {
            message = skippedElement.getText();
        }
        return message;
    }

    public String getTransformedTestName() {
        return TestNameTransformer.getTransformedName(this.getName());
    }

    public String getDisplayName() {
        return this.getNameWithEnclosingBlocks(this.getTransformedTestName());
    }

    private String getNameWithEnclosingBlocks(String rawName) {
        TestResultAction action;
        Run<?, ?> r;
        if (!this.keepTestNames && !this.getEnclosingFlowNodeNames().isEmpty() && (r = this.getRun()) != null && (action = (TestResultAction)r.getAction(TestResultAction.class)) != null && action.getResult().hasMultipleBlocks()) {
            List<String> enclosingFlowNodeNames = this.getEnclosingFlowNodeNames();
            Collections.reverse(enclosingFlowNodeNames);
            return String.join((CharSequence)" / ", enclosingFlowNodeNames) + " / " + rawName;
        }
        return rawName;
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        if (this.testName == null || this.testName.isEmpty()) {
            return "(?)";
        }
        return this.testName;
    }

    @Override
    public String getTitle() {
        return "Case Result: " + this.getDisplayName();
    }

    @Override
    @Exported(visibility=9)
    public float getDuration() {
        return this.duration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        StringBuilder buf = new StringBuilder(this.getDisplayName());
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            buf.setCharAt(i, '_');
        }
        List siblings = this.classResult == null ? Collections.emptyList() : this.classResult.getChildren();
        this.safeName = this.uniquifyName(siblings, buf.toString());
        return this.safeName;
    }

    @Exported(visibility=9)
    public String getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        int idx = this.className.lastIndexOf(46);
        return this.className.substring(idx + 1);
    }

    public String getPackageName() {
        int idx = this.className.lastIndexOf(46);
        if (idx < 0) {
            return "(root)";
        }
        return this.className.substring(0, idx);
    }

    @Override
    public String getFullName() {
        return this.className + "." + this.getName();
    }

    @Override
    public String getFullDisplayName() {
        return this.getNameWithEnclosingBlocks(this.getTransformedFullDisplayName());
    }

    public String getTransformedFullDisplayName() {
        return TestNameTransformer.getTransformedName(this.getFullName());
    }

    @Override
    public int getFailCount() {
        if (this.isFailed()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getSkipCount() {
        if (this.isSkipped()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPassCount() {
        return this.isPassed() ? 1 : 0;
    }

    @Override
    @Exported(visibility=9)
    public int getFailedSince() {
        this.recomputeFailedSinceIfNeeded();
        return this.failedSince;
    }

    private void recomputeFailedSinceIfNeeded() {
        if (this.failedSince == 0 && this.getFailCount() == 1) {
            CaseResult prev = this.getPreviousResult();
            if (prev != null && prev.isFailed()) {
                this.failedSince = prev.getFailedSince();
            } else if (this.getRun() != null) {
                this.failedSince = this.getRun().getNumber();
            } else {
                LOGGER.warning("trouble calculating getFailedSince. We've got prev, but no owner.");
            }
        }
    }

    @Override
    public Run<?, ?> getFailedSinceRun() {
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            Run run = (Run)Stapler.getCurrentRequest2().findAncestorObject(Run.class);
            TestResultImpl pluggableStorage = storage.load(run.getParent().getFullName(), run.getNumber());
            return pluggableStorage.getFailedSinceRun(this);
        }
        return this.getRun().getParent().getBuildByNumber(this.getFailedSince());
    }

    @Exported(visibility=9)
    public int getAge() {
        if (this.isPassed()) {
            return 0;
        }
        if (this.getRun() != null) {
            return this.getRun().getNumber() - this.getFailedSince() + 1;
        }
        LOGGER.fine("Trying to get age of a CaseResult without an owner");
        return 0;
    }

    @Override
    @Exported
    public String getStdout() {
        if (this.stdout != null) {
            return this.stdout;
        }
        SuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            return "";
        }
        return this.getSuiteResult().getStdout();
    }

    @Override
    @Exported
    public String getStderr() {
        if (this.stderr != null) {
            return this.stderr;
        }
        SuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            return "";
        }
        return this.getSuiteResult().getStderr();
    }

    @Override
    public CaseResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        hudson.tasks.test.TestResult previousResult = this.parent.getParent();
        for (int n = 0; previousResult != null && n < PREVIOUS_TEST_RESULT_BACKTRACK_BUILDS_MAX; ++n) {
            hudson.tasks.test.TestResult pr;
            CaseResult cr;
            if ((previousResult = previousResult.getPreviousResult()) == null) {
                return null;
            }
            if (!(previousResult instanceof TestResult) || (cr = ((TestResult)(pr = previousResult)).getCase(this.parent.getName(), this.getTransformedFullDisplayName())) == null) continue;
            return cr;
        }
        return null;
    }

    @Override
    public hudson.tasks.test.TestResult findCorrespondingResult(String id) {
        if (id.equals(CaseResult.safe(this.getName()))) {
            return this;
        }
        return null;
    }

    @Override
    public Collection<? extends hudson.tasks.test.TestResult> getFailedTests() {
        return this.singletonListOfThisOrEmptyList(this.isFailed());
    }

    @Override
    public Collection<? extends hudson.tasks.test.TestResult> getPassedTests() {
        return this.singletonListOfThisOrEmptyList(this.isPassed());
    }

    @Override
    public Collection<? extends hudson.tasks.test.TestResult> getSkippedTests() {
        return this.singletonListOfThisOrEmptyList(this.isSkipped());
    }

    private Collection<? extends hudson.tasks.test.TestResult> singletonListOfThisOrEmptyList(boolean f) {
        if (f) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    @Override
    @Exported
    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    @Override
    @Exported
    public String getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    @Exported
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isPassed() {
        return !this.skipped && this.errorDetails == null && this.errorStackTrace == null;
    }

    @Exported(visibility=9)
    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isFailed() {
        return !this.isPassed() && !this.isSkipped();
    }

    @Exported
    public String getSkippedMessage() {
        return this.skippedMessage;
    }

    public SuiteResult getSuiteResult() {
        return this.parent;
    }

    @CheckForNull
    public String getFlowNodeId() {
        if (this.parent != null) {
            return this.parent.getNodeId();
        }
        return null;
    }

    @NonNull
    public List<String> getEnclosingFlowNodeIds() {
        ArrayList<String> enclosing = new ArrayList<String>();
        if (this.parent != null) {
            enclosing.addAll(this.parent.getEnclosingBlocks());
        }
        return enclosing;
    }

    @NonNull
    public List<String> getEnclosingFlowNodeNames() {
        ArrayList<String> enclosing = new ArrayList<String>();
        if (this.parent != null) {
            enclosing.addAll(this.parent.getEnclosingBlockNames());
        }
        return enclosing;
    }

    @Override
    public Run<?, ?> getRun() {
        SuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            LOGGER.warning("In getOwner(), getSuiteResult is null");
            return null;
        }
        TestResult tr = sr.getParent();
        if (tr == null) {
            LOGGER.warning("In getOwner(), suiteResult.getParent() is null.");
            return null;
        }
        return tr.getRun();
    }

    public void setParentSuiteResult(SuiteResult parent) {
        this.parent = parent;
    }

    public void freeze(SuiteResult parent) {
        this.parent = parent;
        this.recomputeFailedSinceIfNeeded();
    }

    @Override
    public int compareTo(CaseResult that) {
        if (this == that) {
            return 0;
        }
        int r1 = this.className.compareTo(that.className);
        if (r1 != 0) {
            return r1;
        }
        int r2 = this.getName().compareTo(that.getName());
        if (r2 != 0) {
            return r2;
        }
        return System.identityHashCode(this) >= System.identityHashCode(that) ? 1 : -1;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Exported(name="status", visibility=9)
    public Status getStatus() {
        if (this.skipped) {
            return Status.SKIPPED;
        }
        return this.isPassed() ? Status.PASSED : Status.FAILED;
    }

    public Status getCondition() {
        if (this.skipped) {
            return null;
        }
        CaseResult pr = this.getPreviousResult();
        if (pr == null) {
            return null;
        }
        if (pr.isPassed()) {
            return this.isPassed() ? null : Status.REGRESSION;
        }
        return this.isPassed() ? Status.FIXED : null;
    }

    public void setClass(ClassResult classResult) {
        this.classResult = classResult;
    }

    public void setStartTime(long start) {
        this.startTime = start;
    }

    void replaceParent(SuiteResult parent) {
        this.parent = parent;
    }

    @Override
    @Exported
    public List<Failure> getFlakyFailures() {
        return this.flakyFailures == null ? Collections.emptyList() : Collections.unmodifiableList(this.flakyFailures);
    }

    @Override
    @Exported
    public List<Failure> getRerunFailures() {
        return this.rerunFailures == null ? Collections.emptyList() : Collections.unmodifiableList(this.rerunFailures);
    }

    @Restricted(value={NoExternalUse.class})
    public String getIconFileName() {
        return switch (this.getStatus().ordinal()) {
            case 0 -> "symbol-status-blue";
            case 1 -> "symbol-status-skipped plugin-junit";
            default -> "symbol-status-red";
        };
    }

    public static enum Status {
        PASSED("jp-pill jenkins-!-success-color", Messages._CaseResult_Status_Passed(), true),
        SKIPPED("jp-pill jenkins-!-skipped-color", Messages._CaseResult_Status_Skipped(), false),
        FAILED("jp-pill jenkins-!-error-color", Messages._CaseResult_Status_Failed(), false),
        FIXED("jp-pill jenkins-!-success-color", Messages._CaseResult_Status_Fixed(), true),
        REGRESSION("jp-pill jenkins-!-error-color", Messages._CaseResult_Status_Regression(), false);

        private final String cssClass;
        private final Localizable message;
        public final boolean isOK;

        private Status(String cssClass, Localizable message, boolean OK) {
            this.cssClass = cssClass;
            this.message = message;
            this.isOK = OK;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getMessage() {
            return this.message.toString();
        }

        public boolean isRegression() {
            return this == REGRESSION;
        }
    }
}

