/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;

final class Dispatcher<T> {
    private static final Runnable POISON_PILL = () -> System.out.println("Why so serious?");
    private final CompletableFuture<Void> completionSignaller = new CompletableFuture();
    private final BlockingQueue<Runnable> workingQueue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService dispatcher = Executors.newSingleThreadExecutor();
    private final Executor executor;
    private final Semaphore limiter;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile boolean shortCircuited = false;

    private Dispatcher(Executor executor, int permits) {
        this.executor = executor;
        this.limiter = new Semaphore(permits);
    }

    static <T> Dispatcher<T> from(Executor executor, int permits) {
        return new Dispatcher<T>(executor, permits);
    }

    void start() {
        if (!this.started.getAndSet(true)) {
            this.dispatcher.execute(() -> {
                try {
                    while (true) {
                        try {
                            if (this.limiter != null) {
                                this.limiter.acquire();
                            }
                        }
                        catch (InterruptedException e) {
                            this.handle(e);
                        }
                        Runnable task = this.workingQueue.take();
                        if (task != POISON_PILL) {
                            this.executor.execute(() -> {
                                try {
                                    task.run();
                                }
                                finally {
                                    if (this.limiter != null) {
                                        this.limiter.release();
                                    }
                                }
                            });
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    this.handle(e);
                }
            });
        }
    }

    void stop() {
        try {
            this.workingQueue.put(POISON_PILL);
        }
        catch (InterruptedException e) {
            this.completionSignaller.completeExceptionally(e);
        }
        finally {
            this.dispatcher.shutdown();
        }
    }

    boolean isRunning() {
        return this.started.get();
    }

    CompletableFuture<T> enqueue(Supplier<T> supplier) {
        InterruptibleCompletableFuture future = new InterruptibleCompletableFuture();
        this.workingQueue.add(this.completionTask(supplier, future));
        this.completionSignaller.exceptionally((Function)Dispatcher.shortcircuit(future));
        return future;
    }

    private FutureTask<Void> completionTask(Supplier<T> supplier, InterruptibleCompletableFuture<T> future) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            try {
                if (!this.shortCircuited) {
                    future.complete(supplier.get());
                }
            }
            catch (Throwable e) {
                this.handle(e);
            }
        }, null);
        ((InterruptibleCompletableFuture)future).completedBy(task);
        return task;
    }

    private void handle(Throwable e) {
        this.shortCircuited = true;
        this.completionSignaller.completeExceptionally(e);
        this.dispatcher.shutdownNow();
    }

    private void withLimiter(Supplier<T> supplier, InterruptibleCompletableFuture<T> future) throws InterruptedException {
        try {
            this.limiter.acquire();
            future.complete(supplier.get());
        }
        finally {
            this.limiter.release();
        }
    }

    private static Function<Throwable, Void> shortcircuit(InterruptibleCompletableFuture<?> future) {
        return throwable -> {
            future.completeExceptionally((Throwable)throwable);
            future.cancel(true);
            return null;
        };
    }

    static int getDefaultParallelism() {
        return Math.max(Runtime.getRuntime().availableProcessors() - 1, 4);
    }

    static final class InterruptibleCompletableFuture<T>
    extends CompletableFuture<T> {
        private volatile FutureTask<?> backingTask;

        InterruptibleCompletableFuture() {
        }

        private void completedBy(FutureTask<?> task) {
            this.backingTask = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            FutureTask<?> task = this.backingTask;
            if (task != null) {
                task.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

