/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TestResultActionIterable
implements Iterable<BuildResult<AbstractTestResultAction<?>>> {
    private final AbstractTestResultAction<?> latestAction;

    public TestResultActionIterable(AbstractTestResultAction<?> baseline) {
        this.latestAction = baseline;
    }

    @Override
    @NonNull
    public Iterator<BuildResult<AbstractTestResultAction<?>>> iterator() {
        if (this.latestAction == null) {
            return new TestResultActionIterator(null);
        }
        return new TestResultActionIterator(this.latestAction);
    }

    private static class TestResultActionIterator
    implements Iterator<BuildResult<AbstractTestResultAction<?>>> {
        private AbstractTestResultAction<?> cursor;
        private AbstractTestResultAction<?> initialValue;

        TestResultActionIterator(AbstractTestResultAction<?> baseline) {
            this.initialValue = baseline;
        }

        @Override
        public boolean hasNext() {
            if (this.initialValue != null) {
                return true;
            }
            if (this.cursor == null) {
                return false;
            }
            AbstractTestResultAction previousBuild = this.cursor.getPreviousResult(AbstractTestResultAction.class, true);
            return previousBuild != null;
        }

        @Override
        public BuildResult<AbstractTestResultAction<?>> next() {
            if (this.initialValue == null && this.cursor == null) {
                throw new NoSuchElementException("There is no action available anymore. Use hasNext() before calling next().");
            }
            AbstractTestResultAction<?> buildAction = this.getBuildAction();
            if (buildAction != null) {
                this.cursor = buildAction;
                Run<?, ?> run = this.cursor.run;
                int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
                Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
                return new BuildResult(build, buildAction);
            }
            throw new NoSuchElementException("No more runs with a test result available: " + String.valueOf(this.cursor));
        }

        private AbstractTestResultAction<?> getBuildAction() {
            AbstractTestResultAction run;
            if (this.initialValue != null) {
                run = this.initialValue;
                this.initialValue = null;
            } else {
                run = this.cursor.getPreviousResult(AbstractTestResultAction.class, true);
            }
            return run;
        }
    }
}

