/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Api;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.tasks.test.Messages;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import hudson.util.Area;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import jenkins.model.lazy.LazyBuildMixIn;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractTestResultAction<T extends AbstractTestResultAction>
implements HealthReportingAction,
RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(AbstractTestResultAction.class.getName());
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient Run<?, ?> run;
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient AbstractBuild<?, ?> owner;
    private Map<String, String> descriptions = new ConcurrentHashMap<String, String>();

    protected AbstractTestResultAction() {
    }

    @Deprecated
    protected AbstractTestResultAction(Run owner) {
        this.onAttached(owner);
    }

    @Deprecated
    protected AbstractTestResultAction(AbstractBuild owner) {
        this((Run)owner);
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
        this.owner = r instanceof AbstractBuild ? (AbstractBuild)r : null;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
        this.owner = r instanceof AbstractBuild ? (AbstractBuild)r : null;
    }

    @Exported(visibility=2)
    public abstract int getFailCount();

    @Exported(visibility=2)
    public int getSkipCount() {
        return 0;
    }

    @Exported(visibility=2)
    public abstract int getTotalCount();

    public final String getFailureDiffString() {
        T prev = this.getPreviousResult();
        if (prev == null) {
            return "";
        }
        return " / " + Functions.getDiffString((int)(this.getFailCount() - ((AbstractTestResultAction)prev).getFailCount()));
    }

    public String getDisplayName() {
        return Messages.AbstractTestResultAction_getDisplayName();
    }

    @Exported(visibility=2)
    public String getUrlName() {
        return "testReport";
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public HealthReport getBuildHealth() {
        double scaleFactor = this.getHealthScaleFactor();
        if (scaleFactor < 1.0E-7) {
            return null;
        }
        int totalCount = this.getTotalCount();
        int failCount = this.getFailCount();
        int score = totalCount == 0 ? 100 : (int)(100.0 * Math.max(0.0, Math.min(1.0, 1.0 - scaleFactor * (double)failCount / (double)totalCount)));
        Localizable displayName = Messages._AbstractTestResultAction_getDisplayName();
        Localizable description = totalCount == 0 ? Messages._AbstractTestResultAction_zeroTestDescription(displayName) : Messages._AbstractTestResultAction_TestsDescription(displayName, failCount, totalCount);
        return new HealthReport(score, description);
    }

    public double getHealthScaleFactor() {
        return 1.0;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public abstract Object getResult();

    public T getPreviousResult() {
        return (T)this.getPreviousResult(this.getClass(), true);
    }

    @Restricted(value={NoExternalUse.class})
    public <U extends AbstractTestResultAction> U getPreviousResult(Class<U> type, boolean eager) {
        AbstractTestResultAction r;
        Run b = this.run;
        Set loadedBuilds = !eager && this.run.getParent() instanceof LazyBuildMixIn.LazyLoadingJob ? ((LazyBuildMixIn.LazyLoadingJob)this.run.getParent()).getLazyBuildMixIn()._getRuns().getLoadedBuilds().keySet() : null;
        do {
            Object object = b = loadedBuilds == null || loadedBuilds.contains(b.number - 1) ? b.getPreviousBuild() : null;
            if (b != null) continue;
            return null;
        } while ((r = (AbstractTestResultAction)b.getAction(type)) == null);
        if (r == this) {
            throw new IllegalStateException(String.valueOf(this) + " was attached to both " + String.valueOf(b) + " and " + String.valueOf(this.run));
        }
        if (r.run.number != b.number) {
            throw new IllegalStateException(String.valueOf(r) + " was attached to both " + String.valueOf(b) + " and " + String.valueOf(r.run));
        }
        return (U)r;
    }

    public TestResult findPreviousCorresponding(TestResult test) {
        T previousResult = this.getPreviousResult();
        if (previousResult != null) {
            TestResult testResult = (TestResult)this.getResult();
            return testResult.findCorrespondingResult(test.getId());
        }
        return null;
    }

    public TestResult findCorrespondingResult(String id) {
        Object testResult = this.getResult();
        if (!(testResult instanceof TestResult)) {
            return null;
        }
        return ((TestResult)testResult).findCorrespondingResult(id);
    }

    public List<? extends TestResult> getFailedTests() {
        return Collections.emptyList();
    }

    @NonNull
    public List<? extends TestResult> getPassedTests() {
        return Collections.emptyList();
    }

    @NonNull
    public List<? extends TestResult> getSkippedTests() {
        return Collections.emptyList();
    }

    @Deprecated
    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        if (req.checkIfModified(this.run.getTimestamp(), rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(req, this.buildDataSet(req)), (Area)this.calcDefaultSize());
    }

    public void doGraphMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.checkIfModified(this.run.getTimestamp(), rsp)) {
            return;
        }
        ChartUtil.generateClickableMap((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(req, this.buildDataSet(req)), (Area)this.calcDefaultSize());
    }

    public String getTestResultPath(TestResult it) {
        return this.getUrlName() + "/" + it.getRelativePathFrom(null);
    }

    private Area calcDefaultSize() {
        Area res = Functions.getScreenResolution();
        if (res != null && res.width <= 800) {
            return new Area(250, 100);
        }
        return new Area(500, 200);
    }

    private CategoryDataset buildDataSet(StaplerRequest req) {
        boolean failureOnly = Boolean.parseBoolean(req.getParameter("failureOnly"));
        DataSetBuilder dsb = new DataSetBuilder();
        int cap = Integer.getInteger(AbstractTestResultAction.class.getName() + ".test.trend.max", Integer.MAX_VALUE);
        int count = 0;
        for (AbstractTestResultAction a = this; a != null; a = a.getPreviousResult(AbstractTestResultAction.class, false)) {
            if (++count > cap) {
                LOGGER.log(Level.FINE, "capping test trend for {0} at {1}", new Object[]{this.run, cap});
                break;
            }
            dsb.add((Number)a.getFailCount(), (Comparable)((Object)"failed"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.run));
            if (failureOnly) continue;
            dsb.add((Number)a.getSkipCount(), (Comparable)((Object)"skipped"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.run));
            dsb.add((Number)(a.getTotalCount() - a.getFailCount() - a.getSkipCount()), (Comparable)((Object)"total"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.run));
        }
        LOGGER.log(Level.FINER, "total test trend count for {0}: {1}", new Object[]{this.run, count});
        return dsb.build();
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset) {
        final String relPath = this.getRelPath(req);
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                return relPath + label.getRun().getNumber() + "/testReport/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                AbstractTestResultAction a = (AbstractTestResultAction)label.getRun().getAction(AbstractTestResultAction.class);
                switch (row) {
                    case 0: {
                        return String.valueOf(Messages.AbstractTestResultAction_fail(label.getRun().getDisplayName(), a.getFailCount()));
                    }
                    case 1: {
                        return String.valueOf(Messages.AbstractTestResultAction_skip(label.getRun().getDisplayName(), a.getSkipCount()));
                    }
                }
                return String.valueOf(Messages.AbstractTestResultAction_test(label.getRun().getDisplayName(), a.getTotalCount()));
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private String getRelPath(StaplerRequest req) {
        String relPath = req.getParameter("rel");
        if (relPath == null) {
            return "";
        }
        return relPath;
    }

    protected String getDescription(TestObject object) {
        return this.descriptions.get(object.getId());
    }

    protected void setDescription(TestObject object, String description) {
        this.descriptions.put(object.getId(), description);
    }

    public Object readResolve() {
        if (this.descriptions == null) {
            this.descriptions = new ConcurrentHashMap<String, String>();
        }
        return this;
    }

    @Extension
    public static final class Summarizer
    extends Run.StatusSummarizer {
        public Run.Summary summarize(Run<?, ?> run, ResultTrend trend) {
            AbstractTestResultAction trP;
            Boolean worseOverride;
            AbstractTestResultAction trN = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            if (trN == null) {
                return null;
            }
            switch (trend) {
                case NOW_UNSTABLE: {
                    worseOverride = false;
                    break;
                }
                case UNSTABLE: {
                    worseOverride = true;
                    break;
                }
                case STILL_UNSTABLE: {
                    worseOverride = null;
                    break;
                }
                default: {
                    return null;
                }
            }
            Run prev = run.getPreviousBuild();
            AbstractTestResultAction abstractTestResultAction = trP = prev == null ? null : (AbstractTestResultAction)prev.getAction(AbstractTestResultAction.class);
            if (trP == null) {
                if (trN.getFailCount() > 0) {
                    return new Run.Summary(worseOverride != null ? worseOverride : true, Messages.Run_Summary_TestFailures(trN.getFailCount()));
                }
            } else if (trN.getFailCount() != 0) {
                if (trP.getFailCount() == 0) {
                    return new Run.Summary(worseOverride != null ? worseOverride : true, Messages.Run_Summary_TestsStartedToFail(trN.getFailCount()));
                }
                if (trP.getFailCount() < trN.getFailCount()) {
                    return new Run.Summary(worseOverride != null ? worseOverride : true, Messages.Run_Summary_MoreTestsFailing(trN.getFailCount() - trP.getFailCount(), trN.getFailCount()));
                }
                if (trP.getFailCount() > trN.getFailCount()) {
                    return new Run.Summary(worseOverride != null ? worseOverride : false, Messages.Run_Summary_LessTestsFailing(trP.getFailCount() - trN.getFailCount(), trN.getFailCount()));
                }
                return new Run.Summary(worseOverride != null ? worseOverride : false, Messages.Run_Summary_TestsStillFailing(trN.getFailCount()));
            }
            return null;
        }
    }
}

