/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions.navigate;

import java.util.Collection;
import java.util.Stack;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.navigate.JSONNavigateAction;
import net.minidev.json.actions.path.TreePath;

public class CopyPathsAction
implements JSONNavigateAction {
    protected JSONObject destTree;
    protected JSONObject destBranch;
    protected Stack<Object> destNodeStack;

    @Override
    public boolean start(JSONObject source, Collection<String> pathsToCopy) {
        if (source == null) {
            this.destTree = null;
            return false;
        }
        this.destTree = new JSONObject();
        return pathsToCopy != null && pathsToCopy.size() != 0;
    }

    @Override
    public boolean recurInto(TreePath jp, JSONObject o) {
        this.handleNewNode(jp, new JSONObject());
        return true;
    }

    private void handleNewNode(TreePath jp, Object node) {
        if (!jp.hasPrev()) {
            return;
        }
        if (this.destNodeStack.peek() instanceof JSONObject) {
            ((JSONObject)this.destNodeStack.peek()).put((Object)jp.curr(), node);
        } else if (this.destNodeStack.peek() instanceof JSONArray) {
            ((JSONArray)this.destNodeStack.peek()).add(node);
        }
        this.destNodeStack.push(node);
    }

    @Override
    public boolean recurInto(TreePath jp, JSONArray o) {
        this.handleNewNode(jp, new JSONArray());
        return true;
    }

    @Override
    public void foundLeafBeforePathEnd(TreePath jp, Object obj) {
        throw new IllegalArgumentException("branch is shorter than path - path not found in source: '" + jp.origin() + "'");
    }

    @Override
    public void pathTailNotFound(TreePath jp, Object source) {
        throw new IllegalArgumentException("cannot find next element of path - path not found in source: '" + jp.origin() + "'");
    }

    @Override
    public void handleLeaf(TreePath jp, Object o) {
        ((JSONObject)this.destNodeStack.peek()).put((Object)jp.curr(), o);
    }

    @Override
    public void handleLeaf(TreePath jp, int arrIndex, Object o) {
        ((JSONArray)this.destNodeStack.peek()).add(o);
    }

    @Override
    public void recurEnd(TreePath jp, JSONObject jo) {
        this.destNodeStack.pop();
    }

    @Override
    public void recurEnd(TreePath jp, JSONArray ja) {
        this.destNodeStack.pop();
    }

    @Override
    public boolean pathStart(String path) {
        this.destBranch = new JSONObject();
        this.destNodeStack = new Stack();
        this.destNodeStack.push(this.destBranch);
        return true;
    }

    @Override
    public void pathEnd(String path) {
        this.destTree.merge((Object)this.destBranch);
    }

    @Override
    public boolean failSilently(String path, Exception e) {
        return false;
    }

    @Override
    public boolean failFast(String path, Exception e) {
        return false;
    }

    @Override
    public void end() {
    }

    @Override
    public Object result() {
        return this.destTree;
    }
}

