/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.jobcacher.Cache;
import jenkins.plugins.jobcacher.CacheDescriptor;
import jenkins.plugins.jobcacher.CacheManager;
import jenkins.plugins.jobcacher.Messages;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CacheWrapper
extends SimpleBuildWrapper {
    private Long maxCacheSize;
    private boolean skipSave;
    private boolean skipRestore;
    private List<Cache> caches;
    private String defaultBranch;

    @DataBoundConstructor
    public CacheWrapper(List<Cache> caches) {
        this.setCaches(caches);
    }

    public ItemStorage<?> getStorage() {
        return GlobalItemStorage.get().getStorage();
    }

    public Long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @DataBoundSetter
    public void setMaxCacheSize(Long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public boolean getSkipSave() {
        return this.skipSave;
    }

    @DataBoundSetter
    public void setSkipSave(boolean skipSave) {
        this.skipSave = skipSave;
    }

    public boolean getSkipRestore() {
        return this.skipRestore;
    }

    @DataBoundSetter
    public void setSkipRestore(boolean skipRestore) {
        this.skipRestore = skipRestore;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @DataBoundSetter
    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public List<Cache> getCaches() {
        return CacheWrapper.wrapList(this.caches, Collections::unmodifiableList);
    }

    public void setCaches(List<Cache> caches) {
        this.caches = CacheWrapper.wrapList(caches, ArrayList::new);
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        List<Cache.Saver> cacheSavers = CacheManager.cache(this.getStorage(), build, workspace, launcher, listener, initialEnvironment, this.getCaches(), this.getDefaultBranch(), this.skipRestore);
        context.setDisposer((SimpleBuildWrapper.Disposer)new CacheDisposer(this.getStorage(), this.getMaxCacheSize(), this.getSkipSave(), this.getCaches(), cacheSavers, this.defaultBranch));
    }

    private static <T> List<T> wrapList(List<T> list, Function<List<T>, List<T>> listFactory) {
        return list == null ? Collections.emptyList() : listFactory.apply(list);
    }

    private static class CacheDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;
        private final ItemStorage<?> storage;
        private final Long maxCacheSize;
        private final boolean skipSave;
        private final List<Cache> caches;
        private final List<Cache.Saver> cacheSavers;
        private final String defaultBranch;

        @DataBoundConstructor
        public CacheDisposer(ItemStorage<?> storage, Long maxCacheSize, boolean skipSave, List<Cache> caches, List<Cache.Saver> cacheSavers, String defaultBranch) {
            this.storage = storage;
            this.maxCacheSize = maxCacheSize;
            this.skipSave = skipSave;
            this.caches = caches;
            this.cacheSavers = cacheSavers;
            this.defaultBranch = defaultBranch;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            if (build.getResult() != Result.FAILURE && build.getResult() != Result.ABORTED && !this.skipSave) {
                CacheManager.save(this.storage, build, workspace, launcher, listener, this.maxCacheSize, this.caches, this.cacheSavers, this.defaultBranch);
            }
        }
    }

    @Extension
    @Symbol(value={"jobcacher"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.CacheWrapper_DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public List<CacheDescriptor> getCacheDescriptors() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null) {
                return jenkins.getDescriptorList(Cache.class);
            }
            return Collections.emptyList();
        }
    }
}

