/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ObjectPath;
import jenkins.plugins.jobcacher.Cache;
import jenkins.plugins.jobcacher.CacheBuildLastAction;

public class CacheManager {
    private static final Logger LOG = Logger.getLogger(CacheManager.class.getName());
    private static final Map<String, Object> locks = new HashMap<String, Object>();

    public static ObjectPath getCachePath(ItemStorage<?> storage, Job<?, ?> job) {
        return storage.getObjectPath((Item)job, "cache");
    }

    public static ObjectPath getCachePath(ItemStorage<?> storage, Run<?, ?> run) {
        return CacheManager.getCachePath(storage, run.getParent());
    }

    public static ObjectPath getCachePathForBranch(ItemStorage<?> storage, Run<?, ?> run, String branch) {
        return storage.getObjectPathForBranch((Item)run.getParent(), "cache", branch);
    }

    private static Object getLock(Job<?, ?> j) {
        String jobFullName = j.getFullName();
        return locks.computeIfAbsent(jobFullName, k -> new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Cache.Saver> cache(ItemStorage<?> storage, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment, List<Cache> caches, String defaultBranch, boolean skipRestore) throws IOException, InterruptedException {
        ObjectPath cachePath = CacheManager.getCachePath(storage, run);
        ObjectPath defaultCachePath = null;
        if (defaultBranch != null && !defaultBranch.isEmpty()) {
            defaultCachePath = CacheManager.getCachePathForBranch(storage, run, URLEncoder.encode(defaultBranch, StandardCharsets.UTF_8));
        }
        LOG.fine("Preparing cache for build " + String.valueOf(run));
        ArrayList<Cache.Saver> cacheSavers = new ArrayList<Cache.Saver>();
        Object object = CacheManager.getLock(run.getParent());
        synchronized (object) {
            for (Cache cache : caches) {
                cacheSavers.add(cache.cache(cachePath, defaultCachePath, run, workspace, launcher, listener, initialEnvironment, skipRestore));
            }
        }
        return cacheSavers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(ItemStorage<?> storage, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, Long maxCacheSize, List<Cache> caches, List<Cache.Saver> cacheSavers, String defaultBranch) throws IOException, InterruptedException {
        ObjectPath cachePath = CacheManager.getCachePath(storage, run);
        ObjectPath defaultCachePath = null;
        if (defaultBranch != null && !defaultBranch.isEmpty()) {
            defaultCachePath = CacheManager.getCachePathForBranch(storage, run, URLEncoder.encode(defaultBranch, StandardCharsets.UTF_8));
        }
        boolean exceedsMaxCacheSize = CacheManager.exceedsMaxCacheSize(cachePath, run, workspace, launcher, listener, maxCacheSize, cacheSavers);
        Object object = CacheManager.getLock(run.getParent());
        synchronized (object) {
            if (exceedsMaxCacheSize) {
                listener.getLogger().println("Removing job cache as it has grown beyond configured maximum size of " + maxCacheSize + "M. Next build will start with no cache.");
                if (cachePath.exists()) {
                    cachePath.deleteRecursive();
                } else {
                    listener.getLogger().println("Cache does not exist even though max cache was reached.  You may want to consider increasing maximum cache size.");
                }
            } else {
                LOG.fine("Saving cache for build " + String.valueOf(run));
                for (Cache.Saver saver : cacheSavers) {
                    saver.save(cachePath, defaultCachePath, run, workspace, launcher, listener);
                }
            }
        }
        if (run.getAction(CacheBuildLastAction.class) == null) {
            run.addAction((Action)new CacheBuildLastAction(caches));
        } else {
            ((CacheBuildLastAction)run.getAction(CacheBuildLastAction.class)).addCaches(caches);
        }
    }

    private static boolean exceedsMaxCacheSize(ObjectPath cachePath, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, Long maxCacheSize, List<Cache.Saver> cacheSavers) throws IOException, InterruptedException {
        if (maxCacheSize == null || maxCacheSize == 0L) {
            return false;
        }
        long totalSize = 0L;
        for (Cache.Saver saver : cacheSavers) {
            totalSize += saver.calculateSize(cachePath, run, workspace, launcher, listener);
        }
        return totalSize > maxCacheSize * 1024L * 1024L;
    }
}

