/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher.pipeline;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.jobcacher.Cache;
import jenkins.plugins.jobcacher.CacheManager;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class CacheStepExecution
extends GeneralNonBlockingStepExecution {
    private static final long serialVersionUID = 1L;
    private final Long maxCacheSize;
    private final boolean skipSave;
    private final boolean skipRestore;
    private final List<Cache> caches;
    private final String defaultBranch;

    protected CacheStepExecution(StepContext context, Long maxCacheSize, boolean skipSave, boolean skipRestore, List<Cache> caches, String defaultBranch) {
        super(context);
        this.maxCacheSize = maxCacheSize;
        this.caches = caches;
        this.defaultBranch = defaultBranch;
        this.skipSave = skipSave;
        this.skipRestore = skipRestore;
    }

    public boolean start() throws Exception {
        this.run(this::execute);
        return false;
    }

    private void execute() throws Exception {
        StepContext context = this.getContext();
        Run run = (Run)context.get(Run.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        EnvVars initialEnvironment = (EnvVars)context.get(EnvVars.class);
        List<Cache.Saver> cacheSavers = CacheManager.cache(GlobalItemStorage.get().getStorage(), run, workspace, launcher, listener, initialEnvironment, this.caches, this.defaultBranch, this.skipRestore);
        context.newBodyInvoker().withContext((Object)context).withCallback((BodyExecutionCallback)new NonBlockingExecutionCallback(this.maxCacheSize, this.skipSave, this.caches, cacheSavers)).start();
    }

    private class NonBlockingExecutionCallback
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;
        private final Long maxCacheSize;
        private final boolean skipSave;
        private final List<Cache> caches;
        private final List<Cache.Saver> cacheSavers;

        public NonBlockingExecutionCallback(Long maxCacheSize, boolean skipSave, List<Cache> caches, List<Cache.Saver> cacheSavers) {
            this.maxCacheSize = maxCacheSize;
            this.skipSave = skipSave;
            this.caches = caches;
            this.cacheSavers = cacheSavers;
        }

        public void onSuccess(StepContext context, Object result) {
            CacheStepExecution.this.run(() -> {
                try {
                    this.complete(context);
                    context.onSuccess(result);
                }
                catch (Throwable t) {
                    context.onFailure(t);
                }
            });
        }

        public void onFailure(StepContext context, Throwable t) {
            context.onFailure(t);
        }

        private void complete(StepContext context) throws IOException, InterruptedException {
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            if (this.skipSave) {
                listener.getLogger().println("Skipping save due to skipSave being set to true.");
                return;
            }
            Run run = (Run)context.get(Run.class);
            FilePath workspace = (FilePath)context.get(FilePath.class);
            Launcher launcher = (Launcher)context.get(Launcher.class);
            CacheManager.save(GlobalItemStorage.get().getStorage(), run, workspace, launcher, listener, this.maxCacheSize, this.caches, this.cacheSavers, CacheStepExecution.this.defaultBranch);
        }
    }

    private static class ExecutionCallback
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;
        private final Long maxCacheSize;
        private final boolean skipSave;
        private final List<Cache> caches;
        private final List<Cache.Saver> cacheSavers;

        public ExecutionCallback(Long maxCacheSize, boolean skipSave, List<Cache> caches, List<Cache.Saver> cacheSavers) {
            this.maxCacheSize = maxCacheSize;
            this.skipSave = skipSave;
            this.caches = caches;
            this.cacheSavers = cacheSavers;
        }

        public void onSuccess(StepContext context, Object result) {
            try {
                this.complete(context);
                context.onSuccess(result);
            }
            catch (Throwable t) {
                context.onFailure(t);
            }
        }

        public void onFailure(StepContext context, Throwable t) {
            context.onFailure(t);
        }

        private void complete(StepContext context) throws IOException, InterruptedException {
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            if (this.skipSave) {
                listener.getLogger().println("Skipping save due to skipSave being set to true.");
                return;
            }
            Run run = (Run)context.get(Run.class);
            FilePath workspace = (FilePath)context.get(FilePath.class);
            Launcher launcher = (Launcher)context.get(Launcher.class);
            CacheManager.save(GlobalItemStorage.get().getStorage(), run, workspace, launcher, listener, this.maxCacheSize, this.caches, this.cacheSavers, null);
        }
    }
}

