/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jobimport.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jenkins.ci.plugins.jobimport.model.RemoteFolder;
import org.jenkins.ci.plugins.jobimport.model.RemoteItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RemoteItemUtils {
    public static String fullName(RemoteItem item) {
        if (item == null) {
            return "";
        }
        if (!item.hasParent()) {
            return item.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.insert(0, item.getName());
        for (RemoteFolder parent = item.getParent(); parent != null; parent = parent.getParent()) {
            sb.insert(0, "/").insert(0, parent.getName());
        }
        return sb.toString();
    }

    private static String fullName(RemoteItem item, String name) {
        return item.hasParent() ? RemoteItemUtils.fullName(item.getParent(), name) : name;
    }

    public static String text(Element e, String name) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() == 1) {
            Element e2 = (Element)nl.item(0);
            return e2.getTextContent();
        }
        return null;
    }

    public static String cleanRemoteString(String string) {
        return StringUtils.substring((String)StringEscapeUtils.escapeHtml4((String)string), (int)0, (int)4096);
    }

    public static RemoteItem getRemoteJob(SortedSet<RemoteItem> items, String jobUrl) {
        return RemoteItemUtils.findFirstMAtchingRemoteItem(items, jobUrl);
    }

    static RemoteItem findFirstMAtchingRemoteItem(SortedSet<RemoteItem> items, String filter) {
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            for (RemoteItem item : items) {
                if (!filter.trim().equals(item.getUrl().trim())) continue;
                return item;
            }
        }
        return null;
    }

    static List<RemoteItem> findRemoteItemAndDescendants(SortedSet<RemoteItem> items, String filter) {
        ArrayList<RemoteItem> list = new ArrayList<RemoteItem>();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            for (RemoteItem item : items) {
                if (!filter.trim().equals(item.getUrl().trim())) continue;
                list.add(item);
                if (!item.isFolder()) break;
                list.addAll(RemoteItemUtils.populateAllChildren((RemoteFolder)item));
                break;
            }
        }
        return list;
    }

    private static List<RemoteItem> populateAllChildren(RemoteFolder folder) {
        ArrayList<RemoteItem> list = new ArrayList<RemoteItem>();
        for (RemoteItem item : folder.getChildren()) {
            list.add(item);
            if (!item.isFolder()) continue;
            list.addAll(RemoteItemUtils.populateAllChildren((RemoteFolder)item));
        }
        return list;
    }
}

