/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.selector.perforce;

import com.perforce.p4java.core.IFix;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.RunScmChangeExtractor;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.plugins.jira.selector.perforce.JobIssueSelector;
import hudson.scm.ChangeLogSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.kohsuke.stapler.DataBoundConstructor;

public class P4JobIssueSelector
extends JobIssueSelector {
    private static final Logger LOGGER = Logger.getLogger(P4JobIssueSelector.class.getName());

    @DataBoundConstructor
    public P4JobIssueSelector() {
    }

    @Override
    protected void addJobIdsFromChangeLog(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> issueIds) {
        this.getLogger().finer("Searching for Jira issues in Perforce jobs in " + String.valueOf(build));
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : RunScmChangeExtractor.getChanges(build)) {
            for (ChangeLogSet.Entry change : set) {
                P4ChangeEntry p4ChangeEntry;
                List jobs;
                this.getLogger().fine("Looking for Jira IDs as Perforce Jobs in " + change.getMsg());
                if (!P4ChangeEntry.class.isAssignableFrom(change.getClass()) || (jobs = (p4ChangeEntry = (P4ChangeEntry)change).getJobs()) == null) continue;
                for (IFix job : jobs) {
                    String jobId = job.getJobId();
                    if (!issueIds.add(jobId)) continue;
                    this.getLogger().finer("Added Perforce job id " + jobId + " from build " + String.valueOf(build));
                }
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Extension(optional=true)
    @Symbol(value={"P4Selector"})
    public static final class DescriptorImpl
    extends Descriptor<AbstractIssueSelector> {
        public String getDisplayName() {
            return Messages.P4JobIssueSelector_DisplayName();
        }
    }
}

