/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.pipeline;

import com.atlassian.jira.rest.client.api.RestClientException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.EnvironmentExpander;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.model.JiraIssueField;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class IssueFieldUpdateStep
extends Builder
implements SimpleBuildStep {
    private AbstractIssueSelector issueSelector;
    public String fieldId;
    public String fieldValue;

    public AbstractIssueSelector getIssueSelector() {
        return this.issueSelector;
    }

    @DataBoundSetter
    public void setIssueSelector(AbstractIssueSelector issueSelector) {
        this.issueSelector = issueSelector;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    @DataBoundSetter
    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    @DataBoundSetter
    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    @DataBoundConstructor
    public IssueFieldUpdateStep(AbstractIssueSelector issueSelector, String fieldId, String fieldValue) {
        this.issueSelector = issueSelector;
        this.fieldId = fieldId;
        this.fieldValue = fieldValue;
    }

    public String prepareFieldId(String fieldId) {
        Object prepared = fieldId;
        if (!((String)prepared).startsWith("customfield_")) {
            prepared = "customfield_" + (String)prepared;
        }
        return prepared;
    }

    public void perform(Run<?, ?> run, EnvVars env, TaskListener listener) throws IOException {
        Set<String> issues;
        PrintStream logger = listener.getLogger();
        AbstractIssueSelector selector = this.issueSelector;
        if (selector == null) {
            logger.println("[Jira][IssueFieldUpdateStep] No issue selector found!");
            throw new IOException("[Jira][IssueFieldUpdateStep] No issue selector found!");
        }
        JiraSite site = JiraSite.get(run.getParent());
        if (site == null) {
            logger.println(Messages.NoJiraSite());
            run.setResult(Result.FAILURE);
            return;
        }
        JiraSession session = site.getSession((Item)run.getParent());
        if (session == null) {
            logger.println(Messages.NoRemoteAccess());
            run.setResult(Result.FAILURE);
            return;
        }
        try {
            issues = selector.findIssueIds(run, site, listener);
            if (issues.isEmpty()) {
                logger.println("[Jira][IssueFieldUpdateStep] Issue list is empty!");
                return;
            }
        }
        catch (RestClientException e) {
            logger.println(e.getMessage());
            return;
        }
        List<JiraIssueField> fields = Collections.singletonList(new JiraIssueField(this.prepareFieldId(this.getFieldId()), EnvironmentExpander.expandVariable(this.getFieldValue(), env)));
        try {
            for (String issue : issues) {
                this.submitFields(session, issue, fields, logger);
            }
        }
        catch (RestClientException e) {
            logger.println(e.getMessage());
        }
    }

    public boolean requiresWorkspace() {
        return false;
    }

    @Deprecated
    public void submitFields(JiraSession session, String issueId, List<JiraIssueField> fields, PrintStream logger) {
        try {
            session.addFields(issueId, fields);
        }
        catch (RestClientException e) {
            if (((Integer)e.getStatusCode().or((Object)0)).equals(404)) {
                logger.println("[Jira] " + issueId + " - Jira issue not found");
            }
            if (((Integer)e.getStatusCode().or((Object)0)).equals(403)) {
                logger.println("[Jira] " + issueId + " - Jenkins Jira user does not have permissions to comment on this issue");
            }
            if (((Integer)e.getStatusCode().or((Object)0)).equals(401)) {
                logger.println("[Jira] " + issueId + " - Jenkins Jira authentication problem");
            }
            logger.println(Messages.FailedToUpdateIssue(issueId));
            logger.println(e.getLocalizedMessage());
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"jiraUpdateIssueField"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckField_id(@QueryParameter String value) throws IOException, ServletException {
            if (Util.fixNull((String)value).trim().length() == 0) {
                return FormValidation.warning((String)Messages.JiraIssueFieldUpdater_NoIssueFieldID());
            }
            if (!value.matches("\\d+")) {
                return FormValidation.error((String)Messages.JiraIssueFieldUpdater_NotAtIssueFieldID());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraIssueFieldUpdater_DisplayName();
        }
    }
}

