/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

class VersionCreator {
    private static final Logger LOGGER = Logger.getLogger(VersionCreator.class.getName());
    private boolean failIfAlreadyExists = true;
    private String jiraVersion;
    private String jiraProjectKey;

    VersionCreator() {
    }

    public VersionCreator setFailIfAlreadyExists(boolean failIfAlreadyExists) {
        this.failIfAlreadyExists = failIfAlreadyExists;
        return this;
    }

    public VersionCreator setJiraVersion(String jiraVersion) {
        this.jiraVersion = jiraVersion;
        return this;
    }

    public VersionCreator setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
        return this;
    }

    protected boolean perform(Job<?, ?> project, Run<?, ?> build, TaskListener listener) {
        String realVersion = null;
        String realProjectKey = null;
        try {
            realVersion = build.getEnvironment(listener).expand(this.jiraVersion);
            realProjectKey = build.getEnvironment(listener).expand(this.jiraProjectKey);
            if (StringUtils.isEmpty((String)realVersion)) {
                throw new IllegalArgumentException("No version specified");
            }
            if (StringUtils.isEmpty((String)realProjectKey)) {
                throw new IllegalArgumentException("No project specified");
            }
            String finalRealVersion = realVersion;
            JiraSession session = this.getSiteForProject(project).getSession((Item)project);
            List existingVersions = Optional.ofNullable(session.getVersions(realProjectKey)).orElse(Collections.emptyList());
            if (existingVersions.stream().anyMatch(v -> v.getName().equals(finalRealVersion))) {
                listener.getLogger().println(Messages.JiraVersionCreator_VersionExists(realVersion, realProjectKey));
                if (this.failIfAlreadyExists) {
                    if (listener instanceof BuildListener) {
                        ((BuildListener)listener).finished(Result.FAILURE);
                    }
                    return false;
                }
                return true;
            }
            listener.getLogger().println(Messages.JiraVersionCreator_CreatingVersion(realVersion, realProjectKey));
            this.addVersion(realVersion, realProjectKey, session);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("Unable to add version %s to Jira project %s", new Object[]{realVersion, realProjectKey, e}));
            return false;
        }
    }

    protected void addVersion(String version, String projectKey, JiraSession session) {
        if (session == null) {
            LOGGER.warning("Jira session could not be established");
            return;
        }
        session.addVersion(version, projectKey);
    }

    protected JiraSite getSiteForProject(Job<?, ?> project) {
        return JiraSite.get(project);
    }
}

